/*
 * Decompiled with CFR 0.152.
 */
package com.philliphsu.bottomsheetpickers.time.grid;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import com.philliphsu.bottomsheetpickers.R;
import com.philliphsu.bottomsheetpickers.Utils;
import com.philliphsu.bottomsheetpickers.time.grid.NumbersGrid;

public class MinutesGrid
extends NumbersGrid {
    private static final String TAG = "MinutesGrid";
    private ImageButton mMinusButton;
    private ImageButton mPlusButton;

    public MinutesGrid(Context context) {
        super(context);
    }

    public MinutesGrid(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MinutesGrid(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMinusButton = (ImageButton)this.findViewById(R.id.dec_min);
        this.mPlusButton = (ImageButton)this.findViewById(R.id.inc_min);
        this.mMinusButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int value = MinutesGrid.this.getSelection() - 1;
                if (value < 0) {
                    value = 59;
                }
                MinutesGrid.this.setSelection(value);
                MinutesGrid.this.mSelectionListener.onNumberSelected(value);
            }
        });
        this.mPlusButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int value = MinutesGrid.this.getSelection() + 1;
                if (value == 60) {
                    value = 0;
                }
                MinutesGrid.this.setSelection(value);
                MinutesGrid.this.mSelectionListener.onNumberSelected(value);
            }
        });
    }

    @Override
    public void setSelection(int value) {
        super.setSelection(value);
        if (value % 5 == 0) {
            int positionOfValue = value / 5;
            this.setIndicator(this.getChildAt(positionOfValue));
        } else {
            this.clearIndicator();
        }
    }

    @Override
    void setTheme(Context context, boolean themeDark) {
        super.setTheme(context, themeDark);
        if (themeDark) {
            this.mMinusButton.setImageResource(R.drawable.ic_minus_circle_24dp);
            this.mPlusButton.setImageResource(R.drawable.ic_add_circle_24dp);
        } else {
            int colorActiveLight = ContextCompat.getColor((Context)context, (int)R.color.icon_color_active_light);
            this.mMinusButton.setImageDrawable(Utils.getTintedDrawable(context, R.drawable.ic_minus_circle_24dp, colorActiveLight));
            this.mPlusButton.setImageDrawable(Utils.getTintedDrawable(context, R.drawable.ic_add_circle_24dp, colorActiveLight));
        }
    }
}

