/*
 * Decompiled with CFR 0.152.
 */
package com.persion.quickpermissionlib;

import android.app.Activity;
import android.content.Context;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.persion.quickpermissionlib.QuickPermissionListener;

public class QuickPermission {
    private Activity activity;
    private String permission;
    private int permissionCode;
    private QuickPermissionListener permissionListener;

    public QuickPermission() {
    }

    public QuickPermission(Activity activity) {
        this.activity = activity;
    }

    public static QuickPermission newInstance(Activity activity) {
        QuickPermission quickPermission = new QuickPermission();
        quickPermission.setActivity(activity);
        return quickPermission;
    }

    public void onPermissionListener(QuickPermissionListener quickPermissionListener) {
        this.permissionListener = quickPermissionListener;
    }

    private void setActivity(Activity activity) {
        this.activity = activity;
    }

    public boolean requestPermission(String permission, int permissionCode) {
        if (ContextCompat.checkSelfPermission((Context)this.activity, (String)permission) != 0) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.activity, (String)permission)) {
                this.permissionListener.showRationale();
            } else {
                ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{permission}, (int)permissionCode);
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean isGranted(String permission) {
        return ContextCompat.checkSelfPermission((Context)this.activity, (String)permission) == 0;
    }

    public void quick(String permission, int permissionCode, QuickPermissionListener permissionListener) {
        this.permissionCode = permissionCode;
        this.permissionListener = permissionListener;
        this.permission = permission;
        if (!this.isGranted(permission)) {
            this.requestPermission(permission, permissionCode);
        } else {
            permissionListener.permissionGranted();
        }
    }

    public void quickResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == this.permissionCode) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.permissionListener.permissionGranted();
            } else {
                this.permissionListener.permissionDenied();
            }
            return;
        }
    }
}

