/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.mapapi;

import com.perforce.p4java.common.base.OSUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class MapChar {
    static final int PARAM_BASE_PERCENT = 0;
    static final int PARAM_BASE_STARS = 10;
    static final int PARAM_BASE_DOTS = 20;
    static final int PARAM_BASE_TOP = 23;
    char c;
    int paramNumber;
    MapCharClass cc;
    int caseMode;

    int compare(char oc) {
        return this.caseMode == 0 || !OSUtils.isWindows() ? this.c - oc : String.valueOf(this.c).compareToIgnoreCase(String.valueOf(oc));
    }

    boolean isEqual(char oc) {
        return this.compare(oc) == 0;
    }

    public char name() {
        return this.cc.chr;
    }

    public boolean isWild() {
        return this.cc.isWild;
    }

    public boolean set(char[] p, AtomicInteger pos, AtomicInteger nStars, AtomicInteger nDots, int caseMode) {
        this.caseMode = caseMode;
        if (pos.get() == p.length || p[pos.get()] == '\u0000') {
            this.cc = MapCharClass.cEOS;
            this.c = '\u0000';
            return false;
        }
        this.c = p[pos.get()];
        if (p[pos.get()] == '/') {
            this.cc = MapCharClass.cSLASH;
            pos.incrementAndGet();
        } else if (pos.get() <= p.length - 3 && p[pos.get()] == '.' && p[pos.get() + 1] == '.' && p[pos.get() + 2] == '.') {
            this.cc = MapCharClass.cDOTS;
            this.paramNumber = 20 + nDots.getAndAdd(1);
            pos.addAndGet(3);
        } else if (pos.get() <= p.length - 3 && p[pos.get()] == '%' && p[pos.get() + 1] == '%' && p[pos.get() + 2] >= '0' && p[pos.get() + 2] <= '9') {
            this.cc = MapCharClass.cPERC;
            this.paramNumber = 0 + (p[pos.get() + 2] - 48);
            pos.addAndGet(3);
        } else if (p[pos.get()] == '*') {
            this.cc = MapCharClass.cSTAR;
            this.paramNumber = 10 + nStars.getAndAdd(1);
            pos.incrementAndGet();
        } else {
            this.cc = MapCharClass.cCHAR;
            pos.incrementAndGet();
        }
        return true;
    }

    public String makeParam(String p, MapChar mc2, AtomicInteger wildSlot) {
        p = this.cc == MapCharClass.cDOTS && mc2.cc == MapCharClass.cDOTS ? (String)p + "..." : (String)p + "%%" + wildSlot.addAndGet(1);
        return p;
    }

    static enum MapCharClass {
        cEOS(0, '\u0000', false),
        cCHAR(1, 'c', false),
        cSLASH(2, '/', false),
        cPERC(3, '%', true),
        cSTAR(4, '*', true),
        cDOTS(5, '.', true);

        public char chr;
        public boolean isWild;
        public int code;

        private MapCharClass(int i, char c, boolean wild) {
            this.chr = c;
            this.isWild = wild;
            this.code = i;
        }
    }
}

