/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.exception.FileDecoderException;
import java.nio.ByteBuffer;

public enum Utf8ByteHelper {
    SINGLE,
    START,
    MULTI,
    UNKNOWN;


    public static Utf8ByteHelper parse(byte value) {
        int b = value & 0xFF;
        if ((b & 0x80) == 0) {
            return SINGLE;
        }
        if ((b & 0x80) != 0 && (b | 0xBF) == 191) {
            return MULTI;
        }
        if (Utf8ByteHelper.length(value) > 0) {
            return START;
        }
        return UNKNOWN;
    }

    public static int length(byte value) {
        int b = value & 0xFF;
        if ((b & 0xC0) == 192 && (b | 0xDF) == 223) {
            return 1;
        }
        if ((b & 0xE0) == 224 && (b | 0xEF) == 239) {
            return 2;
        }
        if ((b & 0xF0) == 240 && (b | 0xF7) == 247) {
            return 3;
        }
        return 0;
    }

    public static int findBufferLimit(ByteBuffer buffer) throws FileDecoderException {
        int r = buffer.remaining();
        block5: for (int i = 1; i <= 4; ++i) {
            int pos = r - i;
            byte b = buffer.get(pos);
            Utf8ByteHelper t = Utf8ByteHelper.parse(b);
            switch (t) {
                case START: {
                    int bytesInCharacter = Utf8ByteHelper.length(b) + 1;
                    if (pos + bytesInCharacter <= r) {
                        return pos + bytesInCharacter;
                    }
                    return pos;
                }
                case SINGLE: {
                    throw new FileDecoderException("Corrupt UTF8; single byte in multi byte sequence.");
                }
                case MULTI: {
                    continue block5;
                }
                default: {
                    throw new FileDecoderException("Corrupt UTF8; Unknown byte type. " + String.format("0x%02X", b));
                }
            }
        }
        throw new FileDecoderException("Corrupt UTF8; no start byte found.");
    }
}

