/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.proto;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.exception.UnimplementedError;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FlowControl {
    public static final String TRACE_PREFIX = "FlowControl";
    public static final int FLUSH_CMD_LENGTH = 60;
    public static final int DEFAULT_LO_MARK = 700;
    public static final long DEFAULT_HI_MARK = 2000L;
    private long loMark = 700L;
    private long hiMark = 2000L;
    private long currentLoMark = 0L;
    private long currentHiMark = 0L;
    private RpcPacketDispatcher mainDispatcher = null;
    private Properties props = null;

    public FlowControl(RpcPacketDispatcher mainDispatcher, Properties props) {
        this.mainDispatcher = mainDispatcher;
        this.props = props;
    }

    public void processFlushCommandFromServer(RpcConnection rpcConnection, RpcFunctionSpec funcSpec, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpc connection passed to FlowControl.processFlushCommandFromServer()");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null results map passed to FlowControl.processFlushCommandFromServer()");
        }
        if (funcSpec == null) {
            throw new NullPointerError("Null function name passed to FlowControl.processFlushCommandFromServer()");
        }
        if (funcSpec == RpcFunctionSpec.PROTOCOL_FLUSH1) {
            try {
                this.sendFlush2(rpcConnection, resultsMap);
            }
            catch (Exception exc) {
                Log.exception(exc);
                throw new ProtocolError("Format error in FlowControl.processFlushCommandFromServer");
            }
        } else {
            if (funcSpec == RpcFunctionSpec.PROTOCOL_FLUSH2) {
                throw new UnimplementedError("Unimplemented flush2 handler!");
            }
            throw new ProtocolError("Unexpected flow command in processFlushCommandFromServer: '" + funcSpec + "'");
        }
    }

    public void sendFlush1(RpcConnection rpcConnection, Map<String, Object> resultsMap) {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpc connection passed to FlowControl.sendFlush1()");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null rpc result map passed to FlowControl.sendFlush1()");
        }
        String hwmStr = (String)resultsMap.get("himark");
        String seqNumStr = (String)resultsMap.get("fseq");
        String rseqNumStr = (String)resultsMap.get("rseq");
        HashMap<String, Object> flushMap = new HashMap<String, Object>();
        if (hwmStr != null) {
            flushMap.put("himark", "" + new Long(hwmStr));
        }
        if (seqNumStr != null) {
            flushMap.put("fseq", "" + new Long(seqNumStr));
        }
        if (rseqNumStr != null) {
            flushMap.put("rseq", "" + new Long(rseqNumStr));
        }
        RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_FLUSH1, flushMap, null);
    }

    public void sendFlush2(RpcConnection rpcConnection, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpc connection passed to FlowControl.sendFlush2()");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null rpc result map passed to FlowControl.sendFlush2()");
        }
        String hwmStr = (String)resultsMap.get("himark");
        String seqNumStr = (String)resultsMap.get("fseq");
        String rseqNumStr = (String)resultsMap.get("rseq");
        HashMap<String, Object> flushMap = new HashMap<String, Object>();
        if (hwmStr != null) {
            flushMap.put("himark", "" + new Long(hwmStr));
        }
        if (seqNumStr != null) {
            flushMap.put("fseq", "" + new Long(seqNumStr));
        }
        if (rseqNumStr != null) {
            flushMap.put("rseq", "" + new Long(rseqNumStr));
        }
        RpcPacket flush2Packet = RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_FLUSH2, flushMap, null);
        rpcConnection.putRpcPacket(flush2Packet);
    }

    public void incrementCurrentHiMark(int incr) {
        this.currentHiMark += (long)incr;
    }

    public void decrementCurrentHiMark(int decr) {
        this.currentHiMark -= (long)decr;
    }

    public long getLoMark() {
        return this.loMark;
    }

    public void setLoMark(long loMark) {
        this.loMark = loMark;
    }

    public long getHiMark() {
        return this.hiMark;
    }

    public void setHiMark(long hiMark) {
        this.hiMark = hiMark;
    }

    public long getCurrentLoMark() {
        return this.currentLoMark;
    }

    public void setCurrentLoMark(long currentLoMark) {
        this.currentLoMark = currentLoMark;
    }

    public long getCurrentHiMark() {
        return this.currentHiMark;
    }

    public void setCurrentHiMark(long currentHiMark) {
        this.currentHiMark = currentHiMark;
    }
}

