/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.helper;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;

public class MD5Digester {
    private static final String DIGEST_TYPE = "MD5";
    private static final int LENGTH_OF_HEX_STRING = 32;
    private int bufferSize = 8192;
    private MessageDigest messageDigest = null;
    private long byteCount = 0L;

    public MD5Digester() throws P4JavaError {
        try {
            this.messageDigest = MessageDigest.getInstance(DIGEST_TYPE);
            this.messageDigest.reset();
        }
        catch (NoSuchAlgorithmException exc) {
            throw new P4JavaError("Unable to create an MD5 digester for P4Java: " + exc.getLocalizedMessage(), exc);
        }
    }

    public MD5Digester(@Nonnull int bufferSize) {
        this();
        this.bufferSize = Objects.requireNonNull(bufferSize);
    }

    void setMessageDigest(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    public byte[] digestAsBytes() {
        return this.messageDigest.digest();
    }

    @Nullable
    public String digestFileAs32ByteHex(@Nonnull File file) {
        Objects.requireNonNull(file, "Null file passed to MD5Digester.digestFileAs32ByteHex()");
        if (Files.isReadable(file.toPath())) {
            String string;
            FileInputStream inStream = new FileInputStream(file);
            try {
                int inBytesRead;
                this.reset();
                byte[] inBytes = new byte[this.bufferSize];
                while ((inBytesRead = inStream.read(inBytes)) > 0) {
                    this.update(inBytes, 0, inBytesRead);
                }
                string = this.digestAs32ByteHex();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ioexc) {
                    Log.error("error digesting file: " + file.getPath() + "; exception follows...", new Object[0]);
                    Log.exception(ioexc);
                }
            }
            inStream.close();
            return string;
        }
        return null;
    }

    public void reset() {
        this.messageDigest.reset();
        this.byteCount = 0L;
    }

    public void update(byte[] bytes, int off, int len) {
        if (Objects.nonNull(bytes)) {
            this.messageDigest.update(bytes, off, len);
            this.byteCount += (long)len;
        }
    }

    public String digestAs32ByteHex() {
        String retStr = new BigInteger(1, this.messageDigest.digest()).toString(16).toUpperCase();
        if (retStr.length() > 0 && retStr.length() <= 32) {
            return StringUtils.leftPad((String)retStr, (int)32, (char)'0');
        }
        throw new P4JavaError("Bad 32 byte digest string size in MD5Digester.digestAs32ByteHex; string: " + retStr + "; length: " + retStr.length());
    }

    @Nullable
    public String digestFileAs32ByteHex(@Nonnull File file, @Nullable Charset charset) {
        return this.digestFileAs32ByteHex(file, charset, false);
    }

    @Nullable
    public String digestFileAs32ByteHex(@Nonnull File file, @Nullable Charset charset, boolean doesNeedConvertLineEndings) {
        return this.digestFileAs32ByteHex(file, charset, doesNeedConvertLineEndings, null);
    }

    @Nullable
    public String digestFileAs32ByteHex(@Nonnull File file, @Nullable Charset charset, boolean isRequireLineEndingConvert, @Nullable ClientLineEnding clientLineEnding) {
        Objects.requireNonNull(file, "Null file passed to MD5Digester.digestFileAs32ByteHex()");
        if (Files.isReadable(file.toPath())) {
            String string;
            FileInputStream inStream = new FileInputStream(file);
            try {
                this.reset();
                if (Objects.nonNull(charset)) {
                    this.digestEncodedStreamToUtf8(inStream, charset, isRequireLineEndingConvert, clientLineEnding);
                } else {
                    this.digestStream(inStream, isRequireLineEndingConvert, clientLineEnding);
                }
                string = this.digestAs32ByteHex();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ioexc) {
                    Log.error("error digesting file: " + file.getPath() + "; exception follows...", new Object[0]);
                    Log.exception(ioexc);
                }
            }
            inStream.close();
            return string;
        }
        return null;
    }

    private void digestEncodedStreamToUtf8(@Nonnull InputStream inStream, @Nonnull Charset charset, boolean isRequireLineEndingConvert, @Nullable ClientLineEnding clientLineEnding) throws IOException {
        try (BOMInputStream unicodeInputStream = new BOMInputStream(inStream, false, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE});){
            int read;
            if (unicodeInputStream.hasBOM() && charset.name() == "UTF-16") {
                charset = Charset.forName(unicodeInputStream.getBOMCharsetName());
            }
            InputStreamReader encodedStreamReader = new InputStreamReader((InputStream)unicodeInputStream, charset);
            CharsetEncoder utf8CharsetEncoder = CharsetDefs.UTF8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            char[] buffer = new char[this.bufferSize];
            while ((read = encodedStreamReader.read(buffer)) > 0) {
                ByteBuffer utf8ByteBuffer = utf8CharsetEncoder.encode(CharBuffer.wrap(buffer, 0, read));
                if (isRequireLineEndingConvert) {
                    ByteBuffer convert = this.findAndReplaceEncodedClientLineEndingIfRequireLineEndingCovert(encodedStreamReader, utf8CharsetEncoder, utf8ByteBuffer, clientLineEnding);
                    this.update(convert.array(), convert.arrayOffset(), convert.limit());
                    continue;
                }
                this.update(utf8ByteBuffer.array(), utf8ByteBuffer.arrayOffset(), utf8ByteBuffer.limit());
            }
        }
    }

    private ByteBuffer findAndReplaceEncodedClientLineEndingIfRequireLineEndingCovert(@Nonnull InputStreamReader encodedStreamReader, @Nonnull CharsetEncoder utf8CharsetEncoder, @Nonnull ByteBuffer initialUtf8ByteBuffer, @Nullable ClientLineEnding clientLineEnding) throws IOException {
        int limit = initialUtf8ByteBuffer.limit();
        byte[] allUtf8Bytes = Arrays.copyOfRange(initialUtf8ByteBuffer.array(), initialUtf8ByteBuffer.arrayOffset(), limit);
        byte lastByte = initialUtf8ByteBuffer.get(limit - 1);
        int offset = this.findOffsetOfNextClientLineEndingIfReadBytesEndWithFirstByteOfClientLineEnding(lastByte, clientLineEnding);
        while (offset > 0) {
            char[] followingPotentialClientLineEndingChars = new char[offset];
            if ((offset = encodedStreamReader.read(followingPotentialClientLineEndingChars)) <= 0) continue;
            ByteBuffer moreBuffer = utf8CharsetEncoder.encode(CharBuffer.wrap(followingPotentialClientLineEndingChars, 0, offset));
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(allUtf8Bytes);
            outputStream.write(Arrays.copyOfRange(moreBuffer.array(), moreBuffer.arrayOffset(), moreBuffer.limit()));
            allUtf8Bytes = outputStream.toByteArray();
            lastByte = allUtf8Bytes[allUtf8Bytes.length - 1];
            offset = this.findOffsetOfNextClientLineEndingIfReadBytesEndWithFirstByteOfClientLineEnding(lastByte, clientLineEnding);
        }
        return this.convertToP4dServerEndingsIfRequired(allUtf8Bytes, 0, allUtf8Bytes.length, clientLineEnding);
    }

    private int findOffsetOfNextClientLineEndingIfReadBytesEndWithFirstByteOfClientLineEnding(byte lastByte, @Nullable ClientLineEnding clientLineEnding) {
        byte[] lineEndBytes;
        int more = -1;
        if (this.isRequireConvertClientOrLocalLineEndingToServerFormat(clientLineEnding) && lastByte == (lineEndBytes = ClientLineEnding.getLineEndBytes(clientLineEnding))[0]) {
            return lineEndBytes.length - 1;
        }
        return more;
    }

    private boolean isRequireConvertClientOrLocalLineEndingToServerFormat(@Nullable ClientLineEnding clientLineEnding) {
        boolean isLocalLineEndingSameAsServerFormat = ClientLineEnding.CONVERT_TEXT;
        if (Objects.nonNull((Object)clientLineEnding)) {
            isLocalLineEndingSameAsServerFormat = ClientLineEnding.needsLineEndFiltering(clientLineEnding);
        }
        return isLocalLineEndingSameAsServerFormat;
    }

    private ByteBuffer convertToP4dServerEndingsIfRequired(@Nonnull byte[] sourceBytes, int start, int length, @Nullable ClientLineEnding clientLineEnding) {
        ByteBuffer convertedByteBuffer;
        if (this.isRequireConvertClientOrLocalLineEndingToServerFormat(clientLineEnding)) {
            convertedByteBuffer = ByteBuffer.allocate(length);
            byte p4dServerLineEnding = ClientLineEnding.FST_L_LF_BYTES[0];
            byte[] clientLineEndBytes = ClientLineEnding.getLineEndBytes(clientLineEnding);
            for (int i = start; i < length; ++i) {
                if (this.doesSourceBytesUseSameClientLineEnding(sourceBytes, i, length, clientLineEndBytes)) {
                    convertedByteBuffer.put(p4dServerLineEnding);
                    i += clientLineEndBytes.length - 1;
                    continue;
                }
                convertedByteBuffer.put(sourceBytes[i]);
            }
            convertedByteBuffer.flip();
        } else {
            convertedByteBuffer = ByteBuffer.wrap(sourceBytes, start, length);
        }
        return convertedByteBuffer;
    }

    private boolean doesSourceBytesUseSameClientLineEnding(@Nonnull byte[] sourceBytes, int indexOfSourceBytes, int length, byte[] clientLineEndBytes) {
        boolean isSame = false;
        int potentialLastIndex = indexOfSourceBytes + clientLineEndBytes.length - 1;
        if (potentialLastIndex < length) {
            byte[] subSourceBytes = Arrays.copyOfRange(sourceBytes, indexOfSourceBytes, potentialLastIndex + 1);
            isSame = Arrays.equals(subSourceBytes, clientLineEndBytes);
        }
        return isSame;
    }

    private void digestStream(@Nonnull InputStream inStream, boolean isRequireLineEndingConvert, @Nullable ClientLineEnding clientLineEnding) throws IOException {
        int read;
        byte[] buffer = new byte[this.bufferSize];
        while ((read = inStream.read(buffer)) > 0) {
            int start = 0;
            if (isRequireLineEndingConvert) {
                ByteBuffer convert = this.findAndReplaceNonEncodedClientLineEndingIfRequireLineEndingConvert(inStream, buffer, read, clientLineEnding);
                this.update(convert.array(), convert.arrayOffset(), convert.limit());
                continue;
            }
            this.update(buffer, start, read);
        }
    }

    private ByteBuffer findAndReplaceNonEncodedClientLineEndingIfRequireLineEndingConvert(@Nonnull InputStream inStream, @Nonnull byte[] readBuffer, int totalBytesReadIntoBuffer, @Nullable ClientLineEnding clientLineEnding) throws IOException {
        byte lastReadByte = readBuffer[totalBytesReadIntoBuffer - 1];
        byte[] allBytes = Arrays.copyOfRange(readBuffer, 0, totalBytesReadIntoBuffer);
        int length = totalBytesReadIntoBuffer;
        int offset = this.findOffsetOfNextClientLineEndingIfReadBytesEndWithFirstByteOfClientLineEnding(lastReadByte, clientLineEnding);
        while (offset > 0) {
            byte[] potentialClientLineEndingBytes = new byte[offset];
            if ((offset = inStream.read(potentialClientLineEndingBytes)) <= 0) continue;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(allBytes);
            outputStream.write(Arrays.copyOfRange(potentialClientLineEndingBytes, 0, offset));
            allBytes = outputStream.toByteArray();
            length = allBytes.length;
            offset = this.findOffsetOfNextClientLineEndingIfReadBytesEndWithFirstByteOfClientLineEnding(allBytes[allBytes.length - 1], clientLineEnding);
        }
        return this.convertToP4dServerEndingsIfRequired(allBytes, 0, length, clientLineEnding);
    }

    public void update(String str) {
        if (Objects.nonNull(str)) {
            try {
                this.messageDigest.update(str.getBytes(CharsetDefs.UTF8.name()));
            }
            catch (UnsupportedEncodingException uee) {
                Log.exception(uee);
                throw new P4JavaError(uee);
            }
        }
    }

    public void update(byte[] bytes) {
        if (Objects.nonNull(bytes)) {
            this.messageDigest.update(bytes);
        }
    }

    public long getByteCount() {
        return this.byteCount;
    }
}

