/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.exception.FileEncoderException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientHelper;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientSystemFileMatchCommands;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.DigestResult;
import com.perforce.p4java.impl.mapbased.rpc.handles.ClientFile;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcByteBufferOutput;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceDigestType;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.AppleFileHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.util.FilesHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.UnmappableCharacterException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ClientSystemFileCommands {
    public static final String TRACE_PREFIX = "ClientSystemFileCommands";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".p4j";
    public static final String SYSTEM_TMPDIR_PROPS_KEY = "java.io.tmpdir";
    public static final String SYSTEM_TMPDIR_DEFAULT = "/tmp";
    public static final String PERMS_RW = "rw";
    protected static final String RECONCILE_HANDLER_SKIP_ADD_KEY = "skipAdd";
    private Properties props = null;
    private RpcServer server = null;
    private String tmpDirName = null;
    private ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();
    private String filePath = null;
    private long fileSize = 0L;
    private long currentSize = 0L;
    private ClientSystemFileMatchCommands fileMatchCommands;

    protected ClientSystemFileCommands(Properties props, RpcServer server, ClientSystemFileMatchCommands fileMatchCommands) {
        this.props = props;
        this.server = server;
        this.fileMatchCommands = fileMatchCommands;
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY));
        if (this.tmpDirName == null) {
            this.tmpDirName = SYSTEM_TMPDIR_DEFAULT;
            Log.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead", new Object[0]);
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult chmodFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in chmodFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in chmodFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in chmodFile().");
        }
        String path = (String)resultsMap.get("path");
        String perms = (String)resultsMap.get("perms");
        String fileTypeStr = (String)resultsMap.get("type");
        String time = (String)resultsMap.get("time");
        RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(fileTypeStr);
        boolean fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
        try {
            cmdEnv.newHandler();
            RpcPerforceFile targetFile = new RpcPerforceFile(path, fileTypeStr);
            if (RpcPerforceFile.fileExists(targetFile, fstSymlink)) {
                if (time != null) {
                    targetFile.setLastModified(new Long(time) * 1000L);
                }
                if (perms != null) {
                    if (perms.equalsIgnoreCase(PERMS_RW)) {
                        this.fileCommands.setWritable(path, true);
                    } else {
                        this.fileCommands.setWritable(path, false);
                    }
                }
                switch (fileType) {
                    case FST_XTEXT: 
                    case FST_XBINARY: {
                        this.fileCommands.setExecutable(path, true, true);
                        break;
                    }
                }
            } else {
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CHMOD_FILE, 1, 34, new String[]{path}).toMap());
            }
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolError("Unexpected conversion error in ClientSystemFileCommands.chmodFile: " + nfe.getLocalizedMessage());
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new ConnectionException(exc.getLocalizedMessage(), exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult openFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in openFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in openFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in openFile().");
        }
        String function = (String)resultsMap.get("func");
        String clientPath = (String)resultsMap.get("path");
        String clientHandle = (String)resultsMap.get("handle");
        String modTime = (String)resultsMap.get("time");
        String noClobber = (String)resultsMap.get("noclobber");
        String perms = (String)resultsMap.get("perms");
        String fileTypeStr = (String)resultsMap.get("type");
        String fileSizeStr = (String)resultsMap.get("fileSize");
        String diffFlags = (String)resultsMap.get("diffFlags");
        String digest = (String)resultsMap.get("digest");
        String digestType = (String)resultsMap.get("digestType");
        RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(fileTypeStr);
        boolean fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
        cmdEnv.setSyncTime(0L);
        this.filePath = clientPath != null ? clientPath : null;
        this.fileSize = fileSizeStr != null ? new Long(fileSizeStr) : 0L;
        this.currentSize = 0L;
        boolean doChecksum = false;
        try {
            boolean useLocalDigester;
            RpcFunctionSpec f;
            CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
            if (handler == null) {
                CommandEnv commandEnv = cmdEnv;
                Objects.requireNonNull(commandEnv);
                handler = commandEnv.new CommandEnv.RpcHandler(clientHandle, false, new RpcPerforceFile(clientPath, fileTypeStr));
                cmdEnv.addHandler(handler);
            } else {
                handler.setFile(new RpcPerforceFile(clientPath, fileTypeStr));
                handler.getMap().clear();
            }
            if (digestType != null && new File(clientPath).exists()) {
                doChecksum = true;
            }
            ClientFile cfile = new ClientFile(handler);
            cfile.setArgs(resultsMap);
            cfile.setModTime(modTime);
            if (clientHandle.equals("sync") || cmdEnv.getCmdSpec().getCmdName().equals("sync") && clientHandle.equals("fault")) {
                handler.setError(false);
            }
            if ((f = RpcFunctionSpec.decode(function)).equals((Object)RpcFunctionSpec.CLIENT_OPENDIFF) || f.equals((Object)RpcFunctionSpec.CLIENT_OPENMATCH)) {
                cfile.setDiff(1);
                cfile.setDeleteOnClose(true);
                cfile.setDiffName(clientPath);
                if (diffFlags != null) {
                    cfile.setDiffFlags(diffFlags);
                }
                cfile.MakeGlobalTemp();
                if (f.equals((Object)RpcFunctionSpec.CLIENT_OPENMATCH)) {
                    this.fileMatchCommands.openMatch(rpcConnection, cmdEnv, resultsMap, cfile);
                }
            } else {
                String tmpFileName;
                if (doChecksum && !rpcConnection.getDigest(fileType, cfile.getFile(), RpcPerforceDigestType.GetType(digestType)).equals(digest)) {
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.NO_MODIFIED_FILE, 3, 34, new String[]{"update", clientPath}).toMap());
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
                if (cfile.getFile().exists() && cfile.getFile().isFile() && noClobber != null && cfile.getFile().canWrite()) {
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{clientPath}).toMap());
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
                cfile.getFile();
                if (RpcPerforceFile.fileExists(cfile.getFile(), fstSymlink) && cfile.getFile().isFile() && !cmdEnv.isSyncInPlace()) {
                    tmpFileName = RpcPerforceFile.createTempFileName(cfile.getFile().getParent());
                    cfile.setTmpFile(new RpcPerforceFile(tmpFileName, fileTypeStr));
                    if (perms != null && perms.equalsIgnoreCase(PERMS_RW)) {
                        this.fileCommands.setWritable(tmpFileName, true);
                    }
                } else if (cfile.getFile().isSymlink()) {
                    cfile.getFile().delete();
                    if (cfile.isSymlink()) {
                        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                    }
                } else if (cfile.getFile().isFile()) {
                    this.fileCommands.setWritable(clientPath, true);
                } else {
                    cfile.getFile().delete();
                    if (!FilesHelper.mkdirs(cfile.getFile())) {
                        handler.setError(true);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{clientPath}).toMap());
                        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                    }
                    try {
                        if (fstSymlink) {
                            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                        }
                        if (!cfile.getFile().createNewFile()) {
                            Log.warn("ClientSystemFileCommands.openFile: unable to create new target file", new Object[0]);
                        }
                        if (!cfile.getFile().canCopyAsIs()) {
                            tmpFileName = RpcPerforceFile.createTempFileName(this.tmpDirName);
                            cfile.setTmpFile(new RpcPerforceFile(tmpFileName, fileTypeStr));
                        }
                    }
                    catch (IOException ioexc) {
                        handler.setError(true);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE, 3, 34, new String[]{clientPath, ioexc.getLocalizedMessage()}).toMap());
                        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                    }
                }
                if (perms != null && perms.equalsIgnoreCase(PERMS_RW)) {
                    this.fileCommands.setWritable(clientPath, true);
                }
                if (cfile.getFile().getFileType().isExecutable()) {
                    this.fileCommands.setExecutable(clientPath, true, true);
                }
            }
            boolean bl = useLocalDigester = digestType == null && digest != null && !cmdEnv.isNonCheckedSyncs() && !cfile.isSymlink();
            if (useLocalDigester) {
                cfile.setServerDigest(digest);
            }
            if (!Files.exists(Path.of(cfile.getFile().getParent(), new String[0]), new LinkOption[0])) {
                Files.createDirectories(Path.of(cfile.getFile().getParent(), new String[0]), new FileAttribute[0]);
                handler.setTmpDir(true);
            }
            cfile.createStream(useLocalDigester, rpcConnection, digest);
        }
        catch (P4JavaError p4je) {
            throw p4je;
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new P4JavaError("Unexpected exception in ClientSystemFileCommands.openFile: " + exc.getLocalizedMessage() + exc, exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        RpcOutputStream outStream;
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in writeFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in writeFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in writeFile().");
        }
        String clientHandle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        if (handler == null) {
            throw new NullPointerError("Null client handler in writeFile().");
        }
        ClientFile cfile = new ClientFile(handler);
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (stateMap == null) {
            throw new NullPointerError("Null state map in ClientSystemFileCommands.writeFile().");
        }
        Map<String, Object> origArgs = cfile.getArgs();
        if (origArgs == null) {
            throw new NullPointerError("Null original argument map ClientSystemFileCommands.writeFile() state map");
        }
        String path = (String)origArgs.get("path");
        if (cfile.isSymlink()) {
            RpcPerforceFile tmpPath = cfile.getTmpFile();
            String linkPath = path;
            if (tmpPath != null) {
                try {
                    linkPath = tmpPath.toString();
                    cfile.getTmpStream().close();
                    tmpPath.delete();
                }
                catch (IOException e) {
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_DELETE_FILE, 3, 34, new String[]{"symlink tmpFile", linkPath}).toMap());
                }
            }
            if (linkPath != null) {
                this.convertFileDataMap(resultsMap, cmdEnv.getRpcConnection().getClientCharset(), cmdEnv.getRpcConnection().isUnicodeServer());
                String data = (String)resultsMap.get("data");
                if (data != null) {
                    data = data.replaceAll("(\\r|\\n)", "");
                    cfile.setSymTarget(data);
                    String link = SymbolicLinkHelper.createSymbolicLink(linkPath, data);
                    if (link == null) {
                        handler.setError(true);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE_TYPE, 3, 34, new String[]{"symlink", path}).toMap());
                        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                    }
                }
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
        }
        if ((outStream = cfile.getTmpStream()) == null) {
            outStream = cfile.getStream();
        }
        if (outStream == null) {
            throw new P4JavaError("No open file stream in ClientSystemFileCommands.writeFile()");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                long bytesWritten = outStream.write(resultsMap);
                this.currentSize = ClientHelper.sendBackWrittenDataBytes(cmdEnv, this.filePath, this.fileSize, this.currentSize, bytesWritten);
            } else {
                Log.error("output stream unexpectedly closed in writeFile", new Object[0]);
                handler.setError(true);
            }
        }
        catch (FileDecoderException e) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_DECODER_ERROR, 3, 34, new String[]{path == null ? "<unknown>" : path}).toMap());
            Log.error("failed to decode file " + (path == null ? "<unknown>" : path) + "; exception follows...", new Object[0]);
            Log.exception(e);
        }
        catch (FileEncoderException e) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_ENCODER_ERROR, 3, 34, new String[]{path == null ? "<unknown>" : path}).toMap());
            Log.error("failed to encode file " + (path == null ? "<unknown>" : path) + "; exception follows...", new Object[0]);
            Log.exception(e);
            if (ExceptionUtils.getRootCause((Throwable)e) instanceof UnmappableCharacterException) {
                Log.warn("cleaning up file " + (path == null ? "<unknown>" : path), new Object[0]);
                try {
                    outStream.close();
                    outStream.getFile().delete();
                }
                catch (IOException ex) {
                    Log.error("Unable to close file " + (path == null ? "<unknown>" : path), new Object[0]);
                    Log.exception(ex);
                }
            }
        }
        catch (IOException e) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{path == null ? "<unknown>" : path, e.getLocalizedMessage()}).toMap());
            Log.error("failed write for file " + (path == null ? "<unknown>" : path) + "; exception follows...", new Object[0]);
            Log.exception(e);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private void writeToStream(byte[] sourceBytes, int start, int length, OutputStream stream) throws IOException {
        if (ClientLineEnding.CONVERT_TEXT) {
            for (int i = start; i < length; ++i) {
                if (sourceBytes[i] == ClientLineEnding.FST_L_LF_BYTES[0]) {
                    stream.write(ClientLineEnding.FST_L_LOCAL_BYTES);
                    continue;
                }
                stream.write(sourceBytes[i]);
            }
        } else {
            stream.write(sourceBytes, start, length);
        }
    }

    private void writeToStream(byte[] sourceBytes, int start, int length, RpcByteBufferOutput stream) throws IOException {
        int remainingBytes = stream.getCapacity() - stream.getPosition();
        if (remainingBytes < length) {
            length = remainingBytes;
        }
        if (ClientLineEnding.CONVERT_TEXT) {
            for (int i = start; i < length; ++i) {
                if (sourceBytes[i] == ClientLineEnding.FST_L_LF_BYTES[0]) {
                    stream.write(ClientLineEnding.FST_L_LOCAL_BYTES);
                    continue;
                }
                stream.write(sourceBytes[i]);
            }
        } else {
            stream.write(sourceBytes, start, length);
        }
    }

    private void translate(byte[] sourceBytes, CharsetConverter converter, int length, OutputStream stream) throws IOException, FileDecoderException, FileEncoderException {
        ByteBuffer converted;
        int start = 0;
        if (ClientLineEnding.CONVERT_TEXT) {
            ByteArrayOutputStream converted2 = new ByteArrayOutputStream();
            this.writeToStream(sourceBytes, start, length, converted2);
            sourceBytes = converted2.toByteArray();
            start = 0;
            length = sourceBytes.length;
        }
        ByteBuffer from = ByteBuffer.wrap(sourceBytes);
        if (length > 0 && (converted = converter.convert(from)) != null) {
            sourceBytes = converted.array();
            start = converted.position();
            length = converted.limit();
        }
        if (length > 0) {
            stream.write(sourceBytes, start, length);
        }
    }

    private void translate(byte[] sourceBytes, CharsetConverter converter, int length, RpcByteBufferOutput stream) throws IOException, FileDecoderException, FileEncoderException {
        ByteBuffer converted;
        int start = 0;
        if (ClientLineEnding.CONVERT_TEXT) {
            ByteArrayOutputStream converted2 = new ByteArrayOutputStream();
            this.writeToStream(sourceBytes, start, length, converted2);
            sourceBytes = converted2.toByteArray();
            start = 0;
            length = sourceBytes.length;
        }
        ByteBuffer from = ByteBuffer.wrap(sourceBytes);
        if (length > 0 && (converted = converter.convert(from)) != null) {
            sourceBytes = converted.array();
            start = converted.position();
            length = converted.limit();
        }
        if (length > 0) {
            stream.write(sourceBytes, start, length);
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeText(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in writeText().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in writeText().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in writeText().");
        }
        String trans = (String)resultsMap.get("trans");
        if (trans != null && !trans.equalsIgnoreCase("no")) {
            throw new P4JavaError("trans arg not 'no' or null in writeText: " + trans);
        }
        String handlerName = "writeText";
        CommandEnv.RpcHandler handler = cmdEnv.getHandler("writeText");
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            Objects.requireNonNull(commandEnv);
            handler = commandEnv.new CommandEnv.RpcHandler("writeText", false, null);
            cmdEnv.addHandler(handler);
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        try {
            Object outStream;
            byte[] sourceBytes = (byte[])resultsMap.get("data");
            int len = sourceBytes.length;
            int start = 0;
            CharsetConverter converter = null;
            if (trans == null && (converter = (CharsetConverter)stateMap.get("RPC_TMP_CONVERTER_KEY")) == null) {
                Charset charset = rpcConnection.getClientCharset();
                for (Map<String, Object> map : cmdEnv.getResultMaps()) {
                    String type;
                    if (!map.containsKey("type") || !"utf16".equals(type = map.get("type").toString())) continue;
                    charset = CharsetDefs.UTF16;
                    break;
                }
                if (charset != CharsetDefs.UTF8) {
                    converter = new CharsetConverter(CharsetDefs.UTF8, charset);
                    stateMap.put("RPC_TMP_CONVERTER_KEY", converter);
                }
            }
            if (cmdEnv.isBufferOutput()) {
                outStream = this.getBufferOutputStream(cmdEnv);
                if (outStream == null) {
                    throw new NullPointerError("Null byte buffer output stream in writeText state map");
                }
                if (trans == null) {
                    if (converter != null) {
                        this.translate(sourceBytes, converter, len, (RpcByteBufferOutput)outStream);
                    } else {
                        this.writeToStream(sourceBytes, start, len, (RpcByteBufferOutput)outStream);
                    }
                } else if (len > 0) {
                    this.writeToStream(sourceBytes, start, len, (RpcByteBufferOutput)outStream);
                }
            } else {
                outStream = this.getTempOutputStream(cmdEnv);
                if (outStream == null) {
                    throw new NullPointerError("Null output stream in writeText state map");
                }
                if (((FileOutputStream)outStream).getFD() != null && ((FileOutputStream)outStream).getFD().valid()) {
                    if (trans == null) {
                        if (converter != null) {
                            this.translate(sourceBytes, converter, len, (OutputStream)outStream);
                        } else {
                            this.writeToStream(sourceBytes, start, len, (OutputStream)outStream);
                        }
                    } else if (len > 0) {
                        this.writeToStream(sourceBytes, start, len, (OutputStream)outStream);
                    }
                } else {
                    Log.error("output stream unexpectedly closed in writeText", new Object[0]);
                    handler.setError(true);
                }
            }
        }
        catch (FileDecoderException | FileEncoderException | IOException ioexc) {
            handler.setError(true);
            cmdEnv.getResultMaps().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", ioexc.getLocalizedMessage()}).toMap());
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeBinary(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in writeBinary().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in writeBinary().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in writeBinary().");
        }
        String handlerName = "writeBinary";
        CommandEnv.RpcHandler handler = cmdEnv.getHandler("writeBinary");
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            Objects.requireNonNull(commandEnv);
            handler = commandEnv.new CommandEnv.RpcHandler("writeBinary", false, null);
            cmdEnv.addHandler(handler);
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        try {
            if (cmdEnv.isBufferOutput()) {
                RpcByteBufferOutput outBuffer = this.getBufferOutputStream(cmdEnv);
                if (outBuffer == null) {
                    throw new NullPointerError("Null byte buffer output stream in writeText state map");
                }
                outBuffer.write(resultsMap);
            } else {
                RpcOutputStream outStream = this.getTempOutputStream(cmdEnv);
                if (outStream == null) {
                    throw new NullPointerError("Null output stream in writeText state map");
                }
                if (outStream.getFD() != null && outStream.getFD().valid()) {
                    outStream.write(resultsMap);
                } else {
                    Log.error("output stream unexpectedly closed in writeBinary", new Object[0]);
                    handler.setError(true);
                }
            }
        }
        catch (FileDecoderException | FileEncoderException | IOException ioexc) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", ioexc.getLocalizedMessage()}).toMap());
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult closeFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in closeFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in closeFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in closeFile().");
        }
        if (cmdEnv.isNullSync()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        function = (String)resultsMap.get("func");
        commit = (String)resultsMap.get("commit");
        clientHandle = (String)resultsMap.get("handle");
        handler = cmdEnv.getHandler(clientHandle);
        serverDigest = null;
        localDigest = null;
        this.filePath = null;
        this.fileSize = 0L;
        this.currentSize = 0L;
        if (handler == null) {
            throw new NullPointerError("Null client handler in closeFile().");
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        cfile = new ClientFile(handler);
        this.validatePath(rpcConnection, cmdEnv, cfile);
        if (cfile.hasFile()) {
            cfile.Close();
        }
        if (cfile.hasFile()) {
            modTime = cfile.getModTime();
            if (modTime != 0L) {
                cmdEnv.setSyncTime(modTime);
            } else {
                cmdEnv.setSyncTime(cfile.statModTime());
            }
        }
        if (!cfile.isError() && cfile.getServerDigest() != null && commit != null && !cfile.getDigest().equals(cfile.getServerDigest())) {
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.DIGEST_MISMATCH, 3, 34, new String[]{cfile.getFile().getName(), cfile.getDigest(), cfile.getServerDigest()}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (cfile.getFile() == null) {
            throw new NullPointerError("Null target file ClientSystemFileCommands.closeFile() state map");
        }
        if (cfile.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (cfile.isDiff()) {
            f = RpcFunctionSpec.decode(function);
            if (f.equals((Object)RpcFunctionSpec.CLIENT_CLOSEMATCH)) {
                this.fileMatchCommands.closeMatch(rpcConnection, cmdEnv, resultsMap, cfile);
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (commit == null) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        origArgs = cfile.getArgs();
        if (origArgs == null) {
            throw new NullPointerError("Null original argument map ClientSystemFileCommands.closeFile() state map");
        }
        perms = (String)origArgs.get("perms");
        try {
            if (cfile.getTmpStream() != null) {
                if (cfile.getTmpFile() == null) {
                    throw new NullPointerError("Null tmp file ClientSystemFileCommands.writeFile() state map");
                }
                try {
                    cfile.getTmpStream().flush();
                    cfile.getTmpStream().close();
                }
                catch (IOException e) {
                    Log.error("Flushing or closing stream failed in closeFile(); tmp file: " + cfile.getFile().getName(), new Object[0]);
                }
                try {
                    if (cfile.getTmpFile().renameTo(cfile.getFile())) ** GOTO lbl113
                    Log.warn("Rename file failed in closeFile(); so, now will try to copy the file...", new Object[0]);
                    FilesHelper.copy(cfile.getTmpFile(), cfile.getFile());
                    Log.warn("Copy file succeeded in closeFile().", new Object[0]);
                }
                catch (IOException e) {
                    Log.error("Rename/copy failed completely in closeFile(); tmp file: " + cfile.getFile().getName() + "; target file: " + cfile.getFile().getName(), new Object[0]);
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{cfile.getFile().getName(), e.getLocalizedMessage()}).toMap());
                    var14_26 = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                    try {
                        if (cfile.getTmpStream() != null) {
                            cfile.getTmpStream().close();
                        }
                    }
                    catch (IOException ioexc) {
                        Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                    }
                    try {
                        if (cfile.getStream() != null) {
                            cfile.getStream().close();
                        }
                    }
                    catch (IOException ioexc) {
                        Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                    }
                    if (cfile.getTmpFile() != null && cfile.getTmpFile().exists() && !cfile.getTmpFile().delete()) {
                        Log.warn("Unable to delete tmp file '" + cfile.getTmpFile().getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause", new Object[0]);
                    }
                    return var14_26;
                }
            } else if (cfile.getStream() != null) {
                try {
                    cfile.getStream().flush();
                }
                catch (IOException e) {
                    Log.error("Flushing stream failed in closeFile(); tmp file: " + cfile.getFile().getName(), new Object[0]);
                    handler.setError(true);
                    cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{cfile.getFile().getName(), e.getLocalizedMessage()}).toMap());
                    var14_27 = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                    try {
                        if (cfile.getTmpStream() != null) {
                            cfile.getTmpStream().close();
                        }
                    }
                    catch (IOException ioexc) {
                        Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                    }
                    try {
                        if (cfile.getStream() != null) {
                            cfile.getStream().close();
                        }
                    }
                    catch (IOException ioexc) {
                        Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                    }
                    if (cfile.getTmpFile() != null && cfile.getTmpFile().exists() && !cfile.getTmpFile().delete()) {
                        Log.warn("Unable to delete tmp file '" + cfile.getTmpFile().getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause", new Object[0]);
                    }
                    return var14_27;
                }
            }
lbl113:
            // 5 sources

            if (cfile.getTmpStream() != null) {
                serverDigest = cfile.getTmpStream().getServerDigest();
                if (cfile.getDigest() != null) {
                    try {
                        cfile.getTmpStream().flush();
                    }
                    catch (IOException e) {
                        Log.error("Flushing stream failed in closeFile(); tmp file: " + cfile.getFile().getName(), new Object[0]);
                        handler.setError(true);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{cfile.getFile().getName(), e.getLocalizedMessage()}).toMap());
                        var14_28 = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                        try {
                            if (cfile.getTmpStream() != null) {
                                cfile.getTmpStream().close();
                            }
                        }
                        catch (IOException ioexc) {
                            Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                        try {
                            if (cfile.getStream() != null) {
                                cfile.getStream().close();
                            }
                        }
                        catch (IOException ioexc) {
                            Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                        if (cfile.getTmpFile() != null && cfile.getTmpFile().exists() && !cfile.getTmpFile().delete()) {
                            Log.warn("Unable to delete tmp file '" + cfile.getTmpFile().getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause", new Object[0]);
                        }
                        return var14_28;
                    }
                    localDigest = cfile.getDigest();
                }
            } else if (cfile.getStream() != null) {
                serverDigest = cfile.getStream().getServerDigest();
                if (cfile.getDigest() != null) {
                    try {
                        cfile.getStream().flush();
                    }
                    catch (IOException e) {
                        Log.error("Flushing stream failed in closeFile(); target file: " + cfile.getFile().getName(), new Object[0]);
                        handler.setError(true);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{cfile.getFile().getName(), e.getLocalizedMessage()}).toMap());
                        var14_29 = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                        try {
                            if (cfile.getTmpStream() != null) {
                                cfile.getTmpStream().close();
                            }
                        }
                        catch (IOException ioexc) {
                            Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                        try {
                            if (cfile.getStream() != null) {
                                cfile.getStream().close();
                            }
                        }
                        catch (IOException ioexc) {
                            Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                        if (cfile.getTmpFile() != null && cfile.getTmpFile().exists() && !cfile.getTmpFile().delete()) {
                            Log.warn("Unable to delete tmp file '" + cfile.getTmpFile().getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause", new Object[0]);
                        }
                        return var14_29;
                    }
                    localDigest = cfile.getDigest();
                    try {
                        cfile.getStream().close();
                    }
                    catch (IOException e) {
                        Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + e.getLocalizedMessage(), new Object[0]);
                        handler.setError(true);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{cfile.getFile().getName(), e.getLocalizedMessage()}).toMap());
                        var14_30 = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                        try {
                            if (cfile.getTmpStream() != null) {
                                cfile.getTmpStream().close();
                            }
                        }
                        catch (IOException ioexc) {
                            Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                        try {
                            if (cfile.getStream() != null) {
                                cfile.getStream().close();
                            }
                        }
                        catch (IOException ioexc) {
                            Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
                        }
                        if (cfile.getTmpFile() != null && cfile.getTmpFile().exists() && !cfile.getTmpFile().delete()) {
                            Log.warn("Unable to delete tmp file '" + cfile.getTmpFile().getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause", new Object[0]);
                        }
                        return var14_30;
                    }
                }
            }
            if (serverDigest != null && !cmdEnv.isNonCheckedSyncs() && !serverDigest.equals(localDigest)) {
                handler.setError(true);
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.DIGEST_MISMATCH, 3, 34, new String[]{cfile.getFile().getPath(), serverDigest, localDigest}).toMap());
                e = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                return e;
            }
            if (cfile.getFile().getFileType() == RpcPerforceFileType.FST_APPLEFILE) {
                AppleFileHelper.extractFile(cfile.getFile());
            }
            if (cfile.getModTime() > 0L) {
                try {
                    cfile.getFile().setLastModified(cfile.getModTime() * 1000L);
                }
                catch (Exception exc) {
                    Log.warn("Unable to set target file modification time: " + exc, new Object[0]);
                }
            }
            if (perms != null) {
                if (perms.equalsIgnoreCase("rw")) {
                    this.fileCommands.setWritable(cfile.getFile().getPath(), true);
                } else if (cfile.isSymlink()) {
                    this.fileCommands.setWritable(cfile.getFile().getPath(), true);
                } else {
                    this.fileCommands.setWritable(cfile.getFile().getPath(), false);
                }
            }
            if (cfile.getFile().getFileType().isExecutable()) {
                this.fileCommands.setExecutable(cfile.getFile().getPath(), true, false);
            }
        }
        finally {
            try {
                if (cfile.getTmpStream() != null) {
                    cfile.getTmpStream().close();
                }
            }
            catch (IOException ioexc) {
                Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
            }
            try {
                if (cfile.getStream() != null) {
                    cfile.getStream().close();
                }
            }
            catch (IOException ioexc) {
                Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage(), new Object[0]);
            }
            if (cfile.getTmpFile() != null && cfile.getTmpFile().exists() && !cfile.getTmpFile().delete()) {
                Log.warn("Unable to delete tmp file '" + cfile.getTmpFile().getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause", new Object[0]);
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult moveFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        boolean caseSensitive;
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in moveFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in moveFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in moveFile().");
        }
        String clientPath = (String)resultsMap.get("path");
        String targetPath = (String)resultsMap.get("path2");
        String type = (String)resultsMap.get("type");
        String targetType = (String)resultsMap.get("type2");
        String clientHandle = (String)resultsMap.get("handle");
        String confirm = (String)resultsMap.get("confirm");
        String rmdir = (String)resultsMap.get("rmdir");
        RpcPerforceFileType fromFileType = RpcPerforceFileType.decodeFromServerString(type);
        RpcPerforceFileType targetFileType = RpcPerforceFileType.decodeFromServerString(targetType);
        boolean fromFstSymlink = fromFileType == RpcPerforceFileType.FST_SYMLINK;
        boolean toFstSymlink = targetFileType == RpcPerforceFileType.FST_SYMLINK;
        RpcPerforceFile fromFile = new RpcPerforceFile(clientPath, type);
        RpcPerforceFile toFile = new RpcPerforceFile(targetPath, targetType);
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            Objects.requireNonNull(commandEnv);
            handler = commandEnv.new CommandEnv.RpcHandler(clientHandle, false, toFile);
            cmdEnv.addHandler(handler);
        }
        handler.setError(false);
        if (!RpcPerforceFile.fileExists(fromFile, fromFstSymlink)) {
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_NONEXISTENT, 1, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        boolean targetIsSubdir = false;
        if (clientPath.contains(targetPath) || targetPath.contains(clientPath)) {
            String[] contents = toFile.list();
            int count = 0;
            if (contents != null) {
                count = contents.length;
            }
            if (count == 1) {
                targetIsSubdir = true;
            } else if (count > 1) {
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.DIR_NOT_EMPTY, 3, 34, new String[]{targetPath}).toMap());
            }
        }
        boolean bl = caseSensitive = !cmdEnv.getServerProtocolSpecsMap().containsKey("nocase");
        if (!(!RpcPerforceFile.fileExists(toFile, toFstSymlink) || caseSensitive && clientPath.equalsIgnoreCase(targetPath) || targetIsSubdir)) {
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{targetPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (!FilesHelper.mkdirs(toFile)) {
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{targetPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (fromFile.renameTo(toFile, true)) {
            resultsMap.remove("func");
            RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, resultsMap, null);
            rpcConnection.putRpcPacket(respPacket);
        } else {
            Log.error("Rename failed completely in moveFile (cause unknown); source file: " + clientPath + "; target file: " + targetPath, new Object[0]);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_MOVE_ERROR, 3, 34, new String[]{clientPath, "(cause unknown)"}).toMap());
        }
        if (rmdir != null) {
            File dir = fromFile.getParentFile();
            if (dir != null) {
                if (!SymbolicLinkHelper.isSymbolicLink(dir.getAbsolutePath()) && !dir.delete()) {
                    Log.stats("Unable to delete parent directory for delete for file '" + clientPath + "'; (unknown cause)", new Object[0]);
                }
            } else {
                Log.warn("Unable to open parent directory for delete for file '" + clientPath + "'; (no parent directory)", new Object[0]);
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult deleteFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in deleteFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in deleteFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in deleteFile().");
        }
        String clientPath = (String)resultsMap.get("path");
        String noClobber = (String)resultsMap.get("noclobber");
        String clientHandle = (String)resultsMap.get("handle");
        String rmDir = (String)resultsMap.get("rmdir");
        String fileTypeStr = (String)resultsMap.get("type");
        String digest = (String)resultsMap.get("digest");
        String digestType = (String)resultsMap.get("digestType");
        cmdEnv.setSyncTime(0L);
        RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(fileTypeStr);
        boolean fstSymlink = fileType == null || fileType == RpcPerforceFileType.FST_SYMLINK;
        File file = new File(clientPath);
        if (!RpcPerforceFile.fileExists(file, fstSymlink)) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (digestType != null && !rpcConnection.getDigest(fileType, file, RpcPerforceDigestType.GetType(digestType)).equals(digest)) {
            CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
            if (handler == null) {
                CommandEnv commandEnv = cmdEnv;
                Objects.requireNonNull(commandEnv);
                handler = commandEnv.new CommandEnv.RpcHandler(clientHandle, false, new RpcPerforceFile(clientPath, fileTypeStr));
                cmdEnv.addHandler(handler);
            } else {
                handler.setFile(new RpcPerforceFile(clientPath, fileTypeStr));
                handler.getMap().clear();
            }
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.NO_MODIFIED_FILE, 3, 34, new String[]{"delete", clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (file.exists() && file.isFile() && noClobber != null && file.canWrite() && clientHandle != null && !fstSymlink) {
            CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
            if (handler == null) {
                CommandEnv commandEnv = cmdEnv;
                Objects.requireNonNull(commandEnv);
                handler = commandEnv.new CommandEnv.RpcHandler(clientHandle, false, new RpcPerforceFile(clientPath, fileTypeStr));
                cmdEnv.addHandler(handler);
            } else {
                handler.setFile(new RpcPerforceFile(clientPath, fileTypeStr));
                handler.getMap().clear();
            }
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        boolean deleteFailed = false;
        if (!file.delete()) {
            deleteFailed = true;
            if (!file.canWrite() && this.fileCommands.setWritable(clientPath, true)) {
                boolean bl = deleteFailed = !file.delete();
            }
        }
        if (deleteFailed) {
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_DELETE_FILE, 3, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (rmDir != null) {
            File clientRootDir = new File(this.server.getCurrentClient().getRoot());
            File dir = file;
            do {
                if ((dir = dir.getParentFile()) != null) {
                    if (SymbolicLinkHelper.isSymbolicLink(dir.getAbsolutePath()) || dir.delete()) continue;
                    Log.stats("Unable to delete parent directory for delete for file '" + clientPath + "'; (unknown cause)", new Object[0]);
                    break;
                }
                Log.warn("Unable to open parent directory for delete for file '" + clientPath + "' (unknown cause)", new Object[0]);
                break;
            } while (!dir.getAbsoluteFile().equals(clientRootDir));
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult checkFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in checkFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in checkFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in checkFile().");
        }
        String clientPath = (String)resultsMap.get("path");
        String clientType = (String)resultsMap.get("type");
        String forceType = (String)resultsMap.get("forceType");
        String digest = (String)resultsMap.get("digest");
        String digestType = (String)resultsMap.get("digestType");
        String confirm = (String)resultsMap.get("confirm");
        String ignore = (String)resultsMap.get("ignore");
        String fileSize = (String)resultsMap.get("fileSize");
        String scanSize = (String)resultsMap.get("scanSize");
        String checkLinks = (String)resultsMap.get("checkLinks");
        String checkLinksNs = (String)resultsMap.get("checkLinksN");
        String sendFileSize = (String)resultsMap.get("sendFileSize");
        if (sendFileSize == null && fileSize != null) {
            resultsMap.remove("fileSize");
        }
        int checkLinksN = 0;
        try {
            checkLinksN = checkLinksNs != null ? Integer.valueOf(checkLinksNs) : 0;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (null == clientPath && (null != checkLinks || null != ignore || null == clientType)) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (digest != null && digestType != null) {
            return this.checkFileGraph(rpcConnection, cmdEnv, resultsMap);
        }
        if (checkLinks != null) {
            File ps = new File(clientPath);
            if (SymbolicLinkHelper.isSymbolicLink(ps.getAbsolutePath()) && checkLinksN < 3 && ps.isDirectory()) {
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            while ((ps = ps.getParentFile()) != null) {
                if (SymbolicLinkHelper.isSymbolicLink(ps.getAbsolutePath())) {
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
                if (!checkLinks.equals(ps.getAbsolutePath())) continue;
            }
        }
        if (ignore != null) {
            RpcFunctionSpec funcSpec;
            if (this.fileMatchCommands.isIgnore(new File(clientPath), rpcConnection.getClientCharset(), cmdEnv)) {
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (ignore.length() > 0 && (funcSpec = RpcFunctionSpec.decode(ignore)) == RpcFunctionSpec.CLIENT_ACK) {
                if (null != confirm && confirm.length() > 0) {
                    HashMap<String, Object> respMap = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                        if (entry.getKey() == null || entry.getKey().equalsIgnoreCase("func")) continue;
                        respMap.put(entry.getKey(), entry.getValue());
                    }
                    RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
                    rpcConnection.putRpcPacket(respPacket);
                }
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
        }
        String status = "exists";
        String nType = clientType == null ? "text" : clientType;
        RpcPerforceFileType fileType = null;
        boolean fstSymlink = false;
        DigestResult digestResult = null;
        String digestStr = null;
        if (clientType != null) {
            RpcPerforceFile file = new RpcPerforceFile(clientPath, clientType);
            fileType = RpcPerforceFileType.decodeFromServerString(clientType);
            fstSymlink = fileType == RpcPerforceFileType.FST_SYMLINK;
            digestResult = rpcConnection.getDigestAndSizeOfFile(fileType, file);
            if (!RpcPerforceFile.fileExists(file, fstSymlink)) {
                status = "missing";
            } else if (digest != null && (digestStr = digestResult.getDigest()) != null && digestStr.equals(digest)) {
                status = "same";
            }
            if (sendFileSize == null) {
                fileSize = String.valueOf(digestResult.getFileSize());
            }
        } else {
            boolean overSize;
            RpcPerforceFileType.RpcServerTypeStringSpec spec;
            Object file;
            int scan = -1;
            if (scanSize != null) {
                try {
                    scan = Integer.parseInt(scanSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            fstSymlink = (fileType = RpcPerforceFileType.inferFileType((File)(file = new File(clientPath)), scan, cmdEnv.getRpcConnection().isUnicodeServer(), cmdEnv.getRpcConnection().getClientCharset())) == RpcPerforceFileType.FST_SYMLINK;
            fileSize = String.valueOf(((File)file).length());
            if (fileType != RpcPerforceFileType.FST_BINARY && sendFileSize != null) {
                digestResult = rpcConnection.getDigestAndSizeOfFile(fileType, (File)file);
                fileSize = String.valueOf(digestResult.getFileSize());
            }
            if (!RpcPerforceFile.fileExists((File)file, fstSymlink)) {
                status = "missing";
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_MISSING_ASSUMING_TYPE, 1, 34, new String[]{clientPath, nType}).toMap());
            }
            String string = (String)cmdEnv.getServerProtocolSpecsMap().get("xfiles");
            int serverXLevel = 0;
            if (string != null) {
                try {
                    serverXLevel = new Integer(string);
                }
                catch (NumberFormatException nfe) {
                    throw new ProtocolError("Unexpected number conversion exception in ClientSystemFileCommands.checkFile: " + nfe.getLocalizedMessage(), nfe);
                }
            }
            if ((spec = RpcPerforceFileType.getServerFileTypeString(clientPath, overSize = false, fileType, forceType, serverXLevel)).getServerTypeString() == null) {
                cmdEnv.handleResult(spec.getMsg().toMap());
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (spec.getMsg() != null) {
                cmdEnv.handleResult(spec.getMsg().toMap());
            }
            nType = spec.getServerTypeString();
        }
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("type", nType);
        respMap.put("status", status);
        if (sendFileSize != null && !"0".equalsIgnoreCase(fileSize)) {
            respMap.put("fileSize", fileSize);
        }
        for (Map.Entry entry : resultsMap.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equalsIgnoreCase("func") || ((String)entry.getKey()).equalsIgnoreCase("type") || ((String)entry.getKey()).equalsIgnoreCase("status")) continue;
            respMap.put((String)entry.getKey(), entry.getValue());
        }
        RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult checkFileGraph(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in checkFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in checkFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in checkFile().");
        }
        String clientPath = (String)resultsMap.get("path");
        String clientType = (String)resultsMap.get("type");
        String digest = (String)resultsMap.get("digest");
        String digestType = (String)resultsMap.get("digestType");
        String confirm = (String)resultsMap.get("confirm");
        String status = "exists";
        File file = new File(clientPath);
        if (!RpcPerforceFile.fileExists(file, true)) {
            status = "missing";
        } else if (rpcConnection.getDigest(RpcPerforceFileType.decodeFromServerString(clientType), file, RpcPerforceDigestType.GetType(digestType)).equals(digest)) {
            status = "same";
        }
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("type", clientType);
        respMap.put("status", status);
        for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
            if (entry.getKey() == null || entry.getKey().equalsIgnoreCase("func") || entry.getKey().equalsIgnoreCase("type") || entry.getKey().equalsIgnoreCase("status")) continue;
            respMap.put(entry.getKey(), entry.getValue());
        }
        RpcPacket respPacket = RpcPacket.constructRpcPacket(confirm, respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult convertFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null rpcConnection in convertFile().");
        }
        if (cmdEnv == null) {
            throw new NullPointerError("Null cmdEnv in convertFile().");
        }
        if (resultsMap == null) {
            throw new NullPointerError("Null resultsMap in convertFile().");
        }
        String clientPath = (String)resultsMap.get("path");
        String clientType = (String)resultsMap.get("type");
        String perms = (String)resultsMap.get("perms");
        String fromCS = (String)resultsMap.get("charset1");
        String toCS = (String)resultsMap.get("charset2");
        if (clientPath == null) {
            throw new NullPointerException("Missing path");
        }
        if (perms == null) {
            throw new NullPointerException("Missing perms");
        }
        if (fromCS == null || toCS == null) {
            throw new NullPointerException("Missing charset");
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    public RpcOutputStream getTempOutputStream(CommandEnv cmdEnv) throws ConnectionException {
        if (cmdEnv == null) {
            throw new NullPointerError("Null command env in ClientSystemFileCommands.getTempOutputStream()");
        }
        if (cmdEnv.getStateMap() == null) {
            throw new NullPointerError("Null command env state map in ClientSystemFileCommands.getTempOutputStream()");
        }
        if (cmdEnv.getProtocolSpecs() == null) {
            throw new NullPointerError("Null command env protocol specs in ClientSystemFileCommands.getTempOutputStream()");
        }
        RpcOutputStream outStream = (RpcOutputStream)cmdEnv.getStateMap().get("");
        if (outStream == null && (cmdEnv.isStreamCmd() || cmdEnv.getProtocolSpecs().isEnableTracking())) {
            try {
                String tmpFileName = RpcPerforceFile.createTempFileName(RpcPropertyDefs.getProperty(this.server.getProperties(), "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY)));
                RpcPerforceFile tmpFile = new RpcPerforceFile(tmpFileName, RpcPerforceFileType.FST_BINARY);
                outStream = RpcOutputStream.getTmpOutputStream(tmpFile);
                cmdEnv.getStateMap().put("", outStream);
            }
            catch (IOException ioexc) {
                Log.error("tmp file creation error: " + ioexc.getLocalizedMessage(), new Object[0]);
                Log.exception(ioexc);
                throw new ConnectionException("Unable to create temporary file for Perforce file retrieval; reason: " + ioexc.getLocalizedMessage(), ioexc);
            }
        }
        return outStream;
    }

    public RpcByteBufferOutput getBufferOutputStream(CommandEnv cmdEnv) throws ConnectionException {
        if (cmdEnv == null) {
            throw new NullPointerError("Null command env in ClientSystemFileCommands.getBufferOutputStream()");
        }
        if (cmdEnv.getStateMap() == null) {
            throw new NullPointerError("Null command env state map in ClientSystemFileCommands.getBufferOutputStream()");
        }
        if (cmdEnv.getProtocolSpecs() == null) {
            throw new NullPointerError("Null command env protocol specs in ClientSystemFileCommands.getBufferOutputStream()");
        }
        RpcByteBufferOutput outStream = (RpcByteBufferOutput)cmdEnv.getStateMap().get("");
        if (outStream == null && (cmdEnv.isStreamCmd() || cmdEnv.getProtocolSpecs().isEnableTracking())) {
            try {
                outStream = RpcByteBufferOutput.getBufferOutputStream(cmdEnv.getCmdSpec().getCmdArgs());
                cmdEnv.getStateMap().put("", outStream);
            }
            catch (IOException ioexc) {
                Log.error("byte buffer creation error: " + ioexc.getLocalizedMessage(), new Object[0]);
                Log.exception(ioexc);
                throw new ConnectionException("Unable to create Byte Buffer;  reason: " + ioexc.getLocalizedMessage(), ioexc);
            }
        }
        return outStream;
    }

    public Map<String, Object> convertFileDataMap(Map<String, Object> map, Charset charset, boolean isUnicodeServer) {
        if (map != null) {
            String dataString = null;
            byte[] dataBytes = null;
            try {
                dataBytes = (byte[])map.get("data");
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
            if (dataBytes != null) {
                try {
                    dataString = new String(dataBytes, charset == null ? RpcConnection.NON_UNICODE_SERVER_CHARSET_NAME : (isUnicodeServer ? CharsetDefs.UTF8_NAME : charset.name()));
                    map.put("data", dataString);
                }
                catch (UnsupportedEncodingException e) {
                    Log.exception(e);
                }
            }
        }
        return map;
    }

    private boolean validatePath(RpcConnection rpcConnection, CommandEnv cmdEnv, ClientFile cfile) {
        if (cfile == null) {
            return false;
        }
        String clientPath = this.server.getClientPath();
        if (clientPath == null) {
            return true;
        }
        String file = cfile.getFile().getAbsolutePath();
        if (cfile.isSymlink() && rpcConnection.getFilesysRestrictedSymlinks() == 1) {
            if (!SymbolicLinkHelper.isSymbolicLinkCapable()) {
                cfile.setError(true);
                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE_TYPE, 3, 34, new String[]{"symlink", cfile.getFile().getAbsolutePath()}).toMap());
                return false;
            }
            if (cfile.getSymTarget() != null) {
                file = cfile.getSymTarget();
            }
        }
        List<String> paths = Arrays.asList(clientPath.split(";"));
        for (String path : paths) {
            if (!file.startsWith(path = path.trim())) continue;
            return true;
        }
        cfile.setError(true);
        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.NOT_UNDER_CLIENT_PATH, 3, 34, new String[]{file, clientPath}).toMap());
        return false;
    }
}

