/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.admin;

import com.perforce.p4java.admin.IProtectionEntry;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.impl.generic.core.MapEntry;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ProtectionEntry
extends MapEntry
implements IProtectionEntry {
    private String mode = null;
    private boolean group = false;
    private String host = null;
    private String name = null;
    private String permMax = null;

    public ProtectionEntry() {
    }

    public ProtectionEntry(int order, String mode, boolean group, String host, String name, String path, boolean pathExcluded) {
        super(order, null);
        this.mode = mode;
        this.group = group;
        this.host = host;
        this.name = name;
        if (StringUtils.isNotBlank((CharSequence)path)) {
            String[] entries = ProtectionEntry.parseViewMappingString(ProtectionEntry.quoteWhitespaceString(path));
            this.type = IMapEntry.EntryType.fromString(entries[0]);
            this.left = ProtectionEntry.stripTypePrefix(entries[0]);
            this.right = entries[1];
        }
        this.left = ProtectionEntry.quoteWhitespaceString(this.left);
        if (pathExcluded) {
            this.type = IMapEntry.EntryType.EXCLUDE;
        }
    }

    public ProtectionEntry(Map<String, Object> map, int order) {
        super(order, null);
        if (Objects.nonNull(map)) {
            this.host = P4ResultMapUtils.parseString(map, "host");
            String pathStr = P4ResultMapUtils.parseString(map, "depotFile");
            if (StringUtils.isNotBlank((CharSequence)pathStr)) {
                String[] entries = ProtectionEntry.parseViewMappingString(ProtectionEntry.quoteWhitespaceString(pathStr));
                this.type = IMapEntry.EntryType.fromString(entries[0]);
                this.left = ProtectionEntry.stripTypePrefix(entries[0]);
                this.right = entries[1];
            }
            this.left = ProtectionEntry.quoteWhitespaceString(this.left);
            this.mode = P4ResultMapUtils.parseString(map, "perm");
            this.name = P4ResultMapUtils.parseString(map, "user");
            this.group = map.containsKey("isgroup");
            if (map.containsKey("unmap")) {
                this.type = IMapEntry.EntryType.EXCLUDE;
            }
            this.permMax = P4ResultMapUtils.parseString(map, "permMax");
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        if (this.isPathExcluded()) {
            return this.addExclude(this.left);
        }
        if (this.type == IMapEntry.EntryType.OVERLAY) {
            return this.addOverlay(this.left);
        }
        return this.left;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public void setGroup(boolean group) {
        this.group = group;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setPath(String path) {
        this.left = ProtectionEntry.quoteWhitespaceString(path);
    }

    @Override
    public boolean isPathExcluded() {
        return this.type == IMapEntry.EntryType.EXCLUDE;
    }

    @Override
    public void setPathExcluded(boolean pathExcluded) {
        if (pathExcluded) {
            this.type = IMapEntry.EntryType.EXCLUDE;
        }
    }

    @Override
    public String getPermMax() {
        return this.permMax;
    }

    private String addExclude(String str) {
        return this.buildDiffSyntaxString(str, "-");
    }

    private String addOverlay(String str) {
        return this.buildDiffSyntaxString(str, "+");
    }

    private String buildDiffSyntaxString(String str, String syntax) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            str = ((String)str).startsWith("\"") ? "\"" + syntax + ((String)str).substring(1) : syntax + (String)str;
        }
        return str;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.mode)) {
            sb.append(this.mode);
        }
        if (this.isGroup()) {
            sb.append(" ").append("group");
        } else {
            sb.append(" ").append("user");
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            sb.append(" ").append(this.name);
        }
        if (StringUtils.isNotBlank((CharSequence)this.host)) {
            sb.append(" ").append(this.host);
        }
        if (StringUtils.isNotBlank((CharSequence)this.left)) {
            sb.append(" ").append(this.getPath());
        }
        return sb.toString();
    }
}

