/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.core;

import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.mapapi.MapFlag;
import com.perforce.p4java.mapapi.MapTable;
import com.perforce.p4java.mapapi.MapTableT;
import com.perforce.p4java.mapapi.MapWrap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ViewMap<E extends IMapEntry>
implements Iterable<E> {
    protected List<E> entryList = null;

    public ViewMap() {
        this.entryList = new ArrayList();
    }

    public ViewMap(List<E> entryList) {
        this.checkEntryList(entryList);
        this.entryList = entryList;
    }

    public int getSize() {
        return this.entryList.size();
    }

    public synchronized void deleteEntry(int position) {
        if (position < 0 || position >= this.entryList.size()) {
            throw new P4JavaError("Position out of range: " + position + "; list size: " + this.entryList.size());
        }
        this.updateEntryListPositions();
    }

    public synchronized E getEntry(int position) {
        if (position < 0 || position >= this.entryList.size()) {
            throw new P4JavaError("Position out of range: " + position + "; list size: " + this.entryList.size());
        }
        IMapEntry entry = (IMapEntry)this.entryList.get(position);
        if (entry == null) {
            throw new NullPointerError("Null entry in ViewMap list");
        }
        if (entry.getOrder() != position) {
            throw new P4JavaError("Entry internal order does not match list order");
        }
        return (E)entry;
    }

    public List<E> getEntryList() {
        return this.entryList;
    }

    public synchronized void addEntry(E entry) {
        if (entry == null) {
            throw new NullPointerError("Null entry passed to ViewMap insertEntry method");
        }
        this.entryList.add(entry);
        entry.setOrder(this.getSize() - 1);
    }

    public synchronized void setEntry(int position, E entry) {
        if (position < 0 || position >= this.entryList.size()) {
            throw new P4JavaError("Position out of range: " + position + "; list size: " + this.entryList.size());
        }
        if (entry == null) {
            throw new NullPointerError("Null entry passed to ViewMap replaceEntry method");
        }
        ((IMapEntry)this.entryList.get(position)).setOrder(-1);
        this.entryList.set(position, entry);
        entry.setOrder(position);
    }

    public void setEntryList(List<E> entryList) {
        this.checkEntryList(entryList);
        this.entryList = entryList;
    }

    public synchronized void checkEntryList(List<E> entryList) {
        if (entryList == null) {
            throw new NullPointerError("Null entryList passed to checkEntryList");
        }
        int pos = 0;
        for (IMapEntry entry : entryList) {
            if (entry == null) {
                throw new NullPointerError("Null entry in list passed to checkEntryList");
            }
            if (entry.getOrder() != pos) {
                throw new P4JavaError("Inconsistent view map entry order in entry list check");
            }
            ++pos;
        }
    }

    protected void updateEntryListPositions() {
        int pos = 0;
        for (IMapEntry entry : this.entryList) {
            if (entry == null) {
                throw new NullPointerError("Null entry in entryList");
            }
            entry.setOrder(pos++);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.entryList.iterator();
    }

    public String translate(String from, MapDirection dir) {
        MapTable mt = new MapTable();
        for (IMapEntry i : this) {
            mt.insert(i.getLeft(), i.getRight(), i.getType() == IMapEntry.EntryType.EXCLUDE ? MapFlag.MfUnmap : (i.getType() == IMapEntry.EntryType.OVERLAY ? MapFlag.MfRemap : (i.getType() == IMapEntry.EntryType.DITTO ? MapFlag.MfAndmap : MapFlag.MfMap)));
        }
        MapWrap mw = mt.translate(dir == MapDirection.MapLeftRight ? MapTableT.LHS : MapTableT.RHS, from);
        return mw != null ? mw.getTo() : null;
    }

    public static enum MapDirection {
        MapLeftRight,
        MapRightLeft;

    }
}

