/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ClientError;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.exception.FileEncoderException;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.Utf8ByteHelper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class CharsetConverter {
    final String bomChar = "\ufeff";
    private CharsetDecoder decoder;
    private CharsetEncoder encoder;
    private boolean checkBOM = false;
    private boolean ignoreBOM = false;
    private ByteBuffer remainder = null;

    public CharsetConverter(Charset fromCharset, Charset toCharset, boolean ignoreBOM) {
        this.decoder = fromCharset.newDecoder();
        this.decoder.onMalformedInput(CodingErrorAction.REPORT);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.encoder = toCharset.newEncoder();
        this.encoder.onMalformedInput(CodingErrorAction.REPORT);
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        if ("UTF-16".equals(toCharset.name())) {
            this.checkBOM = true;
        }
        this.ignoreBOM = ignoreBOM;
    }

    public String getToCharsetName() {
        return this.encoder.charset().name();
    }

    public CharsetConverter(Charset fromCharset, Charset toCharset) {
        this(fromCharset, toCharset, false);
    }

    public ByteBuffer convert(CharBuffer from) throws FileEncoderException {
        ByteBuffer converted;
        block11: {
            converted = null;
            try {
                converted = this.encoder.encode(from);
                if (this.checkBOM) {
                    if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                        try {
                            byte[] bytes = ("\ufeff" + from.rewind().toString()).getBytes("UTF-16LE");
                            converted = ByteBuffer.wrap(bytes);
                            converted.order(ByteOrder.LITTLE_ENDIAN);
                        }
                        catch (UnsupportedEncodingException uee) {
                            Log.exception(uee);
                            throw new ClientError("Translation of file content failed", uee);
                        }
                    }
                    if (this.ignoreBOM) {
                        int limit = converted.limit();
                        if (limit > 2) {
                            byte[] bom = new byte[2];
                            converted.get(bom);
                            if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
                                converted.position(2);
                                converted.limit(limit - 2);
                            } else {
                                converted.rewind();
                            }
                        }
                    } else {
                        this.ignoreBOM = true;
                    }
                    break block11;
                }
                converted.position(0);
            }
            catch (CharacterCodingException cce) {
                Log.exception(cce);
                throw new FileEncoderException("Translation of file content failed", cce);
            }
        }
        return converted;
    }

    public ByteBuffer convert(ByteBuffer from) throws FileDecoderException, FileEncoderException {
        int size;
        CharBuffer sourceChars;
        CoderResult res;
        if (CharsetDefs.UTF8.equals(this.decoder.charset())) {
            from = this.getUtf8BufferWindow(from);
        }
        if ((res = this.decoder.decode(from, sourceChars = CharBuffer.allocate(size = from.limit() * 2), true)).isError()) {
            throw new FileDecoderException();
        }
        sourceChars.flip();
        ByteBuffer converted = this.convert(sourceChars);
        return converted;
    }

    private ByteBuffer getUtf8BufferWindow(ByteBuffer buffer) throws FileDecoderException {
        int r = (buffer = this.addRemainder(buffer)).remaining();
        if (r < 1) {
            buffer.rewind();
            return buffer;
        }
        byte lastByte = buffer.get(r - 1);
        Utf8ByteHelper type = Utf8ByteHelper.parse(lastByte);
        if (Utf8ByteHelper.SINGLE.equals((Object)type)) {
            buffer.rewind();
            return buffer;
        }
        int end = Utf8ByteHelper.findBufferLimit(buffer);
        buffer.position(end);
        r = buffer.remaining();
        if (r > 0) {
            this.remainder = ByteBuffer.allocate(r);
            this.remainder.put(buffer);
        }
        buffer.rewind();
        buffer.limit(end);
        return buffer;
    }

    private ByteBuffer addRemainder(ByteBuffer buffer) {
        if (this.remainder != null) {
            this.remainder.clear();
            int last = this.remainder.remaining();
            ByteBuffer combined = ByteBuffer.allocate(last + buffer.remaining());
            combined.put(this.remainder);
            combined.put(buffer);
            this.remainder = null;
            combined.rewind();
            return combined;
        }
        return buffer;
    }
}

