/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.BranchSpec;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.DeleteBranchSpecOptions;
import com.perforce.p4java.option.server.GetBranchSpecOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IBranchDelegator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;

public class BranchDelegator
extends BaseDelegator
implements IBranchDelegator {
    public BranchDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String createBranchSpec(@Nonnull IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        Validate.notNull((Object)branchSpec);
        try {
            List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCH, new String[]{"-i"}, InputMapper.map(branchSpec));
            return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public IBranchSpec getBranchSpec(String name) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getBranchSpec(name, new GetBranchSpecOptions());
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public IBranchSpec getBranchSpec(String name, GetBranchSpecOptions opts) throws P4JavaException {
        Validate.notBlank((CharSequence)name, (String)"Branch spec name shouldn't blank", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCH, Parameters.processParameters((Options)opts, null, new String[]{"-o", name}, (IServer)this.server), null);
        return ResultListBuilder.buildNullableObjectFromNonInfoMessageCommandResultMaps(resultMaps, map -> new BranchSpec((Map<String, Object>)map, this.server));
    }

    @Override
    public String updateBranchSpec(@Nonnull IBranchSpec branchSpec) throws ConnectionException, RequestException, AccessException {
        Validate.notNull((Object)branchSpec);
        try {
            List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCH, new String[]{"-i"}, InputMapper.map(branchSpec));
            return ResultMapParser.parseCommandResultMapAsString(resultMaps);
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    @Deprecated
    public String deleteBranchSpec(String branchSpecName, boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deleteBranchSpec(branchSpecName, new DeleteBranchSpecOptions(force));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deleteBranchSpec(String branchSpecName, DeleteBranchSpecOptions opts) throws P4JavaException {
        Validate.notBlank((CharSequence)branchSpecName, (String)"Branch spec name shouldn't blank", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.BRANCH, Parameters.processParameters((Options)opts, null, new String[]{"-d", branchSpecName}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }
}

