/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.TagFilesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.ITagDelegator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TagDelegator
extends BaseDelegator
implements ITagDelegator {
    public TagDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, boolean listOnly, boolean delete) throws ConnectionException, RequestException, AccessException {
        try {
            TagFilesOptions tagFilesOptions = new TagFilesOptions().setDelete(delete).setListOnly(listOnly);
            return this.tagFiles(fileSpecs, labelName, tagFilesOptions);
        }
        catch (AccessException | ConnectionException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IServer.getDepotFiles: %s", exc);
            return Collections.emptyList();
        }
    }

    @Override
    public List<IFileSpec> tagFiles(List<IFileSpec> fileSpecs, String labelName, TagFilesOptions opts) throws P4JavaException {
        Object labelOpt = "";
        if (StringUtils.isNotBlank((CharSequence)labelName)) {
            labelOpt = "-l" + labelName;
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.TAG, Parameters.processParameters((Options)opts, fileSpecs, (String)labelOpt, (IServer)this.server), null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(map -> ResultListBuilder.handleFileReturn(map, this.server)));
    }
}

