/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.graph.CommitAction;
import com.perforce.p4java.graph.ICommit;
import com.perforce.p4java.graph.IGraphObject;
import com.perforce.p4java.impl.generic.graph.Commit;
import com.perforce.p4java.impl.generic.graph.GraphObject;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GraphCommitLogOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.ICommitDelegator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class CommitDelegator
extends BaseDelegator
implements ICommitDelegator {
    public CommitDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public ICommit getCommitObject(String sha) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GRAPH, Parameters.processParameters(null, null, new String[]{"cat-file", "commit", sha}, (IServer)this.server), null);
        List<ICommit> commits = this.parseCommitList(resultMaps);
        if (commits != null && !commits.isEmpty()) {
            return commits.get(0);
        }
        return null;
    }

    @Override
    public ICommit getCommitObject(String sha, String repo) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GRAPH, Parameters.processParameters(null, null, new String[]{"cat-file", "-n", repo, "commit", sha}, (IServer)this.server), null);
        List<ICommit> commits = this.parseCommitList(resultMaps);
        if (commits != null && !commits.isEmpty()) {
            return commits.get(0);
        }
        return null;
    }

    @Override
    public InputStream getBlobObject(String repo, String sha) throws P4JavaException {
        InputStream inputStream = this.execStreamCmd(CmdSpec.GRAPH, Parameters.processParameters(null, null, new String[]{"cat-file", "-n", repo, "blob", sha}, (IServer)this.server));
        return inputStream;
    }

    @Override
    public IGraphObject getGraphObject(String sha) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GRAPH, Parameters.processParameters(null, null, new String[]{"cat-file", "-t", sha}, (IServer)this.server), null);
        if (!Objects.nonNull(resultMaps)) {
            return null;
        }
        String rsha = null;
        String type = null;
        for (Map<String, Object> map : resultMaps) {
            if (!Objects.nonNull(map)) continue;
            ResultMapParser.handleErrorStr(map);
            String errStr = ResultMapParser.getErrorStr(map);
            P4JavaExceptions.throwRequestExceptionIfConditionFails(StringUtils.isBlank((CharSequence)errStr), P4ResultMapUtils.parseCode0ErrorString(map), errStr, new Object[0]);
            try {
                if (map.containsKey("sha")) {
                    rsha = P4ResultMapUtils.parseString(map, "sha");
                }
                if (!map.containsKey("type")) continue;
                type = P4ResultMapUtils.parseString(map, "type");
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
        }
        return new GraphObject(rsha, type);
    }

    @Override
    public List<ICommit> getGraphCommitLogList(GraphCommitLogOptions options) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.GRAPH, Parameters.processParameters(options, this.server), null);
        if (!Objects.nonNull(resultMaps)) {
            return null;
        }
        return this.parseCommitList(resultMaps);
    }

    private List<ICommit> parseCommitList(List<Map<String, Object>> resultMaps) throws P4JavaException {
        ArrayList<ICommit> list = new ArrayList<ICommit>();
        if (!Objects.nonNull(resultMaps)) {
            return null;
        }
        for (Map<String, Object> map : resultMaps) {
            String commit = null;
            String tree = null;
            CommitAction action = CommitAction.UNKNOWN;
            List<String> parent = new ArrayList<String>();
            String author = null;
            String authorEmail = null;
            Date date = null;
            String committer = null;
            String committerEmail = null;
            Date committerDate = null;
            String description = null;
            if (!Objects.nonNull(map) || map.isEmpty()) {
                return null;
            }
            ResultMapParser.handleErrorStr(map);
            try {
                if (map.containsKey("commit")) {
                    commit = P4ResultMapUtils.parseString(map, "commit");
                }
                if (map.containsKey("tree")) {
                    tree = P4ResultMapUtils.parseString(map, "tree");
                }
                if (map.containsKey("action")) {
                    action = CommitAction.parse(P4ResultMapUtils.parseString(map, "action"));
                }
                parent = P4ResultMapUtils.parseDataList(map, "parent");
                if (map.containsKey("author")) {
                    author = P4ResultMapUtils.parseString(map, "author");
                }
                if (map.containsKey("authorEmail")) {
                    authorEmail = P4ResultMapUtils.parseString(map, "authorEmail");
                }
                if (map.containsKey("date")) {
                    date = new Date(P4ResultMapUtils.parseLong(map, "date") * 1000L);
                }
                if (map.containsKey("committer")) {
                    committer = P4ResultMapUtils.parseString(map, "committer");
                }
                if (map.containsKey("committerEmail")) {
                    committerEmail = P4ResultMapUtils.parseString(map, "committerEmail");
                }
                if (map.containsKey("committerDate")) {
                    committerDate = new Date(P4ResultMapUtils.parseLong(map, "committerDate") * 1000L);
                }
                if (map.containsKey("desc")) {
                    description = P4ResultMapUtils.parseString(map, "desc");
                }
            }
            catch (Throwable thr) {
                Log.exception(thr);
            }
            Commit entry = new Commit(commit, tree, action, parent, author, authorEmail, date, committer, committerEmail, committerDate, description);
            list.add(entry);
        }
        return list;
    }
}

