/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.ChangelistOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IChangeDelegator;
import java.util.List;
import java.util.Map;

public class ChangeDelegator
extends BaseDelegator
implements IChangeDelegator {
    public ChangeDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public IChangelist getChangelist(int id) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getChangelist(id, null);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deletePendingChangelist(int id) throws ConnectionException, RequestException, AccessException {
        try {
            return this.deletePendingChangelist(id, null);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public String deletePendingChangelist(int id, ChangelistOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CHANGE, Parameters.processParameters((Options)opts, null, new String[]{"-d", "" + id}, (IServer)this.server), null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(resultMaps);
    }

    @Override
    public IChangelist getChangelist(int id, ChangelistOptions opts) throws P4JavaException {
        String[] args = new String[]{"-o", String.valueOf(id)};
        if (id == 0) {
            args = new String[]{"-o"};
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CHANGE, Parameters.processParameters((Options)opts, null, args, (IServer)this.server), null);
        return ResultListBuilder.buildNullableObjectFromNonInfoMessageCommandResultMaps(resultMaps, map -> new Changelist((Map<String, Object>)map, this.server));
    }
}

