/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.core.ILicenseLimits;
import com.perforce.p4java.impl.generic.core.License;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenseLimits
extends ServerResource
implements ILicenseLimits {
    private boolean licensed;
    private long userCount;
    private long userLimit;
    private long clientCount;
    private long clientLimit;
    private long fileCount;
    private long fileLimit;
    private long repoCount;
    private long repoLimit;
    private long licenseExpires;
    private long licenseTimeRemaining;
    private String licenseInvalid;
    private List<Map<String, Map<String, String>>> capability;

    public LicenseLimits() {
    }

    public LicenseLimits(Map<String, Object> map) {
        this.licensed = map.get("isLicensed").equals("yes");
        this.userCount = License.readValues(map, "userCount");
        this.userLimit = License.readValues(map, "userLimit");
        this.clientCount = License.readValues(map, "clientCount");
        this.clientLimit = License.readValues(map, "clientLimit");
        this.fileCount = License.readValues(map, "fileCount");
        this.fileLimit = License.readValues(map, "fileLimit");
        this.repoCount = License.readValues(map, "repoCount");
        this.repoLimit = License.readValues(map, "repoLimit");
        this.licenseExpires = License.readValues(map, "licenseExpires");
        this.licenseTimeRemaining = License.readValues(map, "licenseTimeRemaining");
        this.licenseInvalid = (String)map.get("licenseInvalid");
        int i = 0;
        this.capability = new ArrayList<Map<String, Map<String, String>>>();
        while (map.containsKey("capability" + i)) {
            int j = 0;
            HashMap<String, String> attrs = new HashMap<String, String>();
            while (map.containsKey("capabilityAttrKey" + i + "," + j)) {
                String attrsKey = (String)map.get("capabilityAttrKey" + i + "," + j);
                String attrsValue = (String)map.get("capabilityAttrValue" + i + "," + j);
                attrs.put(attrsKey, attrsValue);
                ++j;
            }
            String key = (String)map.get("capability" + i);
            HashMap<String, HashMap<String, String>> capability = new HashMap<String, HashMap<String, String>>();
            capability.put(key, attrs);
            this.capability.add(capability);
            ++i;
        }
    }

    @Override
    public boolean isLicensed() {
        return this.licensed;
    }

    @Override
    public long getUserCount() {
        return this.userCount;
    }

    @Override
    public long getUserLimit() {
        return this.userLimit;
    }

    @Override
    public long getClientCount() {
        return this.clientCount;
    }

    @Override
    public long getClientLimit() {
        return this.clientLimit;
    }

    @Override
    public long getFileCount() {
        return this.fileCount;
    }

    @Override
    public long getFileLimit() {
        return this.fileLimit;
    }

    @Override
    public long getRepoCount() {
        return this.repoCount;
    }

    @Override
    public long getRepoLimit() {
        return this.repoLimit;
    }

    @Override
    public long getLicenseExpires() {
        return this.licenseExpires;
    }

    @Override
    public long getLicenseTimeRemaining() {
        return this.licenseTimeRemaining;
    }

    @Override
    public String getLicenseInvalid() {
        return this.licenseInvalid;
    }

    @Override
    public List<Map<String, Map<String, String>>> getCapability() {
        return this.capability;
    }
}

