/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.impl.generic.core.ServerResource;
import com.perforce.p4java.impl.generic.core.file.IExtensionSummary;
import java.util.Map;

public class ExtensionSummary
extends ServerResource
implements IExtensionSummary {
    protected String extName;
    protected String extVersion;
    protected String nameSpace;
    protected String extRev;
    protected String extEnabled;
    protected String extUUID;
    private String extDeveloper;
    private String extDescriptionSnippet;
    private String extArchDir;
    private String extDataDir;
    private boolean extGlobalConf = false;
    private boolean extInstanceConf = false;

    public ExtensionSummary() {
    }

    public ExtensionSummary(Map<String, Object> map) {
        this(map, true);
    }

    protected ExtensionSummary(Map<String, Object> map, boolean summary) {
        if (map != null) {
            try {
                String revKey = summary ? "rev" : "ExtRev";
                this.extRev = (String)map.get(revKey);
                String enabledKey = summary ? "enabled" : "ExtEnabled";
                this.extEnabled = (String)map.get(enabledKey);
                String UUIDKey = summary ? "UUID" : "ExtUUID";
                this.extUUID = (String)map.get(UUIDKey);
                String versionKey = summary ? "version" : "ExtVersion";
                this.extVersion = (String)map.get(versionKey);
                if (summary) {
                    String name = (String)map.get("extension");
                    String[] names = name.split("::");
                    this.nameSpace = names[0];
                    this.extName = names[1];
                } else {
                    this.extName = (String)map.get("ExtName");
                    this.nameSpace = (String)map.get("Name");
                }
                this.extDeveloper = (String)map.get("developer");
                this.extDescriptionSnippet = (String)map.get("description-snippet");
                this.extArchDir = (String)map.get("arch-dir");
                this.extDataDir = (String)map.get("data-dir");
                if (map.get("hasGlobalConfig") == "true") {
                    this.extGlobalConf = true;
                }
                if (map.get("hasInstanceConfig") == "true") {
                    this.extInstanceConf = true;
                }
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in Extension constructor: " + thr.getLocalizedMessage(), new Object[0]);
                Log.exception(thr);
            }
        }
    }

    @Override
    public String getExtName() {
        return this.extName;
    }

    @Override
    public String getExtVersion() {
        return this.extVersion;
    }

    @Override
    public String getExtUUID() {
        return this.extUUID;
    }

    @Override
    public String getExtRev() {
        return this.extRev;
    }

    @Override
    public String getExtEnabled() {
        return this.extEnabled;
    }

    @Override
    public String getNameSpace() {
        return this.nameSpace;
    }

    @Override
    public String getExtDeveloper() {
        return this.extDeveloper;
    }

    @Override
    public String getExtDescriptionSnippet() {
        return this.extDescriptionSnippet;
    }

    @Override
    public String getExtArchDir() {
        return this.extArchDir;
    }

    @Override
    public String getExtDataDir() {
        return this.extDataDir;
    }

    @Override
    public boolean getExtGlobalConf() {
        return this.extGlobalConf;
    }

    @Override
    public boolean getExtInstanceConf() {
        return this.extInstanceConf;
    }

    @Override
    public void setExtName(String extName) {
        this.extName = extName;
    }

    @Override
    public void setExtVersion(String extVersion) {
        this.extVersion = extVersion;
    }

    @Override
    public void setExtUUID(String extUUID) {
        this.extUUID = extUUID;
    }

    @Override
    public void setExtRev(String extRev) {
        this.extRev = extRev;
    }

    @Override
    public void setExtEnabled(String extEnabled) {
        this.extEnabled = extEnabled;
    }

    @Override
    public void setNameSpace(String name) {
        this.nameSpace = name;
    }

    @Override
    public void setExtDeveloper(String extDeveloper) {
        this.extDeveloper = extDeveloper;
    }

    @Override
    public void setExtDescriptionSnippet(String extDescriptionSnippet) {
        this.extDescriptionSnippet = extDescriptionSnippet;
    }

    @Override
    public void setExtArchDir(String extArchDir) {
        this.extArchDir = extArchDir;
    }

    @Override
    public void setExtDataDir(String extDataDir) {
        this.extDataDir = extDataDir;
    }

    @Override
    public void setExtGlobalConf(boolean extGlobalConf) {
        this.extGlobalConf = extGlobalConf;
    }

    @Override
    public void setExtInstanceConf(boolean extInstanceConf) {
        this.extInstanceConf = extInstanceConf;
    }
}

