/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class Parameters {
    public static String[] processParameters(Options opts, IServer server) throws P4JavaException {
        return Parameters.processParameters(opts, null, null, true, server);
    }

    public static String[] processParameters(Options opts, List<IFileSpec> fileSpecs, IServer server) throws P4JavaException {
        return Parameters.processParameters(opts, fileSpecs, null, true, server);
    }

    public static String[] processParameters(Options opts, List<IFileSpec> fileSpecs, String[] stringParams, IServer server) throws P4JavaException {
        return Parameters.processParameters(opts, fileSpecs, stringParams, true, server);
    }

    public static String[] processParameters(Options opts, List<IFileSpec> fileSpecs, String stringParam, IServer server) throws P4JavaException {
        return Parameters.processParameters(opts, fileSpecs, new String[]{stringParam}, true, server);
    }

    public static String[] processParameters(Options opts, List<IFileSpec> fileSpecs, @Nullable String[] stringParams, boolean annotateFiles, IServer server) throws P4JavaException {
        ArrayList<String> args = new ArrayList<String>();
        Parameters.addOpts(args, opts, server);
        if (Objects.nonNull(stringParams)) {
            for (String param : stringParams) {
                if (!StringUtils.isNotBlank((CharSequence)param)) continue;
                args.add(param);
            }
        }
        if (annotateFiles) {
            return Parameters.addFileSpecs(args, fileSpecs);
        }
        return Parameters.addUnannotatedFileSpecs(args, fileSpecs);
    }

    private static void addOpts(@Nonnull List<String> args, @Nullable Options opts, IServer server) throws P4JavaException {
        if (Objects.nonNull(opts)) {
            if (opts.isImmutable() && Objects.nonNull(opts.getOptions())) {
                args.addAll(opts.getOptions());
            } else {
                args.addAll(opts.processOptions(server));
            }
        }
    }

    private static String[] addFileSpecs(@Nonnull List<String> args, @Nullable List<IFileSpec> fileSpecs) {
        Validate.notNull(args);
        if (Objects.nonNull(fileSpecs)) {
            for (IFileSpec fSpec : fileSpecs) {
                Parameters.addFileSpec(args, fSpec);
            }
        }
        return args.toArray(new String[args.size()]);
    }

    private static void addFileSpec(@Nonnull List<String> args, @Nullable IFileSpec fileSpec) {
        Validate.notNull(args);
        if (Objects.nonNull(fileSpec) && fileSpec.getOpStatus() == FileSpecOpStatus.VALID) {
            args.add(fileSpec.getAnnotatedPreferredPathString());
        }
    }

    private static String[] addUnannotatedFileSpecs(@Nonnull List<String> args, @Nullable List<IFileSpec> fileSpecs) {
        Validate.notNull(args);
        if (Objects.nonNull(fileSpecs)) {
            for (IFileSpec fileSpec : fileSpecs) {
                if (!Objects.nonNull(fileSpec) || fileSpec.getOpStatus() != FileSpecOpStatus.VALID) continue;
                args.add(fileSpec.getPreferredPathString());
            }
        }
        return args.toArray(new String[args.size()]);
    }

    public static String[] processParameters(Options opts, IFileSpec fromFileSpec, List<IFileSpec> toFileSpecs, String[] stringParams, IServer server) throws P4JavaException {
        ArrayList<String> args = new ArrayList<String>();
        Parameters.addOpts(args, opts, server);
        if (Objects.nonNull(stringParams)) {
            for (String param : stringParams) {
                if (!StringUtils.isNotBlank((CharSequence)param)) continue;
                args.add(param);
            }
        }
        Parameters.addFileSpec(args, fromFileSpec);
        return Parameters.addFileSpecs(args, toFileSpecs);
    }

    public static String[] processParameters(Options opts, @Nullable IFileSpec fromFile, @Nullable IFileSpec toFile, String branchSpec, IServer server) throws P4JavaException {
        ArrayList<IFileSpec> fromFiles = new ArrayList<IFileSpec>();
        ArrayList<IFileSpec> toFiles = new ArrayList<IFileSpec>();
        if (Objects.nonNull(fromFile)) {
            fromFiles.add(fromFile);
        }
        if (Objects.nonNull(toFile)) {
            toFiles.add(toFile);
        }
        return Parameters.processParameters(opts, fromFiles, toFiles, branchSpec, server);
    }

    public static String[] processParameters(Options opts, @Nullable List<IFileSpec> fromFiles, @Nullable List<IFileSpec> toFiles, String branchSpec, IServer server) throws P4JavaException {
        String dashS = "-s";
        ArrayList<String> args = new ArrayList<String>();
        Parameters.addOpts(args, opts, server);
        boolean hadS = false;
        if (args.contains(dashS)) {
            args.remove(dashS);
            hadS = true;
        }
        if (StringUtils.isNotBlank((CharSequence)branchSpec)) {
            args.add("-b");
            args.add(branchSpec);
        }
        if (hadS) {
            args.add(dashS);
        }
        Parameters.addFileSpecIfValidFileSpec(args, fromFiles);
        Parameters.addFileSpecIfValidFileSpec(args, toFiles);
        return args.toArray(new String[args.size()]);
    }

    private static void addFileSpecIfValidFileSpec(@Nonnull List<String> args, @Nullable List<IFileSpec> fileSpecs) {
        Validate.notNull(args);
        if (Objects.nonNull(fileSpecs)) {
            for (IFileSpec fileSpec : fileSpecs) {
                if (fileSpec.getOpStatus() != FileSpecOpStatus.VALID) continue;
                args.add(fileSpec.getAnnotatedPreferredPathString());
            }
        }
    }
}

