/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.TrustException;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.messages.PerforceMessages;
import com.perforce.p4java.server.Fingerprint;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ClientTrust {
    public static final String DIGEST_TYPE = "SHA";
    public static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String FINGERPRINT_USER_NAME = "**++**";
    public static final String FINGERPRINT_REPLACEMENT_USER_NAME = "++++++";
    public static final String CLIENT_TRUST_MESSAGES = "com.perforce.p4java.messages.ClientTrustMessages";
    public static final String CLIENT_TRUST_WARNING_NOT_ESTABLISHED = "client.trust.warning.notestablished";
    public static final String CLIENT_TRUST_WARNING_NEW_CONNECTION = "client.trust.warning.newconnection";
    public static final String CLIENT_TRUST_WARNING_NEW_KEY = "client.trust.warning.newkey";
    public static final String CLIENT_TRUST_EXCEPTION_NEW_CONNECTION = "client.trust.exception.newconnection";
    public static final String CLIENT_TRUST_EXCEPTION_NEW_KEY = "client.trust.exception.newkey";
    public static final String CLIENT_TRUST_ADD_EXCEPTION_NEW_CONNECTION = "client.trust.add.exception.newconnection";
    public static final String CLIENT_TRUST_ADD_EXCEPTION_NEW_KEY = "client.trust.add.exception.newkey";
    public static final String CLIENT_TRUST_ADDED = "client.trust.added";
    public static final String CLIENT_TRUST_REMOVED = "client.trust.removed";
    public static final String CLIENT_TRUST_ALREADY_ESTABLISHED = "client.trust.alreadyestablished";
    public static final String CLIENT_TRUST_INSTALL_EXCEPTION = "client.trust.install.exception";
    public static final String CLIENT_TRUST_UNINSTALL_EXCEPTION = "client.trust.uninstall.exception";
    public static final String SSL_CLIENT_TRUST_BADDATE = "client.trust.cert.bad.date.exception";
    public static final String SSL_CLIENT_TRUST_BADHOST = "client.trust.cert.bad.host.exception";
    private RpcServer rpcServer = null;
    private static PerforceMessages messages = new PerforceMessages("com.perforce.p4java.messages.ClientTrustMessages");
    private static Set<TrustAnchor> trustedCAs;

    public ClientTrust(RpcServer rpcServer) {
        if (rpcServer == null) {
            throw new NullPointerError("null rpcServer passed to ClientTrust constructor");
        }
        this.rpcServer = rpcServer;
    }

    public void installFingerprint(String serverIpPort, String fingerprintUser, String fingerprint) throws TrustException {
        if (serverIpPort == null) {
            throw new NullPointerError("null serverIpPort passed to the ClientTrust installFingerprint method");
        }
        if (fingerprintUser == null) {
            throw new NullPointerError("null fingerprintUser passed to the ClientTrust installFingerprint method");
        }
        if (fingerprint == null) {
            throw new NullPointerError("null fingerprint passed to the ClientTrust installFingerprint method");
        }
        try {
            this.rpcServer.saveFingerprint(serverIpPort, fingerprintUser, fingerprint);
        }
        catch (ConfigException e) {
            throw new TrustException(TrustException.Type.INSTALL, this.rpcServer.getServerHostPort(), serverIpPort, fingerprint, messages.getMessage(CLIENT_TRUST_INSTALL_EXCEPTION, new Object[]{fingerprint, this.rpcServer.getServerHostPort(), serverIpPort}), e);
        }
    }

    public void removeFingerprint(String serverIpPort, String fingerprintUser) throws TrustException {
        if (serverIpPort == null) {
            throw new NullPointerError("null serverIpPort passed to the ClientTrust removeFingerprint method");
        }
        if (fingerprintUser == null) {
            throw new NullPointerError("null fingerprintUser passed to the ClientTrust removeFingerprint method");
        }
        try {
            this.rpcServer.saveFingerprint(serverIpPort, fingerprintUser, null);
        }
        catch (ConfigException e) {
            throw new TrustException(TrustException.Type.UNINSTALL, this.rpcServer.getServerHostPort(), serverIpPort, null, messages.getMessage(CLIENT_TRUST_UNINSTALL_EXCEPTION, new Object[]{this.rpcServer.getServerHostPort(), serverIpPort}), e);
        }
    }

    public boolean fingerprintExists(String serverKey, String fingerprintUser) {
        if (serverKey == null) {
            throw new NullPointerError("null serverIpPort passed to the ClientTrust fingerprintExists method");
        }
        if (fingerprintUser == null) {
            throw new NullPointerError("null fingerprintUser passed to the ClientTrust fingerprintExists method");
        }
        return this.rpcServer.loadFingerprint(serverKey, fingerprintUser) != null;
    }

    public boolean fingerprintMatches(String serverKey, String fingerprintUser, String fingerprint) {
        Fingerprint existingFingerprint;
        if (serverKey == null) {
            throw new NullPointerError("null serverIpPort passed to the ClientTrust fingerprintMatches method");
        }
        if (fingerprintUser == null) {
            throw new NullPointerError("null fingerprintUser passed to the ClientTrust fingerprintMatches method");
        }
        if (fingerprint == null) {
            throw new NullPointerError("null fingerprint passed to the ClientTrust fingerprintMatches method");
        }
        return this.fingerprintExists(serverKey, fingerprintUser) && (existingFingerprint = this.rpcServer.loadFingerprint(serverKey, fingerprintUser)) != null && existingFingerprint.getFingerprintValue() != null && fingerprint.equalsIgnoreCase(existingFingerprint.getFingerprintValue());
    }

    public static String generateFingerprint(PublicKey publicKey) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(DIGEST_TYPE);
        md.update(publicKey.getEncoded());
        byte[] fp = md.digest();
        return ClientTrust.convert2Hex(fp);
    }

    public static String generateFingerprint(X509Certificate certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance(DIGEST_TYPE);
        md.update(certificate.getEncoded());
        byte[] fp = md.digest();
        return ClientTrust.convert2Hex(fp);
    }

    public static String convert2Hex(byte[] data) {
        int n = data.length;
        StringBuffer sb = new StringBuffer(n * 3 - 1);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(HEX_CHARS[data[i] >> 4 & 0xF]);
            sb.append(HEX_CHARS[data[i] & 0xF]);
        }
        return sb.toString();
    }

    public PerforceMessages getMessages() {
        return messages;
    }

    public static Set<TrustAnchor> getTrustedCAs() throws NoSuchAlgorithmException, KeyStoreException, InvalidAlgorithmParameterException {
        return ClientTrust.getTrustedCAs(false);
    }

    public static synchronized Set<TrustAnchor> getTrustedCAs(boolean refreshCache) throws NoSuchAlgorithmException, KeyStoreException, InvalidAlgorithmParameterException {
        if (!refreshCache && trustedCAs != null) {
            return trustedCAs;
        }
        X509TrustManager x509tm = ClientTrust.getDefaultX509TrustManager();
        trustedCAs = new HashSet<TrustAnchor>();
        for (X509Certificate cert : x509tm.getAcceptedIssuers()) {
            trustedCAs.add(new TrustAnchor(cert, null));
        }
        return trustedCAs;
    }

    public static X509TrustManager getDefaultX509TrustManager() throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        for (TrustManager trustMgr : tmf.getTrustManagers()) {
            if (!(trustMgr instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustMgr;
        }
        throw new IllegalStateException("X509TrustManager is not found");
    }

    public static void validateServerChain(X509Certificate[] certs, String refName) throws CertificateException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (X509Certificate cert : certs) {
            if (certList.contains(cert)) continue;
            certList.add(cert);
        }
        try {
            ClientTrust.verifyCertificateSubject(certs[0], refName);
            ClientTrust.verifyCertificateDates(certs[0]);
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            CertPath path = certFactory.generateCertPath(certList);
            PKIXParameters pkixParameters = new PKIXParameters(ClientTrust.getTrustedCAs());
            pkixParameters.setRevocationEnabled(false);
            PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate(path, pkixParameters);
        }
        catch (UnknownHostException | GeneralSecurityException e) {
            throw new CertificateException(e);
        }
    }

    public static void verifyCertificateDates(X509Certificate cert) throws CertificateException {
        Date after = cert.getNotAfter();
        Date now = new Date();
        Date before = cert.getNotBefore();
        if (now.before(before)) {
            throw new CertificateException(messages.getMessage(SSL_CLIENT_TRUST_BADDATE, new Object[]{"before", before}));
        }
        if (now.after(after)) {
            throw new CertificateException(messages.getMessage(SSL_CLIENT_TRUST_BADDATE, new Object[]{"after", after}));
        }
    }

    public static void verifyCertificateSubject(X509Certificate cert, String hostName) throws CertificateParsingException, CertificateException, UnknownHostException {
        InetAddress address = InetAddress.getByName(hostName);
        for (List<?> entry : cert.getSubjectAlternativeNames()) {
            int type = (Integer)entry.get(0);
            if (type != 2 && type != 7 || !ClientTrust.matchSubject((String)entry.get(1), hostName) && !ClientTrust.matchSubject((String)entry.get(1), address.getHostAddress())) continue;
            return;
        }
        String cn = cert.getSubjectDN().getName();
        if (cn.startsWith("CN=")) {
            cn = cn.substring(3);
        }
        if (ClientTrust.matchSubject(cn, hostName) || ClientTrust.matchSubject(cn, address.getHostAddress())) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (List<?> entry : cert.getSubjectAlternativeNames()) {
            int type = (Integer)entry.get(0);
            if (type != 2 && type != 7) continue;
            sb.append((String)entry.get(1) + ",");
        }
        sb.append(cn);
        throw new CertificateException(messages.getMessage(SSL_CLIENT_TRUST_BADHOST, new Object[]{hostName, sb}));
    }

    private static boolean matchSubject(String subject, String refName) {
        if (subject.startsWith("*.")) {
            subject = subject.substring(1);
            int firstDot = refName.indexOf(".");
            int n = firstDot = firstDot >= 0 ? firstDot : 0;
            if (subject.equalsIgnoreCase(refName.substring(firstDot))) {
                return true;
            }
        }
        return subject.equalsIgnoreCase(refName);
    }
}

