/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.GetFileContentsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IPrintDelegator;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;

public class PrintDelegator
extends BaseDelegator
implements IPrintDelegator {
    public PrintDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, boolean allRevs, boolean noHeaderLine) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getFileContents(fileSpecs, new GetFileContentsOptions(allRevs, noHeaderLine));
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public InputStream getFileContents(List<IFileSpec> fileSpecs, GetFileContentsOptions opts) throws P4JavaException {
        boolean annotateFiles = Objects.isNull(opts) || !opts.isDontAnnotateFiles();
        return this.execStreamCmd(CmdSpec.PRINT, Parameters.processParameters((Options)opts, fileSpecs, null, annotateFiles, (IServer)this.server));
    }
}

