/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.client.ClientSummary;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetClientsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IClientsDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ClientsDelegator
extends BaseDelegator
implements IClientsDelegator {
    public ClientsDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IClientSummary> getClients(GetClientsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.CLIENTS, Parameters.processParameters(opts, this.server), null);
        P4JavaExceptions.throwP4JavaErrorIfConditionFails(Objects.nonNull(resultMaps), "Null resultMaps in getClientList call", new Object[0]);
        ArrayList<IClientSummary> specList = new ArrayList<IClientSummary>();
        for (Map<String, Object> map : resultMaps) {
            ResultMapParser.throwRequestExceptionIfErrorMessageFound(map);
            specList.add(new ClientSummary(map, true));
        }
        return specList;
    }

    @Override
    public List<IClientSummary> getClients(String userName, String nameFilter, int maxResults) throws ConnectionException, RequestException, AccessException {
        this.checkMinSupportedPerforceVersion(userName, maxResults, nameFilter, "client");
        try {
            GetClientsOptions getClientsOptions = new GetClientsOptions().setMaxResults(maxResults).setUserName(userName).setNameFilter(nameFilter);
            return this.getClients(getClientsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }
}

