/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.ServerStats;
import java.io.IOException;
import java.io.InputStream;

public class RpcRshInputStream
extends InputStream {
    public static final String TRACE_PREFIX = "RpcRshInputStream";
    private InputStream rshStream = null;
    private ServerStats stats = null;

    public RpcRshInputStream(InputStream inputstream, ServerStats stats) {
        if (inputstream == null) {
            throw new NullPointerError("null inputstream passed to RpcRshInputStream constructor");
        }
        this.stats = stats;
        this.rshStream = inputstream;
    }

    @Override
    public int read() throws IOException {
        if (this.rshStream == null) {
            throw new NullPointerError("null socket stream in RpcRshInputStream.read()");
        }
        int retVal = this.rshStream.read();
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        if (this.rshStream == null) {
            throw new NullPointerError("null socket stream in RpcRshInputStream.read()");
        }
        if (bytes == null) {
            throw new NullPointerError("null byte array in RpcRshInputStream.read()");
        }
        int retVal = this.rshStream.read(bytes);
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    @Override
    public int read(byte[] bytes, int offset, int len) throws IOException {
        if (this.rshStream == null) {
            throw new NullPointerError("null rsh stream in RpcRshInputStream.read()");
        }
        if (bytes == null) {
            throw new NullPointerError("null byte array in RpcRshInputStream.read()");
        }
        int retVal = this.rshStream.read(bytes, offset, len);
        if (this.stats != null && this.stats.largestRecv.get() < (long)retVal) {
            this.stats.largestRecv.set(retVal);
        }
        return retVal;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.rshStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.rshStream.available();
    }

    @Override
    public void close() throws IOException {
        this.rshStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.rshStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.rshStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.rshStream.markSupported();
    }

    public String toString() {
        return "RpcRshInputStream[" + this.rshStream + ']';
    }

    protected InputStream getRshStream() {
        return this.rshStream;
    }

    protected void setRshStream(InputStream rshStream) {
        this.rshStream = rshStream;
    }
}

