/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

final class Mangle {
    private static final int BPB = 8;
    private int[] o = new int[8];
    private int[] pr = new int[8];
    private int[] s0 = new int[16];
    private int[] s1 = new int[16];
    private int[] s2 = new int[8];

    protected Mangle() {
        this.o[0] = 7;
        this.o[1] = 6;
        this.o[2] = 2;
        this.o[3] = 1;
        this.o[4] = 5;
        this.o[5] = 0;
        this.o[6] = 3;
        this.o[7] = 4;
        this.pr[0] = 2;
        this.pr[1] = 5;
        this.pr[2] = 4;
        this.pr[3] = 0;
        this.pr[4] = 3;
        this.pr[5] = 1;
        this.pr[6] = 7;
        this.pr[7] = 6;
        this.s0[0] = 12;
        this.s0[1] = 15;
        this.s0[2] = 7;
        this.s0[3] = 10;
        this.s0[4] = 14;
        this.s0[5] = 13;
        this.s0[6] = 11;
        this.s0[7] = 0;
        this.s0[8] = 2;
        this.s0[9] = 6;
        this.s0[10] = 3;
        this.s0[11] = 1;
        this.s0[12] = 9;
        this.s0[13] = 4;
        this.s0[14] = 5;
        this.s0[15] = 8;
        this.s1[0] = 7;
        this.s1[1] = 2;
        this.s1[2] = 14;
        this.s1[3] = 9;
        this.s1[4] = 3;
        this.s1[5] = 11;
        this.s1[6] = 0;
        this.s1[7] = 4;
        this.s1[8] = 12;
        this.s1[9] = 13;
        this.s1[10] = 1;
        this.s1[11] = 10;
        this.s1[12] = 6;
        this.s1[13] = 15;
        this.s1[14] = 8;
        this.s1[15] = 5;
        this.s2[0] = 10;
        this.s2[1] = 1;
        this.s2[2] = 13;
        this.s2[3] = 12;
        this.s2[4] = 4;
        this.s2[5] = 0;
        this.s2[6] = 11;
        this.s2[7] = 3;
    }

    private static char OtoX(char o) {
        return (char)(o >= '\n' ? o - 10 + 65 : o + 48);
    }

    private String OtoX(String octet) {
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < octet.length(); ++i) {
            hex.append(Mangle.OtoX((char)(octet.charAt(i) >> 4 & 0xF)));
            hex.append(Mangle.OtoX((char)(octet.charAt(i) >> 0 & 0xF)));
        }
        return hex.toString();
    }

    protected String OtoX(byte[] octets) {
        if (octets == null) {
            throw new NullPointerError("null octets byte array in Mangle.OtoX");
        }
        StringBuilder strBldr = new StringBuilder();
        for (int i = 0; i < octets.length; ++i) {
            strBldr.append(Mangle.OtoX((char)(octets[i] >> 4 & 0xF)));
            strBldr.append(Mangle.OtoX((char)(octets[i] >> 0 & 0xF)));
        }
        return strBldr.toString();
    }

    protected static byte[] XtoO(String hex) {
        if (hex == null || hex.length() / 2 == 0) {
            throw new P4JavaError("bad XtoO conversion parameters");
        }
        byte[] octets = new byte[hex.length() / 2];
        int i = 0;
        for (int j = 0; i < hex.length() && j < octets.length; i += 2, ++j) {
            octets[j] = (byte)((byte)((Mangle.XtoO(hex.charAt(i)) & 0xF) << 4) | (byte)(Mangle.XtoO(hex.charAt(i + 1)) & 0xF));
        }
        return octets;
    }

    protected static byte XtoO(char c) {
        return (byte)(c - (c > '9' ? (c >= 'a' ? 87 : 55) : 48));
    }

    protected String xor32(String data, String key) {
        if (data == null || key == null || data.length() != 32 || key.length() != 32) {
            throw new P4JavaError("bad parameters to Mangle.xor32");
        }
        byte[] dataBytes = Mangle.XtoO(data);
        byte[] keyBytes = Mangle.XtoO(key);
        byte[] resultBytes = new byte[16];
        for (int i = 0; i < resultBytes.length; ++i) {
            resultBytes[i] = (byte)(dataBytes[i] ^ keyBytes[i]);
        }
        return this.OtoX(resultBytes);
    }

    protected String encrypt(String data, String key) throws UnsupportedEncodingException {
        StringBuffer mangledValue = new StringBuffer();
        byte[] dataBytes = data.getBytes(CharsetDefs.UTF8.name());
        int inputLen = dataBytes.length;
        int offset = 0;
        char[] dataChars = new char[inputLen];
        for (int i = 0; i < dataBytes.length; ++i) {
            dataChars[i] = (char)dataBytes[i];
        }
        while (offset < inputLen) {
            int chunkSize = inputLen - offset;
            if (chunkSize > 16) {
                chunkSize = 16;
            }
            String chunkData = new String(dataChars, offset, chunkSize);
            String mangledChunk = this.mangle(chunkData, key, false);
            mangledValue.append(mangledChunk);
            offset += chunkSize;
        }
        return mangledValue.toString();
    }

    protected String mangle(String data, String key, boolean digest) {
        int output;
        int i;
        int c;
        int counter;
        int[] m = new int[128];
        int[] k = new int[128];
        char[] src = new char[16];
        char[] enc = new char[16];
        char[] buf = new char[16];
        String mangled = null;
        if (key == null || data == null) {
            throw new NullPointerError("null argument in mangle()");
        }
        if (!digest && data.length() > 16) {
            return mangled;
        }
        Arrays.fill(src, '\u0000');
        Arrays.fill(enc, '\u0000');
        Arrays.fill(buf, '\u0000');
        System.arraycopy(key.toCharArray(), 0, buf, 0, key.length() > 16 ? 16 : key.length());
        if (digest) {
            byte[] srcBytes = Mangle.XtoO(data);
            for (int z = 0; z < srcBytes.length; ++z) {
                src[z] = (char)srcBytes[z];
            }
        } else {
            System.arraycopy(data.toCharArray(), 0, src, 0, data.length());
        }
        StringBuilder p = new StringBuilder();
        p.append(src);
        StringBuilder q = new StringBuilder();
        q.append(enc);
        for (counter = 0; counter < 16; ++counter) {
            c = buf[counter] & 0xFF;
            for (i = 0; i < 8; ++i) {
                k[8 * counter + i] = c & 1;
                c >>= 1;
            }
        }
        counter = 0;
        int qIndex = 0;
        for (int j = 0; j < 16; ++j) {
            c = p.charAt(j);
            if (counter == 16) {
                this.Getdval(m, k);
                for (counter = 0; counter < 16; ++counter) {
                    output = 0;
                    for (i = 7; i >= 0; --i) {
                        output = (output << 1) + m[8 * counter + i];
                    }
                    q.setCharAt(qIndex, (char)output);
                    ++qIndex;
                }
                counter = 0;
            }
            for (i = 0; i < 8; ++i) {
                m[8 * counter + i] = c & 1;
                c >>= 1;
            }
            ++counter;
        }
        while (counter < 16) {
            for (i = 0; i < 8; ++i) {
                m[8 * counter + i] = 0;
            }
            ++counter;
        }
        this.Getdval(m, k);
        for (counter = 0; counter < 16; ++counter) {
            output = 0;
            for (i = 7; i >= 0; --i) {
                output = (output << 1) + m[8 * counter + i];
            }
            q.setCharAt(qIndex, (char)output);
            ++qIndex;
        }
        mangled = this.OtoX(q.toString());
        return mangled;
    }

    private void Getdval(int[] m, int[] k) {
        int bit;
        int temp1;
        int _byte;
        int[] tr = new int[8];
        int h_0 = 0;
        int h_1 = 1;
        int tcbcontrol = 0;
        for (int round = 0; round < 16; ++round) {
            int tcbindex = tcbcontrol;
            for (_byte = 0; _byte < 8; ++_byte) {
                int lo = m[h_1 * 64 + 8 * _byte + 7] * 8 + m[h_1 * 64 + 8 * _byte + 6] * 4 + m[h_1 * 64 + 8 * _byte + 5] * 2 + m[h_1 * 64 + 8 * _byte + 4];
                int hi = m[h_1 * 64 + 8 * _byte + 3] * 8 + m[h_1 * 64 + 8 * _byte + 2] * 4 + m[h_1 * 64 + 8 * _byte + 1] * 2 + m[h_1 * 64 + 8 * _byte + 0];
                int v = (this.s0[lo] + 16 * this.s1[hi]) * (1 - k[8 * tcbindex + _byte]) + (this.s0[hi] + 16 * this.s1[lo]) * k[8 * tcbindex + _byte];
                for (temp1 = 0; temp1 < 8; ++temp1) {
                    tr[temp1] = v & 1;
                    v >>= 1;
                }
                for (bit = 0; bit < 8; ++bit) {
                    int index = this.o[bit] + _byte & 7;
                    temp1 = m[h_0 * 64 + 8 * index + bit] + k[8 * tcbcontrol + this.pr[bit]] + tr[this.pr[bit]];
                    m[h_0 * 64 + 8 * index + bit] = temp1 & 1;
                }
                if (_byte >= 7) continue;
                tcbcontrol = tcbcontrol + 1 & 0xF;
            }
            temp1 = h_0;
            h_0 = h_1;
            h_1 = temp1;
        }
        for (_byte = 0; _byte < 8; ++_byte) {
            for (bit = 0; bit < 8; ++bit) {
                temp1 = m[8 * _byte + bit];
                m[8 * _byte + bit] = m[64 + 8 * _byte + bit];
                m[64 + 8 * _byte + bit] = temp1;
            }
        }
    }
}

