/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.common.function.FunctionWithException;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.file.FilePath;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.SetFileAttributesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IAttributeDelegator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class AttributeDelegator
extends BaseDelegator
implements IAttributeDelegator {
    public AttributeDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileSpec> unsetFileAttribute(List<IFileSpec> files, @Nonnull String attribute, SetFileAttributesOptions opts) throws P4JavaException {
        Validate.notNull((Object)attribute);
        HashMap<String, String> attributesToUnsetMap = new HashMap<String, String>();
        attributesToUnsetMap.put(attribute, "");
        return this.setFileAttributes(files, attributesToUnsetMap, opts);
    }

    @Override
    public List<IFileSpec> unsetFileAttributes(List<IFileSpec> files, @Nonnull List<String> attributes, SetFileAttributesOptions opts) throws P4JavaException {
        Validate.notNull(attributes);
        HashMap<String, String> attributesToUnsetMap = new HashMap<String, String>();
        for (String attribute : attributes) {
            attributesToUnsetMap.put(attribute, "");
        }
        return this.setFileAttributes(files, attributesToUnsetMap, opts);
    }

    @Override
    public List<IFileSpec> setFileAttributes(List<IFileSpec> files, @Nonnull Map<String, String> attributes, SetFileAttributesOptions opts) throws P4JavaException {
        Validate.notNull(attributes);
        ArrayList<String> args = new ArrayList<String>();
        for (String string : attributes.keySet()) {
            args.add("-n" + string);
        }
        for (Map.Entry entry : attributes.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            args.add("-v" + (String)entry.getValue());
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.ATTRIBUTE, Parameters.processParameters((Options)opts, files, args.toArray(new String[args.size()]), true, (IServer)this.server), null);
        return this.buildSetFileAttributesFileSpecsFromCommandResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(new FunctionWithException<Map<String, Object>, IFileSpec>(){

            @Override
            public IFileSpec apply(Map<String, Object> map) throws P4JavaException {
                return ResultListBuilder.handleFileReturn(map, AttributeDelegator.this.server);
            }
        }));
    }

    @Override
    public List<IFileSpec> setFileAttributes(List<IFileSpec> files, @Nonnull String attributeName, @Nonnull InputStream inStream, SetFileAttributesOptions opts) throws P4JavaException {
        Validate.notNull((Object)inStream);
        Validate.notBlank((CharSequence)attributeName, (String)"Attribute name shouldn't blank", (Object[])new Object[0]);
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("attributeInstream", inStream);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.ATTRIBUTE, Parameters.processParameters((Options)opts, files, new String[]{"-i", "-n" + attributeName}, true, (IServer)this.server), inputMap);
        return this.buildSetFileAttributesFileSpecsFromCommandResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(new FunctionWithException<Map<String, Object>, IFileSpec>(){

            @Override
            public IFileSpec apply(Map<String, Object> map) throws P4JavaException {
                return ResultListBuilder.handleFileReturn(map, AttributeDelegator.this.server);
            }
        }));
    }

    private List<IFileSpec> buildSetFileAttributesFileSpecsFromCommandResultMaps(@Nullable List<Map<String, Object>> resultMaps, @Nonnull Function<Map<String, Object>, IFileSpec> handle) throws RequestException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (Objects.nonNull(resultMaps)) {
            ArrayList<String> filesSeen = new ArrayList<String>();
            for (Map<String, Object> map : resultMaps) {
                IFileSpec spec = handle.apply(map);
                if (spec.getOpStatus() == FileSpecOpStatus.VALID) {
                    String file = spec.getAnnotatedPathString(FilePath.PathType.DEPOT);
                    if (!StringUtils.isNotBlank((CharSequence)file) || filesSeen.contains(file)) continue;
                    filesSeen.add(file);
                    resultList.add(spec);
                    continue;
                }
                resultList.add(spec);
            }
        }
        return resultList;
    }
}

