/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys.helper;

import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;

public class RpcSystemFileCommandsHelper
extends SymbolicLinkHelper {
    @Override
    public boolean setWritable(String fileName, boolean writable) {
        if (SymbolicLinkHelper.isSymbolicLink(fileName)) {
            return true;
        }
        return new File(fileName).setWritable(writable);
    }

    @Override
    public boolean setReadable(String fileName, boolean readable, boolean ownerOnly) {
        return new File(fileName).setReadable(readable, ownerOnly);
    }

    @Override
    public boolean setOwnerReadOnly(String fileName) {
        boolean set = this.setReadable(fileName, false, false);
        return set &= this.setReadable(fileName, true, true);
    }

    @Override
    public boolean setExecutable(String fileName, boolean executable, boolean ownerOnly) {
        return new File(fileName).setExecutable(executable, ownerOnly);
    }

    @Override
    public boolean canExecute(String fileName) {
        return Files.isExecutable(Paths.get(fileName, new String[0]));
    }

    @Override
    public boolean isSymlink(String fileName) {
        return RpcSystemFileCommandsHelper.isSymbolicLink(fileName);
    }
}

