/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.server.GetKeysOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IKeysDelegator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KeysDelegator
extends BaseDelegator
implements IKeysDelegator {
    private static final String KEY_NAME = "key";
    private static final String VALUE_NAME = "value";

    public KeysDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public Map<String, String> getKeys(GetKeysOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.KEYS, Parameters.processParameters(opts, this.server), null);
        return this.parseKeysCommandResultMaps(resultMaps);
    }

    private Map<String, String> parseKeysCommandResultMaps(List<Map<String, Object>> resultMaps) throws P4JavaException {
        HashMap<String, String> expectedMap = new HashMap<String, String>();
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (ResultMapParser.handleErrorOrInfoStr(map)) continue;
                expectedMap.put(P4ResultMapUtils.parseString(map, KEY_NAME), P4ResultMapUtils.parseString(map, VALUE_NAME));
            }
        }
        return expectedMap;
    }
}

