/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.IServerResource;
import com.perforce.p4java.core.ViewMap;
import java.util.Date;

public interface IDepot
extends IServerResource {
    public String getName();

    public String getOwnerName();

    public Date getModDate();

    public String getDescription();

    public DepotType getDepotType();

    public String getAddress();

    public String getSuffix();

    public String getStreamDepth();

    public String getMap();

    public ViewMap<IMapEntry> getSpecMap();

    public static enum DepotType {
        LOCAL,
        REMOTE,
        SPEC,
        STREAM,
        ARCHIVE,
        UNLOAD,
        TANGENT,
        EXTENSION,
        GRAPH,
        UNKNOWN;


        public static DepotType fromString(String str) {
            if (str == null) {
                return null;
            }
            try {
                return DepotType.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                Log.error("Bad conversion attempt in DepotType.fromString; string: " + str + "; message: " + iae.getMessage(), new Object[0]);
                Log.exception(iae);
                return UNKNOWN;
            }
        }
    }
}

