/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ServerResource;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class UserGroup
extends ServerResource
implements IUserGroup {
    private static final String UNSET_STR = "unset";
    private static final String UNLIMITED_STR = "unlimited";
    private String name = null;
    private int maxResults = 0;
    private int maxScanRows = 0;
    private int maxLockTime = 0;
    private int timeout = 0;
    private int passwordTimeout = 0;
    private boolean subGroup = false;
    private List<String> subgroups = new ArrayList<String>();
    private List<String> owners = new ArrayList<String>();
    private List<String> users = new ArrayList<String>();
    private int maxOpenFiles = -2147483647;

    public static UserGroup newUserGroup(@Nonnull String name, @Nonnull List<String> users) {
        Validate.notNull((Object)name);
        UserGroup group = new UserGroup();
        group.setName(name);
        group.setUsers(users);
        return group;
    }

    @Override
    public void setUsers(List<String> users) {
        if (ObjectUtils.nonNull(users)) {
            this.users.addAll(users);
        }
    }

    public UserGroup() {
        super(true, true);
    }

    public UserGroup(@Nullable Map<String, Object> map) {
        super(true, true);
        if (ObjectUtils.nonNull(map)) {
            try {
                this.name = (String)map.get("Group");
                this.maxLockTime = this.parseGroupIntValue((String)map.get("MaxLockTime"));
                this.maxResults = this.parseGroupIntValue((String)map.get("MaxResults"));
                this.maxScanRows = this.parseGroupIntValue((String)map.get("MaxScanRows"));
                if (map.containsKey("MaxOpenFiles")) {
                    this.maxOpenFiles = this.parseGroupIntValue((String)map.get("MaxOpenFiles"));
                }
                this.timeout = this.parseGroupIntValue((String)map.get("Timeout"));
                this.passwordTimeout = this.parseGroupIntValue((String)map.get("PasswordTimeout"));
                this.addToListIfKeyIsNotExistInMap(this.users, map, "Users");
                this.addToListIfKeyIsNotExistInMap(this.owners, map, "Owners");
                this.addToListIfKeyIsNotExistInMap(this.subgroups, map, "Subgroups");
            }
            catch (Throwable thr) {
                Log.warn("Unexpected exception in UserGroup constructor: %s", thr.getMessage());
                Log.exception(thr);
            }
        }
    }

    public int parseGroupIntValue(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            if (UNSET_STR.equalsIgnoreCase(str)) {
                return 0;
            }
            if (UNLIMITED_STR.equalsIgnoreCase(str)) {
                return -1;
            }
            return new Integer(str);
        }
        return 0;
    }

    private void addToListIfKeyIsNotExistInMap(@Nonnull List<String> lists, @Nonnull Map<String, Object> map, @Nonnull String key) {
        int i = 0;
        while (map.containsKey(key + i)) {
            lists.add((String)map.get(key + i));
            ++i;
        }
    }

    @Override
    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    @Override
    public void setMaxLockTime(int maxLockTimeOfMilliSeconds) {
        this.maxLockTime = maxLockTimeOfMilliSeconds;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public int getMaxScanRows() {
        return this.maxScanRows;
    }

    @Override
    public void setMaxScanRows(int maxScanRows) {
        this.maxScanRows = maxScanRows;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<String> getOwners() {
        return this.owners;
    }

    @Override
    public int getPasswordTimeout() {
        return this.passwordTimeout;
    }

    @Override
    public void setPasswordTimeout(int passwordTimeoutOfSeconds) {
        this.passwordTimeout = passwordTimeoutOfSeconds;
    }

    @Override
    public List<String> getSubgroups() {
        return this.subgroups;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(int timeoutOfSeconds) {
        this.timeout = timeoutOfSeconds;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public boolean isSubGroup() {
        return this.subGroup;
    }

    @Override
    public void setSubGroup(boolean subGroup) {
        this.subGroup = subGroup;
    }

    @Override
    public int getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    @Override
    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IUserGroup refreshedUserGroup;
        IServer refreshServer = this.server;
        String refreshName = this.getName();
        if (ObjectUtils.nonNull(refreshServer) && StringUtils.isNotBlank((CharSequence)refreshName) && ObjectUtils.nonNull(refreshedUserGroup = refreshServer.getUserGroup(refreshName))) {
            this.maxLockTime = refreshedUserGroup.getMaxLockTime();
            this.name = refreshedUserGroup.getName();
            this.maxResults = refreshedUserGroup.getMaxResults();
            this.maxScanRows = refreshedUserGroup.getMaxScanRows();
            this.owners = refreshedUserGroup.getOwners();
            this.subGroup = refreshedUserGroup.isSubGroup();
            this.timeout = refreshedUserGroup.getTimeout();
            this.subgroups = refreshedUserGroup.getSubgroups();
            this.users = refreshedUserGroup.getUsers();
        }
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        this.server.updateUserGroup((IUserGroup)this, false);
    }

    @Override
    public void setSubgroups(List<String> subgroups) {
        if (ObjectUtils.nonNull(subgroups)) {
            this.subgroups.addAll(subgroups);
        }
    }

    @Override
    public void setOwners(List<String> owners) {
        if (ObjectUtils.nonNull(owners)) {
            this.owners.addAll(owners);
        }
    }

    public UserGroup addOwner(String owner) {
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            this.owners.add(owner);
        }
        return this;
    }

    public UserGroup addSubgroup(String subgroup) {
        if (StringUtils.isNotBlank((CharSequence)subgroup)) {
            this.subgroups.add(subgroup);
        }
        return this;
    }

    public UserGroup addUser(String user) {
        if (StringUtils.isNotBlank((CharSequence)user)) {
            this.users.add(user);
        }
        return this;
    }
}

