/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.common.base.StringHelper;
import com.perforce.p4java.core.IRepo;
import com.perforce.p4java.impl.generic.core.ServerResource;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Repo
extends ServerResource
implements IRepo {
    private String name = null;
    private String ownerName = null;
    private Date createdDate = null;
    private Date pushedDate = null;
    private String forkedFrom = null;
    private String description = null;
    private String defaultBranch = null;
    private String mirroredFrom = null;

    public Repo() {
        super(false, false);
    }

    public Repo(Map<String, Object> repoMap) {
        super(false, false);
        if (ObjectUtils.nonNull(repoMap)) {
            try {
                this.name = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(repoMap, "name"), P4ResultMapUtils.parseString(repoMap, "Repo"));
                this.ownerName = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(repoMap, "owner"), P4ResultMapUtils.parseString(repoMap, "Owner"));
                if (ObjectUtils.nonNull(repoMap.get("Created"))) {
                    this.createdDate = new Date(P4ResultMapUtils.parseLong(repoMap, "Created") * 1000L);
                }
                if (ObjectUtils.nonNull(repoMap.get("Pushed"))) {
                    this.pushedDate = new Date(P4ResultMapUtils.parseLong(repoMap, "Pushed") * 1000L);
                }
                this.forkedFrom = P4ResultMapUtils.parseString(repoMap, "ForkedFrom");
                this.description = StringHelper.firstNonBlank(P4ResultMapUtils.parseString(repoMap, "desc"), P4ResultMapUtils.parseString(repoMap, "Description"));
                if (StringUtils.isNotBlank((CharSequence)this.description) && this.description.length() > 1 && StringUtils.endsWith((CharSequence)this.description, (CharSequence)"\n")) {
                    this.description = StringUtils.substring((String)this.description, (int)0, (int)(this.description.length() - 1));
                }
                this.defaultBranch = P4ResultMapUtils.parseString(repoMap, "DefaultBranch");
                this.mirroredFrom = P4ResultMapUtils.parseString(repoMap, "MirroredFrom");
            }
            catch (Throwable thr) {
                Log.error("Unexpected exception in Repo constructor: %s", thr.getLocalizedMessage());
                Log.exception(thr);
            }
        }
    }

    public Repo(String name, Date createdDate, Date pushedDate) {
        this(name, null, createdDate, pushedDate, null);
    }

    public Repo(String name, String ownerName, Date createdDate, Date pushedDate, String description) {
        this.name = name;
        this.ownerName = ownerName;
        this.createdDate = createdDate;
        this.pushedDate = pushedDate;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public Date getPushedDate() {
        return this.pushedDate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getForkedFrom() {
        return this.forkedFrom;
    }

    @Override
    public void setForkedFrom(String forkedFrom) {
        this.forkedFrom = forkedFrom;
    }

    @Override
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    public void setDefaultBranch(String defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    @Override
    public String getMirroredFrom() {
        return this.mirroredFrom;
    }

    @Override
    public void setMirroredFrom(String mirroredFrom) {
        this.mirroredFrom = mirroredFrom;
    }
}

