/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.option;

import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.exception.OptionsException;
import com.perforce.p4java.option.server.OptionsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum OptionsSpecType {
    IntOption("i"){

        @Override
        String getP4CommandOptionField(String ruleName, String serverOptionStr, Object optValue) throws OptionsException {
            try {
                String securityOptValue = String.valueOf(optValue);
                return OptionsHelper.applyRule(ruleName, serverOptionStr, Integer.parseInt(securityOptValue));
            }
            catch (Exception e) {
                throw new OptionsException(e);
            }
        }
    }
    ,
    LongOption("l"){

        @Override
        String getP4CommandOptionField(String ruleName, String serverOptionStr, Object optValue) throws OptionsException {
            try {
                String securityOptValue = String.valueOf(optValue);
                return OptionsHelper.applyRule(ruleName, serverOptionStr, Long.parseLong(securityOptValue));
            }
            catch (Exception e) {
                throw new OptionsException(e);
            }
        }
    }
    ,
    BoolOption("b"){

        @Override
        String getP4CommandOptionField(String ruleName, String serverOptionStr, Object optValue) throws OptionsException {
            try {
                return OptionsHelper.applyRule(ruleName, serverOptionStr, OptionsHelper.objectToBoolean(optValue));
            }
            catch (Exception e) {
                throw new OptionsException(e);
            }
        }
    }
    ,
    StringOption("s"),
    StringArrayOption("s[]"){

        @Override
        List<String> getP4CommandOptionFields(String ruleName, String serverOptionStr, Object optValue) throws OptionsException {
            ArrayList<String> p4CommandOptionFields = new ArrayList<String>();
            if (ObjectUtils.nonNull(optValue)) {
                P4JavaExceptions.throwOptionsExceptionIfConditionFails(optValue instanceof String[], "Invalid opt value, expected '%s' is a string array object", optValue);
                for (String opt : (String[])optValue) {
                    String p4CommandOptionField = OptionsHelper.applyRule(ruleName, serverOptionStr, opt);
                    if (!StringUtils.isNotBlank((CharSequence)p4CommandOptionField)) continue;
                    p4CommandOptionFields.add(p4CommandOptionField);
                }
            }
            return p4CommandOptionFields;
        }
    };

    private static final Map<String, OptionsSpecType> p4CommandOptionsMap;
    private String optSpecType;

    private OptionsSpecType(String optSpecType) {
        this.optSpecType = optSpecType;
    }

    static OptionsSpecType of(String optSpecType) throws OptionsException {
        OptionsSpecType p4CommandOptions = p4CommandOptionsMap.get(optSpecType);
        if (ObjectUtils.nonNull((Object)p4CommandOptions)) {
            return p4CommandOptions;
        }
        throw new OptionsException("Unknown option spec type");
    }

    List<String> getP4CommandOptionFields(String ruleName, String serverOptionStr, Object optValue) throws OptionsException {
        ArrayList<String> p4CommandOptionFields = new ArrayList<String>();
        String p4CommandOptionFiled = this.getP4CommandOptionField(ruleName, serverOptionStr, optValue);
        if (StringUtils.isNotBlank((CharSequence)p4CommandOptionFiled)) {
            p4CommandOptionFields.add(p4CommandOptionFiled);
        }
        return p4CommandOptionFields;
    }

    String getP4CommandOptionField(String ruleName, String serverOptionStr, Object optValue) throws OptionsException {
        String optionField = "";
        if (ObjectUtils.nonNull(optValue)) {
            P4JavaExceptions.throwOptionsExceptionIfConditionFails(optValue instanceof String, "Invalid opt value, expected '%s' to be a string", optValue);
            optionField = OptionsHelper.applyRule(ruleName, serverOptionStr, Objects.toString(optValue));
        }
        return optionField;
    }

    static {
        p4CommandOptionsMap = new HashMap<String, OptionsSpecType>();
        for (OptionsSpecType optionsSpecType : OptionsSpecType.values()) {
            p4CommandOptionsMap.put(optionsSpecType.optSpecType, optionsSpecType);
        }
    }
}

