/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.sys;

import com.perforce.p4java.exception.UnimplementedError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class RpcLineEndFilterInputStream
extends FilterInputStream {
    private ClientLineEnding lineEnding = null;
    private byte[] inBytes = new byte[10240];
    private int inBytesPos = 0;
    private int inBytesRead = 0;

    public RpcLineEndFilterInputStream(InputStream inStream, ClientLineEnding lineEnding) {
        super(inStream);
        this.lineEnding = lineEnding;
        if (this.lineEnding == null) {
            this.lineEnding = ClientLineEnding.FST_L_LOCAL;
        }
        switch (this.lineEnding) {
            case FST_L_LF: 
            case FST_L_CR: 
            case FST_L_CRLF: 
            case FST_L_LFCRLF: {
                break;
            }
            case FST_L_LOCAL: {
                if (Arrays.equals(ClientLineEnding.FST_L_LOCAL_BYTES, ClientLineEnding.FST_L_LF_BYTES)) {
                    this.lineEnding = ClientLineEnding.FST_L_LF;
                    break;
                }
                if (Arrays.equals(ClientLineEnding.FST_L_LOCAL_BYTES, ClientLineEnding.FST_L_CR_BYTES)) {
                    this.lineEnding = ClientLineEnding.FST_L_CR;
                    break;
                }
                if (Arrays.equals(ClientLineEnding.FST_L_LOCAL_BYTES, ClientLineEnding.FST_L_CRLF_BYTES)) {
                    this.lineEnding = ClientLineEnding.FST_L_CRLF;
                    break;
                }
                this.lineEnding = ClientLineEnding.FST_L_LF;
                break;
            }
            case FST_L_CRLF_UTF_16BE: 
            case FST_L_CRLF_UTF_16LE: 
            case FST_L_CR_UTF_16BE: 
            case FST_L_CR_UTF_16LE: 
            case FST_L_LFCRLF_UTF_16BE: 
            case FST_L_LFCRLF_UTF_16LE: 
            case FST_L_LF_UTF_16BE: 
            case FST_L_LF_UTF_16LE: {
                throw new IllegalArgumentException("UTF16 type line ending not allowed here!");
            }
        }
    }

    @Override
    public int read() throws IOException {
        throw new UnimplementedError("RpcLineEndFilterInputStream.read()");
    }

    @Override
    public int read(byte[] targetBytes, int off, int len) throws IOException {
        int bytesOut = 0;
        int outPos = off;
        boolean soaknl = false;
        block6: while (bytesOut < len || soaknl) {
            if (this.inBytesPos == this.inBytesRead) {
                this.inBytesRead = this.in.read(this.inBytes);
                this.inBytesPos = 0;
            }
            if (this.inBytesRead <= 0) break;
            if (soaknl) {
                if (this.inBytes[this.inBytesPos] == 10) {
                    ++this.inBytesPos;
                    targetBytes[outPos - 1] = 10;
                }
                soaknl = false;
            }
            switch (this.lineEnding) {
                case FST_L_LF: {
                    while (bytesOut < len && this.inBytesPos != this.inBytesRead) {
                        targetBytes[outPos++] = this.inBytes[this.inBytesPos++];
                        ++bytesOut;
                    }
                    continue block6;
                }
                case FST_L_CR: {
                    while (bytesOut < len && this.inBytesPos != this.inBytesRead) {
                        targetBytes[outPos++] = this.inBytes[this.inBytesPos++];
                        ++bytesOut;
                        if (targetBytes[outPos - 1] != 13) continue;
                        targetBytes[outPos - 1] = 10;
                        continue block6;
                    }
                    continue block6;
                }
                case FST_L_CRLF: {
                    while (bytesOut < len && this.inBytesPos != this.inBytesRead) {
                        targetBytes[outPos++] = this.inBytes[this.inBytesPos++];
                        ++bytesOut;
                        if (targetBytes[outPos - 1] != 13) continue;
                        soaknl = true;
                        continue block6;
                    }
                    continue block6;
                }
                case FST_L_LFCRLF: {
                    while (bytesOut < len && this.inBytesPos != this.inBytesRead) {
                        targetBytes[outPos++] = this.inBytes[this.inBytesPos++];
                        ++bytesOut;
                        if (targetBytes[outPos - 1] != 13) continue;
                        targetBytes[outPos - 1] = 10;
                        soaknl = true;
                        continue block6;
                    }
                    continue block6;
                }
            }
            throw new IllegalStateException("Translating undefined line ending...");
        }
        return bytesOut == 0 ? -1 : bytesOut;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        throw new UnimplementedError("RpcLineEndFilterInputStream.available()");
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnimplementedError("RpcLineEndFilterInputStream.mark()");
    }

    @Override
    public boolean markSupported() {
        throw new UnimplementedError("RpcLineEndFilterInputStream.read()");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnimplementedError("RpcLineEndFilterInputStream.markSupported()");
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnimplementedError("RpcLineEndFilterInputStream.skip()");
    }
}

