/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.stream;

import com.jcraft.jzlib.ZInputStream;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.UnimplementedError;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class RpcGZIPInputStream
extends InflaterInputStream {
    private ZInputStream jzInStream = null;

    public RpcGZIPInputStream(InputStream in) throws IOException {
        super(in);
        this.jzInStream = new ZInputStream(in, true);
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerError("null byte array passed to RpcGZIPInputStream.read()");
        }
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerError("null byte array passed to RpcGZIPInputStream.read()");
        }
        if (len <= 0 || offset < 0 || offset >= bytes.length || len > bytes.length - offset) {
            throw new P4JavaError("bad length or offset in RpcGZIPInputStream.read()");
        }
        return this.jzInStream.read(bytes, offset, len);
    }

    @Override
    public int read() throws IOException {
        throw new UnimplementedError("single-byte RpcGZIPInputStream.read()");
    }

    @Override
    public void close() throws IOException {
        this.jzInStream.close();
    }
}

