/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.msg;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RpcMessage {
    public static final int NO_GENERIC_CODE_FOUND = -1;
    public static final String CODE = "code";
    public static final String FMT = "fmt";
    private int severity = 0;
    private int subSystem = 8;
    private int generic = 0;
    private int code = 0;
    private String[] fmtStrs = null;
    private String[] argNameStrs = null;
    private String[] argStrs = null;
    private static final String ALT_PATTERN = "\\[[^\\[^\\]]*\\]";
    private static final String PC_PATTERN = "%[^%]*%";
    private static final String SPLIT_PATTERN = "\\|";
    private static final String SPLIT_MARKER = "|";
    private static final String PC_MARKER = "%";
    private static Pattern altPat = Pattern.compile("\\[[^\\[^\\]]*\\]");
    private static Pattern pcPat = Pattern.compile("%[^%]*%");

    public static String interpolateArgs(String fmtStr, Map<String, Object> map) {
        if (fmtStr != null && map != null && (fmtStr.contains(PC_MARKER) || fmtStr.contains(SPLIT_MARKER))) {
            return RpcMessage.doParse(fmtStr, map);
        }
        return fmtStr;
    }

    public RpcMessage(int subSystem, int code, int severity, int generic, String[] fmtStrs, String[] argNameStrs, String[] argStrs) {
        this.subSystem = subSystem;
        this.code = code;
        this.severity = severity;
        this.generic = generic;
        this.fmtStrs = fmtStrs;
        this.argNameStrs = argNameStrs;
        this.argStrs = argStrs;
    }

    public RpcMessage(ClientMessage.ClientMessageId id, int severity, int generic, String[] argStrs) {
        if (id == null) {
            throw new NullPointerError("Null client message ID passed to RpcMessage constructor");
        }
        this.subSystem = 8;
        ClientMessage msg = ClientMessage.getClientMessage(id);
        this.code = msg.getCode();
        this.severity = severity;
        this.generic = generic;
        this.argStrs = argStrs;
        this.fmtStrs = msg.getMsgs();
        this.argNameStrs = msg.getMsgParamNames();
        if (this.argNameStrs != null && this.argStrs != null && this.argNameStrs.length != this.argStrs.length) {
            throw new P4JavaError("Spec length mismatch in RpcMessage constructor");
        }
    }

    public Map<String, Object> toMap() {
        int i;
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        retMap.put("code0", this.makeErrorCodeString());
        if (this.fmtStrs != null) {
            i = 0;
            for (String fmtStr : this.fmtStrs) {
                if (fmtStr == null) continue;
                retMap.put(FMT + i++, fmtStr);
            }
        }
        if (this.argNameStrs != null) {
            i = 0;
            for (String argNameStr : this.argNameStrs) {
                if (argNameStr != null && this.argStrs != null && this.argStrs.length > i && this.argStrs[i] != null) {
                    retMap.put(argNameStr, this.argStrs[i]);
                } else {
                    retMap.put(argNameStr, "");
                }
                ++i;
            }
        }
        return retMap;
    }

    public static int getSeverity(String codeStr) {
        if (codeStr != null) {
            try {
                int rawNum = new Integer(codeStr);
                return rawNum >> 28 & 0xF;
            }
            catch (Exception exc) {
                Log.exception(exc);
            }
        }
        return 0;
    }

    public static int getGeneric(String codeStr) {
        if (codeStr != null) {
            try {
                int rawNum = new Integer(codeStr);
                int severity = rawNum >> 16 & 0xFF;
                return severity;
            }
            catch (Exception exc) {
                Log.exception(exc);
            }
        }
        return 0;
    }

    public static int getSubsystem(String codeStr) {
        if (codeStr != null) {
            try {
                int rawNum = new Integer(codeStr);
                int subSystem = rawNum >> 10 & 0x3F;
                return subSystem;
            }
            catch (Exception exc) {
                Log.exception(exc);
            }
        }
        return 8;
    }

    public String makeErrorCodeString() {
        return "" + new Long(this.severity << 28 | (this.argStrs == null ? 0 : this.argStrs.length) << 24 | this.generic << 16 | this.subSystem << 10 | this.code);
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public int getSubSystem() {
        return this.subSystem;
    }

    public void setSubSystem(int subSystem) {
        this.subSystem = subSystem;
    }

    public int getGeneric() {
        return this.generic;
    }

    public void setGeneric(int generic) {
        this.generic = generic;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String[] getFmtStrs() {
        return this.fmtStrs;
    }

    public void setFmtStrs(String[] fmtStrs) {
        this.fmtStrs = fmtStrs;
    }

    public String[] getArgStrs() {
        return this.argStrs;
    }

    public void setArgStrs(String[] argStrs) {
        this.argStrs = argStrs;
    }

    public String[] getArgNameStrs() {
        return this.argNameStrs;
    }

    public void setArgNameStrs(String[] argNameStrs) {
        this.argNameStrs = argNameStrs;
    }

    private static String doParse(String fmtStr, Map<String, Object> argMap) {
        StringBuilder strBuf = new StringBuilder();
        StringBuilder outBuf = new StringBuilder();
        Matcher altMatcher = altPat.matcher(fmtStr);
        int i = 0;
        while (altMatcher.find()) {
            String match = altMatcher.group();
            strBuf.append(fmtStr.subSequence(i, altMatcher.start()));
            String matchStr = (String)match.subSequence(1, match.length() - 1);
            if (matchStr.contains(SPLIT_MARKER)) {
                String[] splitMatch = matchStr.split(SPLIT_PATTERN);
                if (splitMatch.length == 2 && splitMatch[0] != null && splitMatch[1] != null) {
                    int useIndx = -1;
                    if (splitMatch[0].contains(PC_MARKER)) {
                        useIndx = RpcMessage.containsValueMatches(splitMatch[0], argMap) ? 0 : 1;
                    } else if (splitMatch[1].contains(PC_MARKER)) {
                        useIndx = RpcMessage.containsValueMatches(splitMatch[1], argMap) ? 1 : 0;
                    }
                    if (useIndx < 0 || useIndx > 1) {
                        strBuf.append("[").append(matchStr).append("]");
                    } else {
                        strBuf.append(splitMatch[useIndx]);
                    }
                }
            } else if (RpcMessage.containsValueMatches(matchStr, argMap)) {
                strBuf.append(matchStr);
            } else if (!matchStr.contains(PC_MARKER)) {
                strBuf.append("[").append(matchStr).append("]");
            }
            i = altMatcher.start();
            i += match.length();
        }
        if (i == 0) {
            strBuf.append(fmtStr);
        } else if (i < fmtStr.length()) {
            strBuf.append(fmtStr.subSequence(i, fmtStr.length()));
        }
        Matcher pcMatcher = pcPat.matcher(strBuf);
        int j = 0;
        while (pcMatcher.find()) {
            String match = pcMatcher.group();
            String repl = null;
            outBuf.append(strBuf.subSequence(j, pcMatcher.start()));
            repl = RpcMessage.isUniquote(match) ? match.substring(2, match.length() - 2) : (String)argMap.get(match.subSequence(1, match.length() - 1));
            if (repl != null) {
                outBuf.append(repl);
            } else {
                outBuf.append(match);
            }
            j = pcMatcher.start();
            j += match.length();
        }
        if (j == 0) {
            outBuf.append((CharSequence)strBuf);
        } else if (j < strBuf.length()) {
            outBuf.append(strBuf.subSequence(j, strBuf.length()));
        }
        return outBuf.toString();
    }

    private static boolean containsValueMatches(String str, Map<String, Object> map) {
        if (str != null && map != null) {
            Pattern pcPat = Pattern.compile(PC_PATTERN);
            Matcher pcMatcher = pcPat.matcher(str);
            while (pcMatcher.find()) {
                String pcMatch = pcMatcher.group();
                if (RpcMessage.isUniquote(pcMatch)) {
                    return true;
                }
                String repl = (String)map.get(pcMatch.subSequence(1, pcMatch.length() - 1));
                if (repl == null || repl.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUniquote(String str) {
        return str != null && str.length() >= 4 && str.charAt(1) == '\'' && str.charAt(str.length() - 2) == '\'';
    }
}

