/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.client.IClientViewMapping;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamIgnoredMapping;
import com.perforce.p4java.core.IStreamRemappedMapping;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.IStreamViewMapping;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.generic.core.MapEntry;
import com.perforce.p4java.impl.generic.core.StreamSummary;
import com.perforce.p4java.option.server.StreamOptions;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Stream
extends StreamSummary
implements IStream {
    protected ViewMap<IStreamViewMapping> streamView = null;
    protected ViewMap<IStreamRemappedMapping> remappedView = null;
    protected ViewMap<IStreamIgnoredMapping> ignoredView = null;
    protected ViewMap<IClientViewMapping> clientView = null;
    protected List<IStream.IExtraTag> extraTags = null;
    public static final String DEFAULT_DESCRIPTION = "New stream created by P4Java";

    public static Stream newStream(IOptionsServer server, String streamPath, String type, String parentStreamPath, String name, String description, String options, String[] viewPaths, String[] remappedPaths, String[] ignoredPaths) {
        return Stream.newStream(server, streamPath, type, parentStreamPath, name, description, options, viewPaths, remappedPaths, ignoredPaths, null);
    }

    public static Stream newStream(IOptionsServer server, String streamPath, String type, String parentStreamPath, String name, String description, String options, String[] viewPaths, String[] remappedPaths, String[] ignoredPaths, String[] clientViewPaths) {
        int idx;
        if (server == null) {
            throw new NullPointerError("null server in Stream.newStream()");
        }
        if (type == null) {
            throw new NullPointerError("null stream type in Stream.newStream()");
        }
        if (streamPath == null) {
            throw new NullPointerError("null stream in Stream.newStream()");
        }
        ViewMap<IStreamViewMapping> streamView = new ViewMap<IStreamViewMapping>();
        if (viewPaths != null) {
            int i = 0;
            for (String mapping : viewPaths) {
                if (mapping == null) {
                    throw new NullPointerError("null view mapping string passed to Stream.newStream");
                }
                streamView.addEntry(new StreamViewMapping(i, mapping));
                ++i;
            }
        } else {
            streamView.addEntry(new StreamViewMapping(0, IStreamViewMapping.PathType.SHARE, "...", null));
        }
        ViewMap<IStreamRemappedMapping> remappedView = null;
        if (remappedPaths != null) {
            remappedView = new ViewMap<IStreamRemappedMapping>();
            int i = 0;
            for (String mapping : remappedPaths) {
                if (mapping == null) {
                    throw new NullPointerError("null remapped mapping string passed to Stream.newStream");
                }
                remappedView.addEntry(new StreamRemappedMapping(i, mapping));
                ++i;
            }
        }
        ViewMap<IStreamIgnoredMapping> ignoredView = null;
        if (ignoredPaths != null) {
            ignoredView = new ViewMap<IStreamIgnoredMapping>();
            int i = 0;
            for (String mapping : ignoredPaths) {
                if (mapping == null) {
                    throw new NullPointerError("null ignored path string passed to Stream.newStream");
                }
                ignoredView.addEntry(new StreamIgnoredMapping(i, mapping));
                ++i;
            }
        }
        ArrayList<ClientView.ClientViewMapping> clientView = null;
        if (clientViewPaths != null) {
            clientView = new ArrayList<ClientView.ClientViewMapping>();
            int i = 0;
            for (String mapping : clientViewPaths) {
                if (mapping == null) {
                    throw new NullPointerError("null client view mapping string passed to Stream.newStream");
                }
                clientView.add(new ClientView.ClientViewMapping(i, mapping));
                ++i;
            }
        }
        StreamSummary.Options streamOptions = new StreamSummary.Options();
        if (options != null) {
            streamOptions = new StreamSummary.Options(options);
        }
        if (parentStreamPath == null) {
            parentStreamPath = "none";
        }
        if (name == null && (idx = streamPath.lastIndexOf("/")) != -1 && idx < streamPath.length() - 1) {
            name = streamPath.substring(idx + 1);
        }
        return new Stream(streamPath, IStreamSummary.Type.fromString(type.toUpperCase(Locale.ENGLISH)), parentStreamPath, null, null, name, description == null ? DEFAULT_DESCRIPTION : description, server.getUserName(), streamOptions, streamView, remappedView, ignoredView);
    }

    public Stream() {
    }

    public Stream(String stream, IStreamSummary.Type type, String parent, Date accessed, Date updated, String name, String description, String ownerName, IStreamSummary.IOptions options, ViewMap<IStreamViewMapping> streamView, ViewMap<IStreamRemappedMapping> remappedView, ViewMap<IStreamIgnoredMapping> ignoredView) {
        this(stream, type, parent, accessed, updated, name, description, ownerName, options, streamView, remappedView, ignoredView, null);
    }

    public Stream(String stream, IStreamSummary.Type type, String parent, Date accessed, Date updated, String name, String description, String ownerName, IStreamSummary.IOptions options, ViewMap<IStreamViewMapping> streamView, ViewMap<IStreamRemappedMapping> remappedView, ViewMap<IStreamIgnoredMapping> ignoredView, ViewMap<IClientViewMapping> clientView) {
        this.stream = stream;
        this.type = type;
        this.parent = parent;
        this.accessed = accessed;
        this.updated = updated;
        this.name = name;
        this.ownerName = ownerName;
        this.description = description;
        this.options = options;
        this.streamView = streamView;
        this.remappedView = remappedView;
        this.ignoredView = ignoredView;
        this.clientView = clientView;
    }

    public Stream(Map<String, Object> map, IServer server) {
        super(map, false);
        this.server = server;
        this.streamView = new ViewMap();
        this.remappedView = new ViewMap();
        this.ignoredView = new ViewMap();
        this.clientView = new ViewMap();
        this.extraTags = new ArrayList<IStream.IExtraTag>();
        if (map != null) {
            String path;
            String key = "Paths";
            int i = 0;
            while (map.containsKey(key + i)) {
                if (map.get(key + i) != null) {
                    try {
                        IStreamViewMapping.PathType type = null;
                        String path2 = (String)map.get(key + i);
                        int idx = path2.indexOf(" ");
                        if (idx != -1) {
                            type = IStreamViewMapping.PathType.fromString(path2.substring(0, idx));
                            path2 = path2.substring(idx + 1);
                        }
                        String[] matchStrs = MapEntry.parseViewMappingString(path2);
                        this.streamView.getEntryList().add(new StreamViewMapping(i, type, matchStrs[0], matchStrs[1]));
                    }
                    catch (Throwable thr) {
                        Log.error("Unexpected exception in Stream map-based constructor: " + thr.getLocalizedMessage(), new Object[0]);
                        Log.exception(thr);
                    }
                }
                ++i;
            }
            key = "Remapped";
            i = 0;
            while (map.containsKey(key + i)) {
                if (map.get(key + i) != null) {
                    try {
                        path = (String)map.get(key + i);
                        String[] matchStrs = MapEntry.parseViewMappingString(path);
                        this.remappedView.getEntryList().add(new StreamRemappedMapping(i, matchStrs[0], matchStrs[1]));
                    }
                    catch (Throwable thr) {
                        Log.error("Unexpected exception in Stream map-based constructor: " + thr.getLocalizedMessage(), new Object[0]);
                        Log.exception(thr);
                    }
                }
                ++i;
            }
            key = "Ignored";
            i = 0;
            while (map.containsKey(key + i)) {
                if (map.get(key + i) != null) {
                    try {
                        path = (String)map.get(key + i);
                        this.ignoredView.getEntryList().add(new StreamIgnoredMapping(i, path));
                    }
                    catch (Throwable thr) {
                        Log.error("Unexpected exception in Stream map-based constructor: " + thr.getLocalizedMessage(), new Object[0]);
                        Log.exception(thr);
                    }
                }
                ++i;
            }
            key = "View";
            i = 0;
            while (map.containsKey(key + i)) {
                if (map.get(key + i) != null) {
                    try {
                        path = (String)map.get(key + i);
                        this.clientView.getEntryList().add(new ClientView.ClientViewMapping(i, path));
                    }
                    catch (Throwable thr) {
                        Log.error("Unexpected exception in Stream map-based constructor: " + thr.getLocalizedMessage(), new Object[0]);
                        Log.exception(thr);
                    }
                }
                ++i;
            }
            key = "extraTag";
            i = 0;
            while (map.containsKey(key + i)) {
                if (map.get(key + i) != null) {
                    try {
                        String tagName = (String)map.get(key + i);
                        String tagType = (String)map.get("extraTagType" + i);
                        String tagValue = (String)map.get(tagName);
                        this.extraTags.add(new ExtraTag(tagName, tagType, tagValue));
                    }
                    catch (Throwable thr) {
                        Log.error("Unexpected exception in Stream map-based constructor: " + thr.getLocalizedMessage(), new Object[0]);
                        Log.exception(thr);
                    }
                }
                ++i;
            }
        }
    }

    public Stream(IStreamSummary summary) throws ConnectionException, RequestException, AccessException {
        super(false);
        this.streamView = new ViewMap();
        if (summary != null) {
            this.setName(summary.getName());
            if (this.getName() != null) {
                this.refresh();
            }
        }
    }

    private void updateFlags() {
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IOptionsServer refreshServer = (IOptionsServer)this.server;
        String refreshStreamPath = this.stream;
        if (refreshServer != null && refreshStreamPath != null) {
            try {
                IStream refreshedStream = refreshServer.getStream(refreshStreamPath);
                if (refreshedStream != null) {
                    this.stream = refreshedStream.getStream();
                    this.type = refreshedStream.getType();
                    this.parent = refreshedStream.getParent();
                    this.accessed = refreshedStream.getAccessed();
                    this.updated = refreshedStream.getUpdated();
                    this.ownerName = refreshedStream.getOwnerName();
                    this.name = refreshedStream.getName();
                    this.description = refreshedStream.getDescription();
                    this.options = refreshedStream.getOptions();
                    this.streamView = refreshedStream.getStreamView();
                    this.remappedView = refreshedStream.getRemappedView();
                    this.ignoredView = refreshedStream.getIgnoredView();
                    this.extraTags = refreshedStream.getExtraTags();
                }
            }
            catch (P4JavaException exc) {
                throw new RequestException(exc.getMessage(), exc);
            }
        }
        this.updateFlags();
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        try {
            ((IOptionsServer)this.server).updateStream(this, null);
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public void update(boolean force) throws ConnectionException, RequestException, AccessException {
        try {
            ((IOptionsServer)this.server).updateStream(this, new StreamOptions().setForceUpdate(force));
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public ViewMap<IStreamViewMapping> getStreamView() {
        return this.streamView;
    }

    @Override
    public void setStreamView(ViewMap<IStreamViewMapping> streamView) {
        this.streamView = streamView;
    }

    @Override
    public void setServer(IOptionsServer server) {
        this.server = server;
    }

    @Override
    public ViewMap<IStreamRemappedMapping> getRemappedView() {
        return this.remappedView;
    }

    @Override
    public void setRemappedView(ViewMap<IStreamRemappedMapping> remappedView) {
        this.remappedView = remappedView;
    }

    @Override
    public ViewMap<IStreamIgnoredMapping> getIgnoredView() {
        return this.ignoredView;
    }

    @Override
    public void setIgnoredView(ViewMap<IStreamIgnoredMapping> ignoredView) {
        this.ignoredView = ignoredView;
    }

    @Override
    public ViewMap<IClientViewMapping> getClientView() {
        return this.clientView;
    }

    @Override
    public void setClientView(ViewMap<IClientViewMapping> clientView) {
        this.clientView = clientView;
    }

    @Override
    public List<IStream.IExtraTag> getExtraTags() {
        return this.extraTags;
    }

    @Override
    public void setExtraTags(List<IStream.IExtraTag> extraTags) {
        this.extraTags = extraTags;
    }

    public static class StreamIgnoredMapping
    extends MapEntry
    implements IStreamIgnoredMapping {
        protected IStreamViewMapping.PathType pathType = IStreamViewMapping.PathType.SHARE;

        public StreamIgnoredMapping() {
        }

        public StreamIgnoredMapping(int order, String ignorePath) {
            super(order, ignorePath, null);
        }

        @Override
        public String getIgnorePath() {
            return this.left;
        }

        @Override
        public void setIgnorePath(String ignorePath) {
            this.left = ignorePath;
        }
    }

    public static class StreamRemappedMapping
    extends MapEntry
    implements IStreamRemappedMapping {
        public StreamRemappedMapping() {
        }

        public StreamRemappedMapping(int order, String leftRemapPath, String rightRemapPath) {
            super(order, leftRemapPath, rightRemapPath);
        }

        public StreamRemappedMapping(int order, String viewString) {
            super(order, viewString);
        }

        @Override
        public String getLeftRemapPath() {
            return this.left;
        }

        @Override
        public void setLeftRemapPath(String leftRemapPath) {
            this.left = leftRemapPath;
        }

        @Override
        public String getRightRemapPath() {
            return this.right;
        }

        @Override
        public void setRightRemapPath(String rightRemapPath) {
            this.right = rightRemapPath;
        }
    }

    public static class StreamViewMapping
    extends MapEntry
    implements IStreamViewMapping {
        protected IStreamViewMapping.PathType pathType = null;

        public StreamViewMapping() {
        }

        public StreamViewMapping(int order, IStreamViewMapping.PathType pathType, String viewPath, String depotPath) {
            super(order, viewPath, depotPath);
            if (pathType == null) {
                throw new NullPointerError("null stream view path type passed to Stream.StreamViewMapping constructor.");
            }
            this.pathType = pathType;
        }

        public StreamViewMapping(int order, String viewString) {
            this.order = order;
            if (viewString != null) {
                int idx = viewString.indexOf(" ");
                if (idx != -1) {
                    this.pathType = IStreamViewMapping.PathType.fromString(viewString.substring(0, idx));
                    viewString = viewString.substring(idx + 1);
                }
                String[] entries = StreamViewMapping.parseViewMappingString(viewString);
                this.type = IMapEntry.EntryType.fromString(entries[0]);
                this.left = StreamViewMapping.stripTypePrefix(entries[0]);
                this.right = entries[1];
            }
        }

        @Override
        public IStreamViewMapping.PathType getPathType() {
            return this.pathType;
        }

        @Override
        public void setPathType(IStreamViewMapping.PathType pathType) {
            this.pathType = pathType;
        }

        @Override
        public String getViewPath() {
            return this.left;
        }

        @Override
        public void setViewPath(String viewPath) {
            this.left = viewPath;
        }

        @Override
        public String getDepotPath() {
            return this.right;
        }

        @Override
        public void setDepotPath(String depotPath) {
            this.right = depotPath;
        }
    }

    public static class ExtraTag
    implements IStream.IExtraTag {
        private String name = null;
        private String type = null;
        private String value = null;

        public ExtraTag() {
        }

        public ExtraTag(String name, String type, String value) {
            if (name == null) {
                throw new NullPointerError("null name in Stream.ExtraTag constructor.");
            }
            if (type == null) {
                throw new NullPointerError("null type in Stream.ExtraTag constructor.");
            }
            if (value == null) {
                throw new NullPointerError("null value in Stream.ExtraTag constructor.");
            }
            this.name = name;
            this.type = type;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }
}

