/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.callback.IProgressCallback;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ClientProgressReport {
    public static final String TRACE_PREFIX = "ClientProgressReport";
    private static final String DATE_PATTERN = "yyyy/MM/dd HH:mm:ss";
    private static final String DATE_PATTERN2 = "yyyy/MM/dd";
    private static final Map<String, CmdSpec> cmdMap = new HashMap<String, CmdSpec>();
    protected RpcServer server = null;

    public ClientProgressReport(RpcServer server) {
        this.server = server;
    }

    public boolean report(IProgressCallback progressCallback, int cmdCallBackKey, RpcFunctionSpec funcSpec, CommandEnv cmdEnv, Map<String, Object> resultsMap) {
        if (resultsMap != null) {
            CmdSpec cmdSpec = cmdMap.get(cmdEnv.getCmdSpec().getCmdName());
            String tickMarker = this.getTickMarker(cmdSpec, resultsMap);
            switch (funcSpec) {
                case CLIENT_FSTATINFO: {
                    if (cmdSpec == null || !cmdMap.containsKey(cmdSpec.toString())) break;
                    return progressCallback.tick(cmdCallBackKey, tickMarker);
                }
                case CLIENT_OPENFILE: 
                case CLIENT_SENDFILE: 
                case CLIENT_OUTPUTBINARY: 
                case CLIENT_OUTPUTTEXT: {
                    return progressCallback.tick(cmdCallBackKey, tickMarker);
                }
                case CLIENT_MESSAGE: {
                    tickMarker = this.server.getErrorOrInfoStr(resultsMap);
                    return progressCallback.tick(cmdCallBackKey, tickMarker);
                }
            }
        }
        return true;
    }

    private String getTickMarker(CmdSpec cmdSpec, Map<String, Object> resultsMap) {
        String tickMarker = null;
        if (cmdSpec != null) {
            StringBuilder sb = null;
            switch (cmdSpec) {
                case FSTAT: {
                    String[] fstatFields = new String[]{"depotFile", "clientFile", "isMapped", "headAction", "headType", "headTime", "headRev", "headChange", "headModTime", "haveRev"};
                    sb = new StringBuilder();
                    for (String f : fstatFields) {
                        if (resultsMap.get(f) == null) continue;
                        if (sb.length() > 0) {
                            sb.append(CommandEnv.LINE_SEPARATOR);
                        }
                        sb.append("... ").append(f).append(" ").append((String)resultsMap.get(f));
                    }
                    break;
                }
                case FILES: {
                    sb = new StringBuilder();
                    if (resultsMap.get("depotFile") != null) {
                        sb.append((String)resultsMap.get("depotFile"));
                    }
                    if (resultsMap.get("rev") != null) {
                        sb.append("#").append((String)resultsMap.get("rev"));
                    }
                    if (resultsMap.get("action") != null) {
                        sb.append(" - ").append((String)resultsMap.get("action"));
                    }
                    if (resultsMap.get("change") != null) {
                        sb.append(" change ").append((String)resultsMap.get("change"));
                    }
                    if (resultsMap.get("type") == null) break;
                    sb.append(" (").append((String)resultsMap.get("type")).append(")");
                    break;
                }
                case SYNC: {
                    sb = new StringBuilder();
                    if (resultsMap.get("totalFileSize") != null) {
                        sb.append("... ").append("totalFileSize ").append((String)resultsMap.get("totalFileSize"));
                    }
                    if (resultsMap.get("totalFileCount") != null) {
                        if (sb.length() > 0) {
                            sb.append(CommandEnv.LINE_SEPARATOR);
                        }
                        sb.append("... ").append("totalFileCount ").append((String)resultsMap.get("totalFileCount"));
                    }
                    if (sb.length() > 0) {
                        sb.append(CommandEnv.LINE_SEPARATOR);
                    }
                    if (resultsMap.get("depotFile") != null) {
                        sb.append((String)resultsMap.get("depotFile"));
                    }
                    if (resultsMap.get("rev") != null) {
                        sb.append("#").append((String)resultsMap.get("rev"));
                    }
                    if (resultsMap.get("action") != null) {
                        sb.append(" - ").append((String)resultsMap.get("action"));
                    }
                    if (resultsMap.get("clientFile") == null) break;
                    sb.append(" as ").append((String)resultsMap.get("clientFile"));
                    break;
                }
                case JOBS: {
                    sb = new StringBuilder();
                    if (resultsMap.get("Job") != null) {
                        sb.append((String)resultsMap.get("Job"));
                    }
                    if (resultsMap.get("Date") != null) {
                        try {
                            Date date = this.parseDate((String)resultsMap.get("Date"), DATE_PATTERN);
                            String dateStr = this.formatDate(date, DATE_PATTERN2);
                            sb.append(" on ").append(dateStr);
                        }
                        catch (ParseException date) {
                            // empty catch block
                        }
                    }
                    if (resultsMap.get("User") != null) {
                        sb.append(" by ").append((String)resultsMap.get("User"));
                    }
                    if (resultsMap.get("Status") != null) {
                        sb.append(" *").append((String)resultsMap.get("Status")).append("*");
                    }
                    if (resultsMap.get("Description") == null) break;
                    sb.append(" '").append((String)resultsMap.get("Description")).append("'");
                    break;
                }
                case CHANGES: {
                    sb = new StringBuilder();
                    if (resultsMap.get("change") != null) {
                        sb.append("Change ").append((String)resultsMap.get("change"));
                    }
                    if (resultsMap.get("time") != null) {
                        Date date = new Date(Long.parseLong((String)resultsMap.get("time")) * 1000L);
                        String dateStr = this.formatDate(date, DATE_PATTERN2);
                        sb.append(" on ").append(dateStr);
                    }
                    if (resultsMap.get("user") != null) {
                        sb.append(" by ").append((String)resultsMap.get("user"));
                    }
                    if (resultsMap.get("client") != null) {
                        sb.append("@").append((String)resultsMap.get("client"));
                    }
                    if (resultsMap.get("status") != null && !((String)resultsMap.get("status")).equalsIgnoreCase("submitted")) {
                        sb.append(" *").append((String)resultsMap.get("status")).append("*");
                    }
                    if (resultsMap.get("desc") == null) break;
                    sb.append(" '").append((String)resultsMap.get("desc")).append("'");
                    break;
                }
                case USERS: {
                    sb = new StringBuilder();
                    if (resultsMap.get("User") != null) {
                        sb.append((String)resultsMap.get("User"));
                    }
                    if (resultsMap.get("Email") != null) {
                        sb.append(" <").append((String)resultsMap.get("Email")).append(">");
                    }
                    if (resultsMap.get("FullName") != null) {
                        sb.append(" (").append((String)resultsMap.get("FullName")).append(")");
                    }
                    if (resultsMap.get("Access") == null) break;
                    Date date = new Date(Long.parseLong((String)resultsMap.get("Access")) * 1000L);
                    String dateStr = this.formatDate(date, DATE_PATTERN2);
                    sb.append(" accessed ").append(dateStr);
                    break;
                }
            }
            if (sb != null && sb.length() > 0) {
                tickMarker = sb.toString();
            }
        }
        return tickMarker;
    }

    private Date parseDate(String date, String pattern) throws ParseException {
        Date d = null;
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            d = df.parse(date);
        }
        return d;
    }

    private String formatDate(Date date, String pattern) {
        String d = null;
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            d = df.format(date);
        }
        return d;
    }

    static {
        cmdMap.put(CmdSpec.FSTAT.toString(), CmdSpec.FSTAT);
        cmdMap.put(CmdSpec.FILES.toString(), CmdSpec.FILES);
        cmdMap.put(CmdSpec.SYNC.toString(), CmdSpec.SYNC);
        cmdMap.put(CmdSpec.JOBS.toString(), CmdSpec.JOBS);
        cmdMap.put(CmdSpec.CHANGES.toString(), CmdSpec.CHANGES);
        cmdMap.put(CmdSpec.USERS.toString(), CmdSpec.USERS);
    }
}

