/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.admin.IDiskSpace;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.admin.DiskSpace;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IDiskspaceDelegator;
import java.util.List;
import java.util.Map;

public class DiskspaceDelegator
extends BaseDelegator
implements IDiskspaceDelegator {
    public DiskspaceDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IDiskSpace> getDiskSpace(List<String> filesystems) throws P4JavaException {
        String[] cmdArgs = null;
        if (ObjectUtils.nonNull(filesystems)) {
            cmdArgs = filesystems.toArray(new String[filesystems.size()]);
        }
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.DISKSPACE, cmdArgs, null);
        return ResultListBuilder.buildNonNullObjectListFromCommandResultMaps(resultMaps, new Function<Map, IDiskSpace>(){

            @Override
            public IDiskSpace apply(Map map) {
                return new DiskSpace(map);
            }
        });
    }
}

