/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientHelper;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcInputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SymbolicLinkHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ClientSendFile {
    public static final String TRACE_PREFIX = "ClientSendFile";
    private Properties props = null;
    private final ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();
    private String filePath = null;
    private long fileSize = 0L;
    private long currentSize = 0L;

    protected ClientSendFile(Properties props) {
        this.props = props;
    }

    private long sendStream(InputStream stream, RpcConnection connection, String handle, String write, MD5Digester digester, CommandEnv cmdEnv) throws ConnectionException, IOException {
        int bytesRead;
        long fileLength = 0L;
        HashMap<String, Object> sendMap = new HashMap<String, Object>();
        byte[] bytes = new byte[1024];
        while ((bytesRead = stream.read(bytes)) > 0) {
            byte[] readBytes = new byte[bytesRead];
            System.arraycopy(bytes, 0, readBytes, 0, bytesRead);
            fileLength += (long)bytesRead;
            sendMap.clear();
            sendMap.put("data", readBytes);
            sendMap.put("handle", handle);
            RpcPacket sendPacket = RpcPacket.constructRpcPacket(write, sendMap, null);
            connection.putRpcPacket(sendPacket);
            digester.update(readBytes);
            this.currentSize = ClientHelper.sendBackWrittenDataBytes(cmdEnv, this.filePath, this.fileSize, this.currentSize, bytesRead);
        }
        return fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult sendFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) {
        cmdEnv.newHandler();
        String clientPath = (String)resultsMap.get("path");
        String type = (String)resultsMap.get("type");
        String perms = (String)resultsMap.get("perms");
        String handle = (String)resultsMap.get("handle");
        String open = (String)resultsMap.get("open");
        String write = (String)resultsMap.get("write");
        String confirm = (String)resultsMap.get("confirm");
        String decline = (String)resultsMap.get("decline");
        String serverDigest = (String)resultsMap.get("serverDigest");
        String revertUnchanged = (String)resultsMap.get("revertUnchanged");
        String reopen = (String)resultsMap.get("reopen");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(handle);
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = new CommandEnv.RpcHandler(commandEnv, handle, false, null);
            cmdEnv.addHandler(handler);
        }
        RpcPerforceFile file = null;
        InputStream inStream = null;
        MD5Digester digester = null;
        long fileLength = 0L;
        long modTime = 0L;
        try {
            try {
                file = new RpcPerforceFile(clientPath, type);
                modTime = file.lastModified();
                if (file.getFileType() == RpcPerforceFileType.FST_SYMLINK && (modTime = SymbolicLinkHelper.getLastModifiedTime(clientPath)) == 0L) {
                    modTime = System.currentTimeMillis();
                }
                this.filePath = clientPath != null && !clientPath.isEmpty() ? clientPath : null;
                this.fileSize = file.length();
                this.currentSize = 0L;
                if (!handler.isError()) {
                    HashMap<String, Object> respMap = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                        String string = entry.getKey();
                        if (string == null || "func".equalsIgnoreCase(string)) continue;
                        respMap.put(entry.getKey(), entry.getValue());
                    }
                    RpcPacket respPacket = RpcPacket.constructRpcPacket(open, respMap, null);
                    rpcConnection.putRpcPacket(respPacket);
                    if (!file.exists() && file.getFileType() != RpcPerforceFileType.FST_SYMLINK) {
                        handler.setError(true);
                        cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.OS_FILE_READ_ERROR, 1, 34, new String[]{"open for read", clientPath + ": No such file or directory"}).toMap());
                    } else {
                        void var26_31;
                        Object symbolicLinkTarget = null;
                        if (file.getFileType() == RpcPerforceFileType.FST_SYMLINK) {
                            if (SymbolicLinkHelper.isSymbolicLinkCapable() && (symbolicLinkTarget = SymbolicLinkHelper.readSymbolicLink(clientPath)) != null) {
                                symbolicLinkTarget = (String)symbolicLinkTarget + "\n";
                            }
                            if (symbolicLinkTarget == null) {
                                handler.setError(true);
                                cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_SEND_ERROR, 3, 34, new String[]{"symlink", clientPath}).toMap());
                                RpcPacketDispatcher.RpcPacketDispatcherResult rpcPacketDispatcherResult = RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                                return rpcPacketDispatcherResult;
                            }
                        }
                        digester = new MD5Digester();
                        Object var26_27 = null;
                        if (RpcPerforceFileType.FST_UTF16 == file.getFileType() || RpcPerforceFileType.FST_XUTF16 == file.getFileType()) {
                            Charset charset = CharsetDefs.UTF16;
                        } else if (RpcPerforceFileType.FST_UTF8 == file.getFileType() || RpcPerforceFileType.FST_XUTF8 == file.getFileType()) {
                            Charset charset = CharsetDefs.UTF8;
                        } else if (RpcPerforceFileType.FST_UNICODE == file.getFileType() || RpcPerforceFileType.FST_XUNICODE == file.getFileType()) {
                            Charset charset = rpcConnection.getClientCharset();
                        }
                        inStream = !rpcConnection.isUnicodeServer() && var26_31 != CharsetDefs.UTF16 || var26_31 == null || var26_31.equals(CharsetDefs.UTF8) ? (symbolicLinkTarget == null ? new RpcInputStream(file, null) : new ByteArrayInputStream(((String)symbolicLinkTarget).getBytes())) : (symbolicLinkTarget == null ? new RpcInputStream(file, (Charset)var26_31) : new ByteArrayInputStream(((String)symbolicLinkTarget).getBytes()));
                        fileLength = this.sendStream(inStream, rpcConnection, handle, write, digester, cmdEnv);
                        if (!handler.isError() && ObjectUtils.nonNull(perms) && ObjectUtils.isNull(reopen)) {
                            boolean writable = perms.equalsIgnoreCase("rw");
                            this.fileCommands.setWritable(clientPath, writable);
                        }
                    }
                }
                String finalise = handler.isError() ? decline : confirm;
                HashMap<String, Object> finaliseMap = new HashMap<String, Object>();
                for (Map.Entry<String, Object> entry : resultsMap.entrySet()) {
                    String key = entry.getKey();
                    if (!ObjectUtils.nonNull(key) || "func".equalsIgnoreCase(key)) continue;
                    finaliseMap.put(entry.getKey(), entry.getValue());
                }
                if (digester != null) {
                    finaliseMap.put("digest", digester.digestAs32ByteHex());
                    finaliseMap.put("fileSize", String.valueOf(fileLength));
                    if (modTime != 0L) {
                        finaliseMap.put("time", String.valueOf(modTime / 1000L));
                    }
                }
                RpcPacket finalisePacket = RpcPacket.constructRpcPacket(finalise, finaliseMap, null);
                rpcConnection.putRpcPacket(finalisePacket);
                handler.setError(false);
                this.filePath = null;
                this.fileSize = 0L;
                this.currentSize = 0L;
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            finally {
                if (ObjectUtils.nonNull(inStream)) {
                    inStream.close();
                }
            }
        }
        catch (Exception exc) {
            Log.exception(exc);
            handler.setError(true);
            cmdEnv.handleResult(new RpcMessage(ClientMessage.ClientMessageId.FILE_SEND_ERROR, 3, 34, new String[]{clientPath, exc.getLocalizedMessage()}).toMap());
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }
}

