/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.ObjectUtils;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.option.server.GetSubmittedIntegrationsOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.delegator.IIntegratedDelegator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IntegratedDelegator
extends BaseDelegator
implements IIntegratedDelegator {
    public IntegratedDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, String branchSpec, boolean reverseMappings) throws ConnectionException, RequestException, AccessException {
        try {
            GetSubmittedIntegrationsOptions submittedIntegrationsOptions = new GetSubmittedIntegrationsOptions(branchSpec, reverseMappings);
            return this.getSubmittedIntegrations(fileSpecs, submittedIntegrationsOptions);
        }
        catch (AccessException | ConnectionException | RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileSpec> getSubmittedIntegrations(List<IFileSpec> fileSpecs, GetSubmittedIntegrationsOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.INTEGRATED, Parameters.processParameters(opts, fileSpecs, this.server), null);
        ArrayList<IFileSpec> integratedList = new ArrayList<IFileSpec>();
        if (ObjectUtils.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                integratedList.add(ResultListBuilder.handleIntegrationFileReturn(map, false, this.server));
            }
        }
        return integratedList;
    }
}

