/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.common.quantity;

import com.perforce.p4java.common.function.Function;
import java.util.Objects;
import javax.annotation.Nullable;

public class Pair<A, B> {
    @Nullable
    private final A first;
    @Nullable
    private final B second;

    public Pair(@Nullable A first, @Nullable B second) {
        this.first = first;
        this.second = second;
    }

    @Nullable
    public A getFirst() {
        return this.first;
    }

    @Nullable
    public B getSecond() {
        return this.second;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair that = (Pair)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public String toString() {
        return String.format("(%s, %s)", this.getFirst(), this.getSecond());
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public static <S, T> Function<Pair<S, T>, S> first() {
        return new Function<Pair<S, T>, S>(){

            @Override
            public S apply(Pair<S, T> pair) {
                return pair.first;
            }
        };
    }

    public static <S, T> Function<Pair<S, T>, T> second() {
        return new Function<Pair<S, T>, T>(){

            @Override
            public T apply(Pair<S, T> pair) {
                return pair.second;
            }
        };
    }

    public static <A, B> Pair<A, B> of(@Nullable A a, @Nullable B b) {
        return new Pair<A, B>(a, b);
    }
}

