/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.server.AbstractAuthHelper;
import com.perforce.p4java.server.AuthTicket;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthTicketsHelper
extends AbstractAuthHelper {
    private static final AuthTicket[] EMPTY = new AuthTicket[0];
    private static Map<String, String> ticketsMap = Collections.synchronizedMap(new HashMap());

    public static String getTicketValue(String userName, String serverAddress, String ticketsFilePath) throws IOException {
        String ticketValue = null;
        AuthTicket ticket = AuthTicketsHelper.getTicket(userName, serverAddress, ticketsFilePath);
        if (ticket != null) {
            ticketValue = ticket.getTicketValue();
        }
        return ticketValue;
    }

    public static AuthTicket[] getTickets(String ticketsFilePath) throws IOException {
        File file = ticketsFilePath != null ? new File(ticketsFilePath) : null;
        AuthTicket[] tickets = AuthTicketsHelper.getTickets(file);
        return tickets;
    }

    public static synchronized AuthTicket[] getTickets(File ticketsFile) throws IOException {
        List<Map<String, String>> authList;
        AuthTicket[] tickets = EMPTY;
        List<Map<String, String>> list = authList = ticketsFile != null ? AuthTicketsHelper.getFileEntries(ticketsFile) : AuthTicketsHelper.getMemoryEntries(ticketsMap);
        if (authList != null) {
            ArrayList<AuthTicket> ticketList = new ArrayList<AuthTicket>();
            for (Map<String, String> map : authList) {
                if (map == null) continue;
                String serverAddress = map.get("serverAddress");
                String userName = map.get("userName");
                String ticketValue = map.get("authValue");
                AuthTicket ticket = new AuthTicket(serverAddress, userName, ticketValue);
                ticketList.add(ticket);
            }
            tickets = ticketList.toArray(new AuthTicket[0]);
        }
        return tickets;
    }

    public static AuthTicket getTicket(String userName, String serverAddress, String ticketsFilePath) throws IOException {
        AuthTicket foundTicket = null;
        if (serverAddress != null) {
            if (serverAddress.indexOf(58) == -1) {
                serverAddress = "localhost:" + serverAddress;
            }
            for (AuthTicket ticket : AuthTicketsHelper.getTickets(ticketsFilePath)) {
                if (!serverAddress.equals(ticket.getServerAddress()) || userName != null && !userName.equals(ticket.getUserName())) continue;
                foundTicket = ticket;
                break;
            }
        }
        return foundTicket;
    }

    public static AuthTicket getTicket(String serverAddress, String ticketsFilePath) throws IOException {
        return AuthTicketsHelper.getTicket(null, serverAddress, ticketsFilePath);
    }

    public static void saveTicket(AuthTicket ticket, String ticketsFilePath) throws IOException {
        File file = ticketsFilePath != null ? new File(ticketsFilePath) : null;
        AuthTicketsHelper.saveTicket(ticket, file);
    }

    public static void saveTicket(AuthTicket ticket, File ticketsFile) throws IOException {
        if (ticket != null) {
            AuthTicketsHelper.saveTicket(ticket.getUserName(), ticket.getServerAddress(), ticket.getTicketValue(), ticketsFile);
        }
    }

    public static void saveTicket(String userName, String serverAddress, String ticketValue, String ticketsFilePath) throws IOException {
        File file = ticketsFilePath != null ? new File(ticketsFilePath) : null;
        AuthTicketsHelper.saveTicket(userName, serverAddress, ticketValue, file);
    }

    public static void saveTicket(String userName, String serverAddress, String ticketValue, String ticketsFilePath, int lockTry, long lockDelay, long lockWait) throws IOException {
        File file = ticketsFilePath != null ? new File(ticketsFilePath) : null;
        AuthTicketsHelper.saveTicket(userName, serverAddress, ticketValue, file, lockTry, lockDelay, lockWait);
    }

    public static synchronized void saveTicket(String userName, String serverAddress, String ticketValue, File ticketsFile) throws IOException {
        AuthTicketsHelper.saveTicket(userName, serverAddress, ticketValue, ticketsFile, 0, 0L, 0L);
    }

    public static synchronized void saveTicket(String userName, String serverAddress, String ticketValue, File ticketsFile, int lockTry, long lockDelay, long lockWait) throws IOException {
        if (ticketsFile != null) {
            AuthTicketsHelper.saveFileEntry(userName, serverAddress, ticketValue, ticketsFile, lockTry, lockDelay, lockWait);
        } else {
            AuthTicketsHelper.saveMemoryEntry(userName, serverAddress, ticketValue, ticketsMap);
        }
    }
}

