/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.io.apple;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.FileDecoderException;
import com.perforce.p4java.io.apple.AppleFileData;

public abstract class AppleFile {
    protected FileFormat format = FileFormat.UNKNOWN;
    protected AppleFileData fileData = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData dataFork = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData resourceFork = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData realName = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData comment = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData iconBW = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData iconColor = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData fileDatesInfo = AppleFileData.EMPTY_FILE_DATA;
    protected FileDatesInfoEntry fileDatesInfoEntry = null;
    protected AppleFileData finderInfo = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData macintoshInfo = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData proDOSFileInfo = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData msDOSFileInfo = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData shortName = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData afpFileInfo = AppleFileData.EMPTY_FILE_DATA;
    protected AppleFileData directoryID = AppleFileData.EMPTY_FILE_DATA;
    protected int numEntries = 0;

    public void setNumEntries(int numEntries) {
        this.numEntries = numEntries;
    }

    protected void verify() throws FileDecoderException {
        byte[] data = this.fileData.getData();
        int offset = this.fileData.getOffset();
        int length = this.fileData.getLength();
        int position = offset;
        if (length < 26) {
            throw new FileDecoderException("File is too short");
        }
        int magic = 0;
        magic |= data[position++] & 0xFF;
        magic <<= 8;
        magic |= data[position++] & 0xFF;
        magic <<= 8;
        magic |= data[position++] & 0xFF;
        magic <<= 8;
        if ((magic |= data[position++] & 0xFF) == 333312) {
            this.format = FileFormat.APPLE_SINGLE;
        } else if (magic == 333319) {
            this.format = FileFormat.APPLE_DOUBLE;
        } else {
            throw new FileDecoderException("Invalid Apple file magic number.");
        }
        int version = 0;
        version |= data[position++] & 0xFF;
        version <<= 8;
        version |= data[position++] & 0xFF;
        version <<= 8;
        version |= data[position++] & 0xFF;
        version <<= 8;
        if ((version |= data[position++] & 0xFF) != 131072) {
            throw new FileDecoderException("Unknown Apple file version");
        }
        position += 16;
        this.numEntries = 0;
        this.numEntries |= data[position++] & 0xFF;
        this.numEntries <<= 8;
        this.numEntries |= data[position++] & 0xFF;
        if (length < 26 + 12 * this.numEntries) {
            throw new FileDecoderException("Corrupt Apple file data.");
        }
        int entryId = 0;
        int entryOffset = 0;
        int entryLength = 0;
        int contentPosition = 26 + 12 * this.numEntries;
        for (int i = 0; i < this.numEntries; ++i) {
            position = 26 + i * 12;
            entryId = 0;
            entryId |= data[position++] & 0xFF;
            entryId <<= 8;
            entryId |= data[position++] & 0xFF;
            entryId <<= 8;
            entryId |= data[position++] & 0xFF;
            entryId <<= 8;
            entryId |= data[position++] & 0xFF;
            entryOffset = 0;
            entryOffset |= data[position++] & 0xFF;
            entryOffset <<= 8;
            entryOffset |= data[position++] & 0xFF;
            entryOffset <<= 8;
            entryOffset |= data[position++] & 0xFF;
            entryOffset <<= 8;
            entryOffset |= data[position++] & 0xFF;
            entryOffset &= Integer.MAX_VALUE;
            entryLength = 0;
            entryLength |= data[position++] & 0xFF;
            entryLength <<= 8;
            entryLength |= data[position++] & 0xFF;
            entryLength <<= 8;
            entryLength |= data[position++] & 0xFF;
            entryLength <<= 8;
            entryLength |= data[position++] & 0xFF;
            if (entryOffset >= contentPosition && length >= entryOffset + (entryLength &= Integer.MAX_VALUE)) continue;
            throw new FileDecoderException("Corrupt Apple file data.");
        }
    }

    protected void extractFileDates(byte[] data, int offset, int length) {
        if (0 > offset || offset > data.length) {
            throw new IndexOutOfBoundsException();
        }
        if (0 > length || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        int position = offset;
        int createTime = 0;
        createTime |= data[position++] & 0xFF;
        createTime <<= 8;
        createTime |= data[position++] & 0xFF;
        createTime <<= 8;
        createTime |= data[position++] & 0xFF;
        createTime <<= 8;
        createTime |= data[position++] & 0xFF;
        int modifyTime = 0;
        modifyTime |= data[position++] & 0xFF;
        modifyTime <<= 8;
        modifyTime |= data[position++] & 0xFF;
        modifyTime <<= 8;
        modifyTime |= data[position++] & 0xFF;
        modifyTime <<= 8;
        modifyTime |= data[position++] & 0xFF;
        int backupTime = 0;
        backupTime |= data[position++] & 0xFF;
        backupTime <<= 8;
        backupTime |= data[position++] & 0xFF;
        backupTime <<= 8;
        backupTime |= data[position++] & 0xFF;
        backupTime <<= 8;
        backupTime |= data[position++] & 0xFF;
        int accessTime = 0;
        accessTime |= data[position++] & 0xFF;
        accessTime <<= 8;
        accessTime |= data[position++] & 0xFF;
        accessTime <<= 8;
        accessTime |= data[position++] & 0xFF;
        accessTime <<= 8;
        int n = position++;
        this.fileDatesInfoEntry = new FileDatesInfoEntry();
        this.fileDatesInfoEntry.setCreateTime(createTime);
        this.fileDatesInfoEntry.setModifyTime(modifyTime);
        this.fileDatesInfoEntry.setBackupTime(backupTime);
        this.fileDatesInfoEntry.setAccessTime(accessTime |= data[n] & 0xFF);
    }

    public FileFormat getFormat() {
        return this.format;
    }

    public void setFormat(FileFormat format) {
        this.format = format;
    }

    public AppleFileData getFileData() {
        return this.fileData;
    }

    public void setFileData(AppleFileData fileData) {
        this.fileData = fileData;
    }

    public AppleFileData getDataFork() {
        return this.dataFork;
    }

    public void setDataFork(AppleFileData dataFork) {
        this.dataFork = dataFork;
    }

    public AppleFileData getResourceFork() {
        return this.resourceFork;
    }

    public void setResourceFork(AppleFileData resourceFork) {
        this.resourceFork = resourceFork;
    }

    public AppleFileData getRealName() {
        return this.realName;
    }

    public void setRealName(AppleFileData realName) {
        this.realName = realName;
    }

    public AppleFileData getComment() {
        return this.comment;
    }

    public void setComment(AppleFileData comment) {
        this.comment = comment;
    }

    public AppleFileData getIconBW() {
        return this.iconBW;
    }

    public void setIconBW(AppleFileData iconBW) {
        this.iconBW = iconBW;
    }

    public AppleFileData getIconColor() {
        return this.iconColor;
    }

    public void setIconColor(AppleFileData iconColor) {
        this.iconColor = iconColor;
    }

    public AppleFileData getFileDatesInfo() {
        return this.fileDatesInfo;
    }

    public void setFileDatesInfo(AppleFileData fileDatesInfo) {
        this.fileDatesInfo = fileDatesInfo;
    }

    public AppleFileData getFinderInfo() {
        return this.finderInfo;
    }

    public void setFinderInfo(AppleFileData finderInfo) {
        this.finderInfo = finderInfo;
    }

    public AppleFileData getMacintoshInfo() {
        return this.macintoshInfo;
    }

    public void setMacintoshInfo(AppleFileData macintoshInfo) {
        this.macintoshInfo = macintoshInfo;
    }

    public AppleFileData getProDOSFileInfo() {
        return this.proDOSFileInfo;
    }

    public void setProDOSFileInfo(AppleFileData proDOSFileInfo) {
        this.proDOSFileInfo = proDOSFileInfo;
    }

    public AppleFileData getMsDOSFileInfo() {
        return this.msDOSFileInfo;
    }

    public void setMsDOSFileInfo(AppleFileData msDOSFileInfo) {
        this.msDOSFileInfo = msDOSFileInfo;
    }

    public AppleFileData getShortName() {
        return this.shortName;
    }

    public void setShortName(AppleFileData shortName) {
        this.shortName = shortName;
    }

    public AppleFileData getAfpFileInfo() {
        return this.afpFileInfo;
    }

    public void setAfpFileInfo(AppleFileData afpFileInfo) {
        this.afpFileInfo = afpFileInfo;
    }

    public AppleFileData getDirectoryID() {
        return this.directoryID;
    }

    public void setDirectoryID(AppleFileData directoryID) {
        this.directoryID = directoryID;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public class FileDatesInfoEntry {
        private int createTime = Integer.MIN_VALUE;
        private int modifyTime = Integer.MIN_VALUE;
        private int backupTime = Integer.MIN_VALUE;
        private int accessTime = Integer.MIN_VALUE;

        public int getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(int createTime) {
            this.createTime = createTime;
        }

        public int getModifyTime() {
            return this.modifyTime;
        }

        public void setModifyTime(int modifyTime) {
            this.modifyTime = modifyTime;
        }

        public int getBackupTime() {
            return this.backupTime;
        }

        public void setBackupTime(int backupTime) {
            this.backupTime = backupTime;
        }

        public int getAccessTime() {
            return this.accessTime;
        }

        public void setAccessTime(int accessTime) {
            this.accessTime = accessTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileFormat {
        APPLE_SINGLE,
        APPLE_DOUBLE,
        UNKNOWN;


        public static FileFormat fromString(String fileFormat) {
            if (fileFormat == null) {
                return null;
            }
            try {
                return FileFormat.valueOf(fileFormat.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                Log.error("Bad conversion attempt in FileFormat.fromString; string: " + fileFormat + "; message: " + iae.getMessage());
                Log.exception(iae);
                return UNKNOWN;
            }
        }
    }
}

