/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java;

import com.perforce.p4java.server.callback.ILogCallback;

public class Log {
    private static ILogCallback logCallback = null;

    public static ILogCallback getLogCallback() {
        return logCallback;
    }

    public static ILogCallback setLogCallback(ILogCallback logCallback) {
        ILogCallback oldCallback = Log.logCallback;
        Log.logCallback = logCallback;
        return oldCallback;
    }

    public static void error(String errorString) {
        if (logCallback != null) {
            logCallback.internalError(errorString);
        }
    }

    public static void warn(String warnString) {
        if (logCallback != null) {
            logCallback.internalWarn(warnString);
        }
    }

    public static void info(String infoString) {
        if (logCallback != null) {
            logCallback.internalInfo(infoString);
        }
    }

    public static void stats(String statsString) {
        if (logCallback != null) {
            logCallback.internalStats(statsString);
        }
    }

    public static void exception(Throwable thr) {
        if (logCallback != null && thr != null) {
            logCallback.internalException(thr);
        }
    }

    public static void trace(ILogCallback.LogTraceLevel traceLevel, String traceMessage) {
        if (logCallback != null && traceLevel != null && traceMessage != null && Log.isTracingAtLevel(traceLevel)) {
            logCallback.internalTrace(traceLevel, traceMessage);
        }
    }

    public static boolean isTracingAtLevel(ILogCallback.LogTraceLevel traceLevel) {
        return logCallback != null && logCallback.getTraceLevel() != null && traceLevel.compareTo(logCallback.getTraceLevel()) <= 0;
    }
}

