/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import com.perforce.p4java.Log;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import com.perforce.p4java.server.ServerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthHelper {
    protected static final String SERVER_ADDRESS_MAP_KEY = "serverAddress";
    protected static final String USER_NAME_MAP_KEY = "userName";
    protected static final String AUTH_VALUE_MAP_KEY = "authValue";

    protected static synchronized Map<String, String> getMemoryEntry(String userName, String serverAddress, Map<String, String> authMap) {
        HashMap<String, String> entryMap = null;
        if (userName != null && serverAddress != null && authMap != null) {
            String prefix;
            if (serverAddress.lastIndexOf(58) == -1) {
                serverAddress = serverAddress + "localhost:" + serverAddress;
            }
            if (authMap.containsKey(prefix = serverAddress + "=" + userName)) {
                String authValue = authMap.get(prefix);
                entryMap = new HashMap<String, String>();
                entryMap.put(SERVER_ADDRESS_MAP_KEY, serverAddress);
                entryMap.put(USER_NAME_MAP_KEY, userName);
                entryMap.put(AUTH_VALUE_MAP_KEY, authValue);
            }
        }
        return entryMap;
    }

    protected static synchronized List<Map<String, String>> getMemoryEntries(Map<String, String> authMap) {
        ArrayList<Map<String, String>> authList = new ArrayList<Map<String, String>>();
        if (authMap != null) {
            for (Map.Entry<String, String> entry : authMap.entrySet()) {
                int colon;
                String line = entry.getKey() + ":" + entry.getValue();
                int equals = line.indexOf(61);
                if (equals == -1 || (colon = line.indexOf(58, equals)) == -1 || colon + 1 >= line.length()) continue;
                String serverAddress = line.substring(0, equals);
                String userName = line.substring(equals + 1, colon);
                String authValue = line.substring(colon + 1);
                HashMap<String, String> entryMap = new HashMap<String, String>();
                entryMap.put(SERVER_ADDRESS_MAP_KEY, serverAddress);
                entryMap.put(USER_NAME_MAP_KEY, userName);
                entryMap.put(AUTH_VALUE_MAP_KEY, authValue);
                authList.add(entryMap);
            }
        }
        return authList;
    }

    protected static synchronized void saveMemoryEntry(String userName, String serverAddress, String authValue, Map<String, String> authMap) {
        if (userName != null && serverAddress != null && authMap != null) {
            if (serverAddress.lastIndexOf(58) == -1) {
                serverAddress = serverAddress + "localhost:" + serverAddress;
            }
            String prefix = serverAddress + "=" + userName;
            if (authValue != null) {
                authMap.put(prefix, authValue);
            } else if (authMap.containsKey(prefix)) {
                authMap.remove(prefix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized List<Map<String, String>> getFileEntries(File authFile) throws IOException {
        ArrayList<Map<String, String>> authList = new ArrayList<Map<String, String>>();
        if (authFile != null && authFile.exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(authFile));
            try {
                String line = reader.readLine();
                while (line != null) {
                    int colon;
                    int equals = line.indexOf(61);
                    if (equals != -1 && (colon = line.indexOf(58, equals)) != -1 && colon + 1 < line.length()) {
                        String serverAddress = line.substring(0, equals);
                        String userName = line.substring(equals + 1, colon);
                        String authValue = line.substring(colon + 1);
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(SERVER_ADDRESS_MAP_KEY, serverAddress);
                        map.put(USER_NAME_MAP_KEY, userName);
                        map.put(AUTH_VALUE_MAP_KEY, authValue);
                        authList.add(map);
                    }
                    line = reader.readLine();
                }
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            {
            }
        }
        return authList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void saveFileEntry(String userName, String serverAddress, String authValue, File authFile) throws IOException {
        block26: {
            Object v1;
            boolean renamed;
            File tempAuth;
            block24: {
                if (userName == null || serverAddress == null || authFile == null) break block26;
                if (serverAddress.lastIndexOf(58) == -1) {
                    serverAddress = serverAddress + "localhost:" + serverAddress;
                }
                String prefix = serverAddress + "=" + userName + ":";
                String value = null;
                if (authValue != null) {
                    value = prefix + authValue;
                }
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(authFile));
                }
                catch (FileNotFoundException fnfe) {
                    reader = null;
                }
                tempAuth = File.createTempFile("p4auth", ".txt");
                PrintWriter writer = new PrintWriter(tempAuth, "utf-8");
                renamed = false;
                try {
                    boolean processed = false;
                    if (reader != null) {
                        String line = reader.readLine();
                        while (line != null) {
                            if (!processed && line.startsWith(prefix)) {
                                if (value != null) {
                                    writer.println(value);
                                }
                                processed = true;
                            } else {
                                writer.println(line);
                            }
                            line = reader.readLine();
                        }
                    }
                    if (!processed && value != null) {
                        writer.println(value);
                    }
                    Object var13_13 = null;
                    writer.flush();
                    writer.close();
                    if (reader == null) break block24;
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var13_14 = null;
                    writer.flush();
                    writer.close();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    try {
                        renamed = tempAuth.renameTo(authFile);
                        if (!renamed) {
                            renamed = AbstractAuthHelper.copy(tempAuth, authFile);
                        }
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var16_20;
                        v0 = var16_20 = null;
                    }
                    if (tempAuth.exists() && !tempAuth.delete()) {
                        Log.warn("Unable to delete temp auth file '" + tempAuth.getPath() + "' in AbstractAuthHelper.saveFileEntry() -- unknown cause");
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                renamed = tempAuth.renameTo(authFile);
                if (!renamed) {
                    renamed = AbstractAuthHelper.copy(tempAuth, authFile);
                }
                v1 = null;
            }
            catch (Throwable throwable) {
                Object var16_19;
                v1 = var16_19 = null;
            }
            if (tempAuth.exists() && !tempAuth.delete()) {
                Log.warn("Unable to delete temp auth file '" + tempAuth.getPath() + "' in AbstractAuthHelper.saveFileEntry() -- unknown cause");
            }
            AbstractAuthHelper.updateReadBit(authFile);
            if (!renamed) {
                throw new IOException("P4 auth file: " + authFile.getAbsolutePath() + " could not be overwritten.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copy(File source, File destination) throws IOException {
        boolean copied = false;
        if (source != null && destination != null) {
            IOException e22;
            AbstractInterruptibleChannel writer;
            block14: {
                FileChannel reader = null;
                writer = null;
                try {
                    long targetCount;
                    long transferCount;
                    reader = new FileInputStream(source).getChannel();
                    ISystemFileCommandsHelper helper = ServerFactory.getRpcFileSystemHelper();
                    if (helper == null) {
                        helper = SysFileHelperBridge.getSysFileCommands();
                    }
                    if (helper != null) {
                        helper.setWritable(destination.getAbsolutePath(), true);
                    }
                    copied = (transferCount = ((FileChannel)(writer = new FileOutputStream(destination, false).getChannel())).transferFrom(reader, 0L, targetCount = reader.size())) == targetCount;
                    Object var11_8 = null;
                    if (reader == null) break block14;
                }
                catch (Throwable throwable) {
                    IOException e22;
                    Object var11_9 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e22) {
                            Log.warn("reader close error in AbstractAuthHelper.copy(): " + e22.getLocalizedMessage());
                            Log.exception(e22);
                        }
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e22) {
                            Log.warn("writer close error in AbstractAuthHelper.copy(): " + e22.getLocalizedMessage());
                            Log.exception(e22);
                        }
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException e22) {
                    Log.warn("reader close error in AbstractAuthHelper.copy(): " + e22.getLocalizedMessage());
                    Log.exception(e22);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e22) {
                    Log.warn("writer close error in AbstractAuthHelper.copy(): " + e22.getLocalizedMessage());
                    Log.exception(e22);
                }
            }
        }
        return copied;
    }

    private static void updateReadBit(File file) throws IOException {
        if (file != null) {
            file.setReadOnly();
            ISystemFileCommandsHelper helper = ServerFactory.getRpcFileSystemHelper();
            if (helper == null) {
                helper = SysFileHelperBridge.getSysFileCommands();
            }
            if (helper != null) {
                helper.setOwnerReadOnly(file.getAbsolutePath());
            }
        }
    }
}

