/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IMapEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapEntry
implements IMapEntry {
    protected static String elementPatternStr = "([^\"]\\S*|\".+?\")\\s*";
    protected static Pattern elementPattern = Pattern.compile(elementPatternStr);
    protected int order = -1;
    protected IMapEntry.EntryType type = null;
    protected String left = null;
    protected String right = null;

    public MapEntry() {
    }

    public MapEntry(int order, String left, String right) {
        this.order = order;
        if (right != null) {
            this.right = MapEntry.stripTypePrefix(right);
        }
        if (left != null) {
            this.type = IMapEntry.EntryType.fromString(left);
            this.left = MapEntry.stripTypePrefix(left);
        }
    }

    public MapEntry(int order, IMapEntry.EntryType type, String left, String right) {
        this.order = order;
        this.type = type;
        if (left != null) {
            this.left = MapEntry.stripTypePrefix(left);
        }
        if (right != null) {
            this.right = MapEntry.stripTypePrefix(right);
        }
    }

    public MapEntry(int order, String mappingStr) {
        this.order = order;
        if (mappingStr != null) {
            String[] entries = MapEntry.parseViewMappingString(mappingStr);
            this.type = IMapEntry.EntryType.fromString(entries[0]);
            this.left = MapEntry.stripTypePrefix(entries[0]);
            this.right = entries[1];
        }
    }

    public MapEntry(IMapEntry entry) {
        if (entry != null) {
            this.order = entry.getOrder();
            this.type = entry.getType();
            this.left = entry.getLeft();
            this.right = entry.getRight();
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int position) {
        this.order = position;
    }

    public IMapEntry.EntryType getType() {
        return this.type;
    }

    public void setType(IMapEntry.EntryType type) {
        this.type = type;
    }

    public String getLeft() {
        return this.getLeft(false);
    }

    public String getLeft(boolean quoteBlanks) {
        if (quoteBlanks && this.left != null && (this.left.contains(" ") || this.left.contains("\t"))) {
            return "\"" + this.left + "\"";
        }
        return this.left;
    }

    public void setLeft(String left) {
        this.left = left;
    }

    public String getRight() {
        return this.getRight(false);
    }

    public String getRight(boolean quoteBlanks) {
        if (quoteBlanks && this.right != null && (this.right.contains(" ") || this.right.contains("\t"))) {
            return "\"" + this.right + "\"";
        }
        return this.right;
    }

    public void setRight(String right) {
        this.right = right;
    }

    public String toString(String sepString, boolean quoteBlanks) {
        StringBuilder retVal = new StringBuilder();
        boolean quoteLeft = false;
        boolean quoteRight = false;
        if (quoteBlanks) {
            if (this.left != null && this.left.contains(" ")) {
                quoteLeft = true;
            }
            if (this.right != null && this.right.contains(" ")) {
                quoteRight = true;
            }
        }
        if (quoteLeft) {
            retVal.append("\"");
        }
        if (this.type != null && this.type != IMapEntry.EntryType.INCLUDE) {
            retVal.append((Object)this.type);
        }
        if (this.left != null) {
            retVal.append(this.left);
        }
        if (quoteLeft) {
            retVal.append("\"");
        }
        if (sepString != null && this.right != null) {
            retVal.append(sepString);
        }
        if (this.right != null) {
            if (quoteRight) {
                retVal.append("\"");
            }
            retVal.append(this.right);
            if (quoteRight) {
                retVal.append("\"");
            }
        }
        return retVal.toString();
    }

    public String toString() {
        return this.toString(" ", true);
    }

    public static String stripTypePrefix(String str) {
        if (str != null) {
            if (str.startsWith("-")) {
                return str.substring("-".length());
            }
            if (str.startsWith("+")) {
                return str.substring("+".length());
            }
            return str;
        }
        return null;
    }

    public static String[] parseViewMappingString(String str) {
        String[] retVal = new String[]{null, null};
        if (str != null) {
            Matcher mat = elementPattern.matcher(str);
            int fields = 0;
            while (mat.find()) {
                if (mat.groupCount() <= 0 || mat.group(1) == null) continue;
                retVal[fields] = mat.group(1).startsWith("\"") ? mat.group(1).replaceAll("^\"|\"$", "") : mat.group(1);
                ++fields;
            }
            if (fields < 1 || fields > 3) {
                Log.warn("Bad view map field count in MapEntry.parseViewString: '" + str + "' (" + fields + ")");
            }
        }
        return retVal;
    }
}

