/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.admin;

import com.perforce.p4java.admin.IProtectionEntry;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.impl.generic.core.MapEntry;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectionEntry
extends MapEntry
implements IProtectionEntry {
    private String mode = null;
    private boolean group = false;
    private String host = null;
    private String name = null;

    public ProtectionEntry() {
    }

    public ProtectionEntry(int order, String mode, boolean group, String host, String name, String path, boolean pathExcluded) {
        super(order, path);
        this.mode = mode;
        this.group = group;
        this.host = host;
        this.name = name;
        this.left = path;
        this.type = pathExcluded ? IMapEntry.EntryType.EXCLUDE : IMapEntry.EntryType.INCLUDE;
    }

    public ProtectionEntry(Map<String, Object> map, int order) {
        if (map != null) {
            this.order = order;
            this.host = (String)map.get("host");
            this.left = (String)map.get("depotFile");
            this.mode = (String)map.get("perm");
            this.name = (String)map.get("user");
            this.group = map.containsKey("isgroup");
            this.type = map.containsKey("unmap") ? IMapEntry.EntryType.EXCLUDE : IMapEntry.EntryType.INCLUDE;
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.left;
    }

    @Override
    public boolean isGroup() {
        return this.group;
    }

    @Override
    public void setGroup(boolean group) {
        this.group = group;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setPath(String path) {
        this.left = path;
    }

    @Override
    public boolean isPathExcluded() {
        return this.type == IMapEntry.EntryType.EXCLUDE;
    }

    @Override
    public void setPathExcluded(boolean pathExcluded) {
        this.type = pathExcluded ? IMapEntry.EntryType.EXCLUDE : IMapEntry.EntryType.INCLUDE;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mode != null) {
            sb.append(this.mode);
        }
        if (this.isGroup()) {
            sb.append(" ").append("group");
        } else {
            sb.append(" ").append("user");
        }
        if (this.name != null) {
            sb.append(" ").append(this.name);
        }
        if (this.host != null) {
            sb.append(" ").append(this.host);
        }
        if (this.left != null) {
            if (this.isPathExcluded()) {
                sb.append(" ").append("-").append(this.left);
            } else {
                sb.append(" ").append(this.left);
            }
        }
        return sb.toString();
    }
}

