/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func.client;

import com.perforce.p4java.CharsetConverter;
import com.perforce.p4java.CharsetDefs;
import com.perforce.p4java.Log;
import com.perforce.p4java.exception.ClientError;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.ProtocolError;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.sys.ISystemFileCommandsHelper;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientMessage;
import com.perforce.p4java.impl.mapbased.rpc.func.helper.MD5Digester;
import com.perforce.p4java.impl.mapbased.rpc.msg.RpcMessage;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.impl.mapbased.rpc.sys.helper.SysFileHelperBridge;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSystemFileCommands {
    public static final String TRACE_PREFIX = "ClientSystemFileCommands";
    public static final String DEFAULT_TMPFILE_PFX = "p4j";
    public static final String DEFAULT_TMPFILE_SFX = ".p4j";
    public static final String SYSTEM_TMPDIR_PROPS_KEY = "java.io.tmpdir";
    public static final String SYSTEM_TMPDIR_DEFAULT = "/tmp";
    public static final String PERMS_RW = "rw";
    protected static final String FILE_DELETE_ON_ERR_KEY = "deleteOnError";
    protected static final String FILE_OPEN_PATH_KEY = "openFilePath";
    protected static final String FILE_OPEN_TARGET_FILE_KEY = "targetFile";
    protected static final String FILE_OPEN_TMP_FILE_KEY = "tmpFile";
    protected static final String FILE_OPEN_TMP_STREAM_KEY = "tmpFileStream";
    protected static final String FILE_OPEN_TARGET_STREAM_KEY = "targetFileStream";
    protected static final String FILE_OPEN_ORIG_ARGS_KEY = "origArgs";
    protected static final String FILE_OPEN_MODTIME_KEY = "modTime";
    private Properties props = null;
    private String tmpDirName = null;
    private ISystemFileCommandsHelper fileCommands = SysFileHelperBridge.getSysFileCommands();

    protected ClientSystemFileCommands(Properties props) {
        this.props = props;
        this.tmpDirName = RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty(SYSTEM_TMPDIR_PROPS_KEY));
        if (this.tmpDirName == null) {
            this.tmpDirName = SYSTEM_TMPDIR_DEFAULT;
            Log.warn("Unable to get tmp name from P4 props or System; using " + this.tmpDirName + " instead");
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult chmodFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String path = (String)resultsMap.get("path");
        String perms = (String)resultsMap.get("perms");
        String fileTypeStr = (String)resultsMap.get("type");
        String time = (String)resultsMap.get("time");
        try {
            cmdEnv.newHandler();
            RpcPerforceFile targetFile = new RpcPerforceFile(path, fileTypeStr);
            RpcPerforceFileType fileType = null;
            if (targetFile.exists()) {
                if (time != null) {
                    targetFile.setLastModified(new Long(time));
                }
                if (perms != null) {
                    if (perms.equalsIgnoreCase(PERMS_RW)) {
                        this.fileCommands.setWritable(path, true);
                    } else {
                        this.fileCommands.setWritable(path, false);
                    }
                }
                if (fileTypeStr != null && (fileType = RpcPerforceFileType.decodeFromServerString(fileTypeStr)) != null) {
                    switch (fileType) {
                        case FST_XTEXT: 
                        case FST_XBINARY: {
                            this.fileCommands.setExecutable(path, true, true);
                        }
                    }
                }
            } else {
                cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_CHMOD_FILE, 1, 34, new String[]{path}).toMap());
            }
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolError("Unexpected conversion error in ClientSystemFileCommands.chmodFile: " + nfe.getLocalizedMessage());
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new ConnectionException(exc.getLocalizedMessage(), exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    /*
     * Unable to fully structure code
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult openFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        path = (String)resultsMap.get("path");
        clientHandle = (String)resultsMap.get("handle");
        modTime = (String)resultsMap.get("time");
        noClobber = (String)resultsMap.get("noclobber");
        perms = (String)resultsMap.get("perms");
        fileType = (String)resultsMap.get("type");
        try {
            targetFile = new RpcPerforceFile(path, fileType);
            tmpFile = null;
            handler = cmdEnv.getHandler(clientHandle);
            if (handler == null) {
                v0 = cmdEnv;
                v0.getClass();
                handler = v0.new CommandEnv.RpcHandler(clientHandle, false, targetFile);
                cmdEnv.addHandler(handler);
            } else {
                handler.getMap().remove("tmpFile");
                handler.getMap().remove("tmpFileStream");
                handler.getMap().remove("modTime");
            }
            handler.setError(false);
            handler.getMap().put("origArgs", resultsMap);
            handler.getMap().put("modTime", modTime);
            if (targetFile.exists() && targetFile.isFile() && noClobber != null && targetFile.canWrite()) {
                cmdEnv.getHandler(clientHandle).setError(true);
                cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{path}).toMap());
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (RpcPerforceFileType.decodeFromServerString(fileType) == RpcPerforceFileType.FST_SYMLINK) {
                cmdEnv.getHandler(clientHandle).setError(true);
                cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE_TYPE, 3, 34, new String[]{"symlink", path}).toMap());
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (targetFile.exists() && targetFile.isFile() && !cmdEnv.isSyncInPlace()) {
                tmpFileName = RpcPerforceFile.createTempFileName(targetFile.getParent());
                tmpFile = new RpcPerforceFile(tmpFileName, fileType);
                tmpFile.deleteOnExit();
                handler.getMap().put("tmpFile", tmpFile);
                if (perms != null && perms.equalsIgnoreCase("rw")) {
                    this.fileCommands.setWritable(tmpFileName, true);
                }
            } else if (!targetFile.exists()) {
                if (!this.mkdirs(targetFile)) {
                    handler.setError(true);
                    cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{path}).toMap());
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
                try {
                    if (!targetFile.createNewFile()) {
                        Log.warn("ClientSystemFileCommands.openFile: unable to create new target file");
                    }
                    if (targetFile.canCopyAsIs()) ** GOTO lbl74
                    tmpFileName = RpcPerforceFile.createTempFileName(this.tmpDirName);
                    tmpFile = new RpcPerforceFile(tmpFileName, fileType);
                    tmpFile.deleteOnExit();
                    handler.getMap().put("tmpFile", tmpFile);
                }
                catch (IOException ioexc) {
                    handler.setError(true);
                    cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_FILE, 3, 34, new String[]{path, ioexc.getLocalizedMessage()}).toMap());
                    return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
                }
            } else if (targetFile.isFile()) {
                this.fileCommands.setWritable(path, true);
            }
lbl74:
            // 6 sources

            handler.getMap().put("targetFile", targetFile);
            if (perms != null && perms.equalsIgnoreCase("rw")) {
                this.fileCommands.setWritable(path, true);
            }
            if (fileType != null && RpcPerforceFileType.decodeFromServerString(fileType).isExecutable()) {
                this.fileCommands.setExecutable(path, true, true);
            }
            if (tmpFile != null) {
                tmpStream = new RpcOutputStream(tmpFile, rpcConnection.getClientCharset(), rpcConnection.isUnicodeServer());
                handler.getMap().put("tmpFileStream", tmpStream);
            } else if (targetFile != null) {
                targetStream = new RpcOutputStream(targetFile, rpcConnection.getClientCharset(), rpcConnection.isUnicodeServer());
                handler.getMap().put("targetFileStream", targetStream);
            }
        }
        catch (P4JavaError p4je) {
            throw p4je;
        }
        catch (Exception exc) {
            Log.exception(exc);
            throw new P4JavaError("Unexpected exception in ClientSystemFileCommands.openFile: " + exc.getLocalizedMessage() + exc, exc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        String clientHandle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        if (handler == null) {
            throw new NullPointerError("Null client handler in writeFile");
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (stateMap == null) {
            throw new NullPointerError("Null state map in ClientSystemFileCommands.writeFile()");
        }
        RpcOutputStream outStream = (RpcOutputStream)handler.getMap().get(FILE_OPEN_TMP_STREAM_KEY);
        if (outStream == null) {
            outStream = (RpcOutputStream)handler.getMap().get(FILE_OPEN_TARGET_STREAM_KEY);
        }
        if (outStream == null) {
            throw new P4JavaError("No open file stream in ClientSystemFileCommands.writeFile()");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                outStream.write(resultsMap);
            } else {
                Log.error("output stream unexpectedly closed in writeFile");
                handler.setError(true);
            }
        }
        catch (IOException ioexc) {
            String path = (String)handler.getMap().get("path");
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{path == null ? "<unknown>" : path, ioexc.getLocalizedMessage()}).toMap());
            Log.error("failed write for file " + (path == null ? "<unknown>" : path) + "; exception follows...");
            Log.exception(ioexc);
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private void writeToStream(byte[] sourceBytes, int start, int length, OutputStream stream) throws IOException {
        if (ClientLineEnding.CONVERT_TEXT) {
            for (int i = start; i < length; ++i) {
                if (sourceBytes[i] == ClientLineEnding.FST_L_LF_BYTES[0]) {
                    stream.write(ClientLineEnding.FST_L_LOCAL_BYTES);
                    continue;
                }
                stream.write(sourceBytes[i]);
            }
        } else {
            stream.write(sourceBytes, start, length);
        }
    }

    private void translate(byte[] sourceBytes, CharsetConverter converter, int length, OutputStream stream) throws IOException {
        int start = 0;
        if (ClientLineEnding.CONVERT_TEXT) {
            ByteArrayOutputStream converted = new ByteArrayOutputStream();
            this.writeToStream(sourceBytes, start, length, converted);
            sourceBytes = converted.toByteArray();
            start = 0;
            length = sourceBytes.length;
        }
        ByteBuffer from = ByteBuffer.wrap(sourceBytes);
        if (length > 0) {
            ByteBuffer converted = converter.convert(from);
            if (converted != null) {
                sourceBytes = converted.array();
                start = converted.position();
                length = converted.limit();
            }
        } else {
            byte[] underflow = converter.clearUnderflow();
            if (underflow != null) {
                ByteBuffer converted = converter.convert(ByteBuffer.wrap(underflow));
                if (converted != null) {
                    sourceBytes = converted.array();
                    start = converted.position();
                    length = converted.limit();
                }
                if (converter.clearUnderflow() != null) {
                    throw new ClientError("Translation of text output failed to charset " + converter.getToCharsetName());
                }
            }
        }
        if (length > 0) {
            stream.write(sourceBytes, start, length);
        }
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeText(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String trans = (String)resultsMap.get("trans");
        if (trans != null && !trans.equalsIgnoreCase("no")) {
            throw new P4JavaError("trans arg not 'no' or null in writeText: " + trans);
        }
        String handlerName = "writeText";
        CommandEnv.RpcHandler handler = cmdEnv.getHandler("writeText");
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = commandEnv.new CommandEnv.RpcHandler("writeText", false, null);
            cmdEnv.addHandler(handler);
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        RpcOutputStream outStream = (RpcOutputStream)stateMap.get("");
        if (outStream == null) {
            throw new NullPointerError("Null output stream in writeText state map");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                byte[] sourceBytes = (byte[])resultsMap.get("data");
                int len = sourceBytes.length;
                int start = 0;
                if (trans == null) {
                    CharsetConverter converter = (CharsetConverter)stateMap.get("RPC_TMP_CONVERTER_KEY");
                    if (converter == null) {
                        Charset charset = rpcConnection.getClientCharset();
                        for (Map<String, Object> map : cmdEnv.getResultsMapVec()) {
                            String type;
                            if (!map.containsKey("type") || !"utf16".equals(type = map.get("type").toString())) continue;
                            charset = CharsetDefs.UTF16;
                            break;
                        }
                        if (charset != CharsetDefs.UTF8) {
                            converter = new CharsetConverter(CharsetDefs.UTF8, charset);
                            stateMap.put("RPC_TMP_CONVERTER_KEY", converter);
                        }
                    }
                    if (converter != null) {
                        this.translate(sourceBytes, converter, len, outStream);
                    } else {
                        this.writeToStream(sourceBytes, start, len, outStream);
                    }
                } else if (len > 0) {
                    this.writeToStream(sourceBytes, start, len, outStream);
                }
            } else {
                Log.error("output stream unexpectedly closed in writeText");
                handler.setError(true);
            }
        }
        catch (IOException ioexc) {
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", ioexc.getLocalizedMessage()}).toMap());
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult writeBinary(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String handlerName = "writeBinary";
        CommandEnv.RpcHandler handler = cmdEnv.getHandler("writeBinary");
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = commandEnv.new CommandEnv.RpcHandler("writeBinary", false, null);
            cmdEnv.addHandler(handler);
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        RpcOutputStream outStream = (RpcOutputStream)stateMap.get("");
        if (outStream == null) {
            throw new NullPointerError("Null output stream in writeBinary state map");
        }
        try {
            if (outStream.getFD() != null && outStream.getFD().valid()) {
                outStream.write(resultsMap);
            } else {
                Log.error("output stream unexpectedly closed in writeBinary");
                handler.setError(true);
            }
        }
        catch (IOException ioexc) {
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_WRITE_ERROR, 3, 34, new String[]{"tmp file", ioexc.getLocalizedMessage()}).toMap());
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RpcPacketDispatcher.RpcPacketDispatcherResult closeFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        Map<String, Object> stateMap = cmdEnv.getStateMap();
        String commit = (String)resultsMap.get("commit");
        String clientHandle = (String)resultsMap.get("handle");
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        if (handler == null) {
            throw new NullPointerError("Null client handler in writeFile");
        }
        if (handler.isError()) {
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (stateMap == null) {
            throw new NullPointerError("Null state map in ClientSystemFileCommands.writeFile()");
        }
        RpcOutputStream tmpStream = (RpcOutputStream)handler.getMap().get(FILE_OPEN_TMP_STREAM_KEY);
        RpcOutputStream targetStream = (RpcOutputStream)handler.getMap().get(FILE_OPEN_TARGET_STREAM_KEY);
        RpcPerforceFile tmpFile = (RpcPerforceFile)handler.getMap().get(FILE_OPEN_TMP_FILE_KEY);
        RpcPerforceFile targetFile = (RpcPerforceFile)handler.getMap().get(FILE_OPEN_TARGET_FILE_KEY);
        if (targetFile == null) {
            throw new NullPointerError("Null target file ClientSystemFileCommands.closeFile() state map");
        }
        if (commit != null) {
            Map origArgs = (Map)handler.getMap().get(FILE_OPEN_ORIG_ARGS_KEY);
            if (origArgs == null) {
                throw new NullPointerError("Null original argument map ClientSystemFileCommands.closeFile() state map");
            }
            String perms = (String)origArgs.get("perms");
            String modTimeStr = null;
            if (handler.getMap().containsKey(FILE_OPEN_MODTIME_KEY)) {
                modTimeStr = (String)handler.getMap().get(FILE_OPEN_MODTIME_KEY);
            }
            try {
                if (tmpStream != null) {
                    try {
                        tmpStream.flush();
                    }
                    catch (IOException e) {
                        Log.error("Flushing stream failed in closeFile(); tmp file: " + tmpFile.getName());
                    }
                    if (tmpFile == null) {
                        throw new NullPointerError("Null tmp file ClientSystemFileCommands.writeFile() state map");
                    }
                    if (!tmpFile.renameTo(targetFile)) {
                        Log.error("Rename failed completely in closeFile(); tmp file: " + tmpFile.getName() + "; target file: " + targetFile.getName());
                    }
                }
                if (modTimeStr != null) {
                    try {
                        long modTime = new Long(modTimeStr);
                        if (modTime > 0L) {
                            targetFile.setLastModified(modTime * 1000L);
                        }
                    }
                    catch (Exception exc) {
                        Log.warn("Unable to set target file modification time: " + exc);
                    }
                }
                if (perms.equalsIgnoreCase(PERMS_RW)) {
                    this.fileCommands.setWritable(targetFile.getPath(), true);
                } else {
                    this.fileCommands.setWritable(targetFile.getPath(), false);
                }
                if (targetFile.getFileType().isExecutable()) {
                    this.fileCommands.setExecutable(targetFile.getPath(), true, true);
                }
                Object var18_18 = null;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    if (tmpStream != null) {
                        tmpStream.close();
                    }
                }
                catch (IOException ioexc) {
                    Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage());
                }
                try {
                    if (targetStream != null) {
                        targetStream.close();
                    }
                }
                catch (IOException ioexc) {
                    Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage());
                }
                if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                    Log.warn("Unable to delete tmp file '" + tmpFile.getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause");
                }
                throw throwable;
            }
            try {
                if (tmpStream != null) {
                    tmpStream.close();
                }
            }
            catch (IOException ioexc) {
                Log.warn("tmp file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage());
            }
            try {
                if (targetStream != null) {
                    targetStream.close();
                }
            }
            catch (IOException ioexc) {
                Log.warn("target file close error in ClientSystemFileCommands.closeFile(): " + ioexc.getLocalizedMessage());
            }
            if (tmpFile != null && tmpFile.exists() && !tmpFile.delete()) {
                Log.warn("Unable to delete tmp file '" + tmpFile.getPath() + "' in ClientSystemFileCommands.closeFile() -- unknown cause");
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult moveFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        boolean caseSensitive;
        String clientPath = (String)resultsMap.get("path");
        String targetPath = (String)resultsMap.get("path2");
        String type = (String)resultsMap.get("type");
        String targetType = (String)resultsMap.get("type2");
        String clientHandle = (String)resultsMap.get("handle");
        String confirm = (String)resultsMap.get("confirm");
        String rmdir = (String)resultsMap.get("rmdir");
        RpcPerforceFile fromFile = new RpcPerforceFile(clientPath, type);
        RpcPerforceFile toFile = new RpcPerforceFile(targetPath, targetType);
        CommandEnv.RpcHandler handler = cmdEnv.getHandler(clientHandle);
        if (handler == null) {
            CommandEnv commandEnv = cmdEnv;
            commandEnv.getClass();
            handler = commandEnv.new CommandEnv.RpcHandler(clientHandle, false, toFile);
            cmdEnv.addHandler(handler);
        }
        handler.setError(false);
        if (!fromFile.exists()) {
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_NONEXISTENT, 1, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        boolean bl = caseSensitive = !cmdEnv.getServerProtocolSpecsMap().containsKey("nocase");
        if (!(!toFile.exists() || caseSensitive && clientPath.equalsIgnoreCase(targetPath))) {
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{targetPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (!this.mkdirs(toFile)) {
            handler.setError(true);
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_CREATE_DIR, 3, 34, new String[]{targetPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (fromFile.renameTo(toFile, true)) {
            resultsMap.remove("func");
            RpcPacket respPacket = RpcPacket.constructRpcPacket(RpcFunctionSpec.decode(confirm), resultsMap, null);
            rpcConnection.putRpcPacket(respPacket);
        } else {
            Log.error("Rename failed completely in moveFile (cause unknown); source file: " + clientPath + "; target file: " + targetPath);
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_MOVE_ERROR, 3, 34, new String[]{clientPath, "(cause unknown)"}).toMap());
        }
        if (rmdir != null) {
            File dir = fromFile.getParentFile();
            if (dir != null) {
                if (!dir.delete()) {
                    Log.warn("Unable to delete parent directory for delete for file '" + clientPath + "'; (unknown cause)");
                }
            } else {
                Log.warn("Unable to open parent directory for delete for file '" + clientPath + "'; (no parent directory)");
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult deleteFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        String clientPath = (String)resultsMap.get("path");
        String noClobber = (String)resultsMap.get("noclobber");
        String rmDir = (String)resultsMap.get("rmdir");
        File file = new File(clientPath);
        if (!file.exists()) {
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_NONEXISTENT, 1, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (file.exists() && file.isFile() && noClobber != null && file.canWrite()) {
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_CLOBBER, 3, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        boolean deleteFailed = false;
        if (!file.delete()) {
            deleteFailed = true;
            if (!file.canWrite() && this.fileCommands.setWritable(clientPath, true)) {
                boolean bl = deleteFailed = !file.delete();
            }
        }
        if (deleteFailed) {
            cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.CANT_DELETE_FILE, 3, 34, new String[]{clientPath}).toMap());
            return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
        }
        if (rmDir != null) {
            File dir = file.getParentFile();
            if (dir != null) {
                if (!dir.delete()) {
                    Log.warn("Unable to delete parent directory for delete for file '" + clientPath + "'; (unknown cause)");
                }
            } else {
                Log.warn("Unable to open parent directory for delete for file '" + clientPath + "' (unknown cause)");
            }
        }
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    protected RpcPacketDispatcher.RpcPacketDispatcherResult checkFile(RpcConnection rpcConnection, CommandEnv cmdEnv, Map<String, Object> resultsMap) throws ConnectionException {
        File file;
        String nType;
        String clientPath = (String)resultsMap.get("path");
        String clientType = (String)resultsMap.get("type");
        String forceType = (String)resultsMap.get("forceType");
        String digest = (String)resultsMap.get("digest");
        String confirm = (String)resultsMap.get("confirm");
        String status = "exists";
        String string = nType = clientType == null ? "text" : clientType;
        if (clientType != null) {
            file = new File(clientPath);
            if (!file.exists()) {
                status = "missing";
            } else if (digest != null) {
                MD5Digester digester = new MD5Digester();
                if (digester != null) {
                    Charset digestCharset = null;
                    boolean convertLineEndings = false;
                    RpcPerforceFileType fileType = RpcPerforceFileType.decodeFromServerString(clientType);
                    switch (fileType) {
                        case FST_UTF16: {
                            digestCharset = CharsetDefs.UTF16;
                        }
                        case FST_UNICODE: {
                            if (digestCharset == null) {
                                digestCharset = rpcConnection.getClientCharset();
                            }
                        }
                        case FST_XTEXT: 
                        case FST_TEXT: {
                            convertLineEndings = true;
                        }
                    }
                    String digestStr = digester.digestFileAs32ByteHex(file, digestCharset, convertLineEndings);
                    if (digestStr != null && digestStr.equals(digest)) {
                        status = "same";
                    }
                } else {
                    Log.warn("Unable to create MD5 digester for file '" + clientPath + "' in checkFile()");
                }
            }
        } else {
            RpcPerforceFileType.RpcServerTypeStringSpec spec;
            file = new File(clientPath);
            if (!file.exists()) {
                status = "missing";
                cmdEnv.getResultsMapVec().add(new RpcMessage(ClientMessage.ClientMessageId.FILE_MISSING_ASSUMING_TYPE, 1, 34, new String[]{clientPath, nType}).toMap());
            }
            String serverXLevelStr = (String)cmdEnv.getServerProtocolSpecsMap().get("xfiles");
            int serverXLevel = 0;
            if (serverXLevelStr != null) {
                try {
                    serverXLevel = new Integer(serverXLevelStr);
                }
                catch (NumberFormatException nfe) {
                    throw new ProtocolError("Unexpected number conversion exception in ClientSystemFileCommands.checkFile: " + nfe.getLocalizedMessage(), nfe);
                }
            }
            if ((spec = RpcPerforceFileType.getServerFileTypeString(clientPath, RpcPerforceFileType.inferFileType(file, cmdEnv.getRpcConnection().isUnicodeServer(), cmdEnv.getRpcConnection().getClientCharset()), forceType, serverXLevel)).getServerTypeString() == null) {
                cmdEnv.getResultsMapVec().add(spec.getMsg().toMap());
                return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
            }
            if (spec.getMsg() != null) {
                cmdEnv.getResultsMapVec().add(spec.getMsg().toMap());
            }
            nType = spec.getServerTypeString();
        }
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("type", nType);
        respMap.put("status", status);
        for (String key : resultsMap.keySet()) {
            if (key == null || key.equalsIgnoreCase("func") || key.equalsIgnoreCase("type") || key.equalsIgnoreCase("status")) continue;
            respMap.put(key, resultsMap.get(key));
        }
        RpcPacket respPacket = RpcPacket.constructRpcPacket(RpcFunctionSpec.decode(confirm), respMap, null);
        rpcConnection.putRpcPacket(respPacket);
        return RpcPacketDispatcher.RpcPacketDispatcherResult.CONTINUE_LOOP;
    }

    private boolean mkdirs(RpcPerforceFile targetFile) {
        File parentDir;
        String parent = targetFile.getParent();
        if (parent != null && !(parentDir = new File(parent)).exists()) {
            return parentDir.mkdirs();
        }
        return true;
    }
}

