/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc;

import com.perforce.p4java.Log;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.ConnectionNotConnectedException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.client.ClientLineEnding;
import com.perforce.p4java.impl.generic.core.TempFileInputStream;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.ExternalEnv;
import com.perforce.p4java.impl.mapbased.rpc.RpcCmdSpec;
import com.perforce.p4java.impl.mapbased.rpc.RpcPropertyDefs;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.connection.RpcConnection;
import com.perforce.p4java.impl.mapbased.rpc.func.RpcFunctionSpec;
import com.perforce.p4java.impl.mapbased.rpc.func.proto.ProtocolCommand;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacket;
import com.perforce.p4java.impl.mapbased.rpc.packet.RpcPacketDispatcher;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcSocketPool;
import com.perforce.p4java.impl.mapbased.rpc.stream.RpcStreamConnection;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcOutputStream;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFileType;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.ServerStatus;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneShotServerImpl
extends RpcServer {
    public static final String SCREEN_NAME = "Native RPC";
    public static final String IMPL_COMMENTS = "Java-native RPC standalone P4Java implementation. Requires JDK 6 or later and full Java NIO support.";
    public static final String PROTOCOL_NAME = "p4jrpc";
    public static final boolean DEFAULT_STATUS = false;
    public static final int MINIMUM_SUPPORTED_SERVER_LEVEL = 20052;
    public static final String TRACE_PREFIX = "OneShotServerImpl";
    protected RpcSocketPool socketPool = null;

    @Override
    public ServerStatus init(String host, int port, Properties props) throws ConfigException, ConnectionException {
        this.minumumSupportedServerVersion = 20052;
        ServerStatus status = super.init(host, port, props);
        int poolSize = RpcPropertyDefs.getPropertyAsInt(this.props, "socketPoolSize", 0);
        if (poolSize > 0) {
            RpcSocketPool.ShutdownHandler handler = new RpcSocketPool.ShutdownHandler(){

                public void shutdown(Socket socket) {
                    try {
                        RpcPacketDispatcher dispatcher = new RpcPacketDispatcher(OneShotServerImpl.this.props, OneShotServerImpl.this);
                        RpcStreamConnection rpcConnection = new RpcStreamConnection(OneShotServerImpl.this.serverHost, OneShotServerImpl.this.serverPort, OneShotServerImpl.this.props, OneShotServerImpl.this.serverStats, OneShotServerImpl.this.charset, socket);
                        dispatcher.shutdown(rpcConnection);
                    }
                    catch (ConnectionException e) {
                        Log.exception(e);
                    }
                }
            };
            this.socketPool = new RpcSocketPool(poolSize, this.serverHost, this.serverPort, this.props, handler);
        }
        return status;
    }

    @Override
    public void connect() throws ConnectionException, AccessException, RequestException, ConfigException {
        this.serverStats.clear();
        super.connect();
    }

    @Override
    public void disconnect() throws ConnectionException, AccessException {
        if (this.socketPool != null) {
            this.socketPool.disconnect();
        }
        super.disconnect();
    }

    @Override
    public Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, AccessException, RequestException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, false);
    }

    @Override
    public Map<String, Object>[] execQuietMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap) throws ConnectionException, RequestException, AccessException {
        return this.execMapCmd(cmdName, cmdArgs, inMap, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Object>[] execMapCmd(String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks) throws ConnectionException, AccessException, RequestException {
        Map<String, Object>[] mapArray;
        RpcPacketDispatcher dispatcher = null;
        RpcConnection rpcConnection = null;
        if (cmdName == null) {
            throw new NullPointerError("Null command name passed to execMapCmd");
        }
        if (!this.connected) {
            throw new ConnectionNotConnectedException("Not currently connected to a Perforce server");
        }
        try {
            try {
                int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                long startTime = System.currentTimeMillis();
                dispatcher = new RpcPacketDispatcher(this.props, this);
                rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, this.socketPool);
                ProtocolCommand protocolSpecs = new ProtocolCommand();
                if (inMap != null && ClientLineEnding.CONVERT_TEXT) {
                    ClientLineEnding.convertMap(inMap);
                }
                ExternalEnv env = this.setupCmd(dispatcher, rpcConnection, protocolSpecs, cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, inMap, ignoreCallbacks, cmdCallBackKey, false);
                CommandEnv cmdEnv = new CommandEnv(new RpcCmdSpec(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, this.authTicket, inMap, env), rpcConnection, protocolSpecs, new HashMap<String, Object>(), this.progressCallback, cmdCallBackKey, this.writeInPlace(cmdName));
                Map<String, Object>[] retMap = dispatcher.dispatch(cmdEnv);
                long endTime = System.currentTimeMillis();
                if (this.caseSensitive && cmdEnv.getServerProtocolSpecsMap().containsKey("nocase")) {
                    this.caseSensitive = false;
                }
                if (!ignoreCallbacks && this.commandCallback != null) {
                    this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
                }
                mapArray = retMap;
                Object var18_17 = null;
                if (rpcConnection == null) return mapArray;
            }
            catch (BufferOverflowException exc) {
                Log.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                Log.exception(exc);
                throw new P4JavaError("RPC Buffer overflow: " + exc.getLocalizedMessage());
            }
            catch (ConnectionNotConnectedException cnce) {
                this.connected = false;
                this.status = ServerStatus.ERROR;
                throw cnce;
            }
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            if (rpcConnection == null) throw throwable;
            rpcConnection.disconnect(dispatcher);
            throw throwable;
        }
        rpcConnection.disconnect(dispatcher);
        return mapArray;
    }

    @Override
    public InputStream execQuietStreamCmd(String cmdName, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        return this.execStreamCmd(cmdName, cmdArgs, true);
    }

    @Override
    public InputStream execStreamCmd(String cmdName, String[] cmdArgs) throws ConnectionException, RequestException, AccessException {
        return this.execStreamCmd(cmdName, cmdArgs, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream execStreamCmd(String cmdName, String[] cmdArgs, boolean ignoreCallbacks) throws ConnectionException, RequestException, AccessException {
        InputStream inputStream;
        RpcConnection rpcConnection;
        RpcPacketDispatcher dispatcher;
        block16: {
            TempFileInputStream tempFileInputStream;
            block15: {
                dispatcher = null;
                rpcConnection = null;
                if (cmdName == null) {
                    throw new NullPointerError("Null command name passed to execStreamCmd");
                }
                if (!this.connected) {
                    throw new ConnectionNotConnectedException("Not currently connected to a Perforce server");
                }
                try {
                    try {
                        int cmdCallBackKey = this.nextCmdCallBackKey.incrementAndGet();
                        long startTime = System.currentTimeMillis();
                        dispatcher = new RpcPacketDispatcher(this.props, this);
                        rpcConnection = new RpcStreamConnection(this.serverHost, this.serverPort, this.props, this.serverStats, this.charset, this.socketPool);
                        ProtocolCommand protocolSpecs = new ProtocolCommand();
                        ExternalEnv env = this.setupCmd(dispatcher, rpcConnection, protocolSpecs, cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, null, ignoreCallbacks, cmdCallBackKey, true);
                        String tmpFileName = null;
                        RpcPerforceFile tmpFile = null;
                        RpcOutputStream tmpOutStream = null;
                        try {
                            tmpFileName = RpcPerforceFile.createTempFileName(RpcPropertyDefs.getProperty(this.props, "com.perforce.p4java.tmpDir", System.getProperty("java.io.tmpdir")));
                            tmpFile = new RpcPerforceFile(tmpFileName, RpcPerforceFileType.FST_BINARY);
                            tmpOutStream = new RpcOutputStream(tmpFile);
                        }
                        catch (IOException ioexc) {
                            throw new RequestException("Unable to create temporary file for Perforce file retrieval; reason: " + ioexc.getLocalizedMessage(), ioexc);
                        }
                        CommandEnv cmdEnv = new CommandEnv(new RpcCmdSpec(cmdName.toLowerCase(Locale.ENGLISH), cmdArgs, this.authTicket, new HashMap<String, Object>(), env), rpcConnection, protocolSpecs, new HashMap<String, Object>(), this.progressCallback, cmdCallBackKey, this.writeInPlace(cmdName));
                        cmdEnv.getStateMap().put("", tmpOutStream);
                        Map<String, Object>[] retMap = dispatcher.dispatch(cmdEnv);
                        long endTime = System.currentTimeMillis();
                        if (!ignoreCallbacks && this.commandCallback != null) {
                            this.processCmdCallbacks(cmdCallBackKey, endTime - startTime, retMap);
                        }
                        if (retMap != null && retMap.length != 0) {
                            for (Map<String, Object> map : retMap) {
                                String errStr;
                                if (map == null || (errStr = this.getErrorStr(map)) == null) continue;
                                if (!this.isAuthFail(errStr)) throw new RequestException(errStr, this.getGenericCode(map), this.getSeverityCode(map));
                                throw new AccessException(errStr);
                            }
                        }
                        if (tmpOutStream != null) {
                            TempFileInputStream inStream;
                            tmpOutStream.close();
                            tempFileInputStream = inStream = new TempFileInputStream(tmpFile);
                            Object var24_26 = null;
                            if (rpcConnection == null) return tempFileInputStream;
                            break block15;
                        }
                        inputStream = null;
                        break block16;
                    }
                    catch (BufferOverflowException exc) {
                        Log.error("RPC Buffer overflow: " + exc.getLocalizedMessage());
                        Log.exception(exc);
                        throw new P4JavaError("RPC Buffer overflow: " + exc.getLocalizedMessage());
                    }
                    catch (ConnectionNotConnectedException cnce) {
                        this.connected = false;
                        this.status = ServerStatus.ERROR;
                        throw cnce;
                    }
                    catch (IOException ioexc) {
                        Log.error("RPC I/O error: " + ioexc.getLocalizedMessage());
                        Log.exception(ioexc);
                        throw new RequestException("I/O error encountered in stream command: " + ioexc.getLocalizedMessage(), ioexc);
                    }
                }
                catch (Throwable throwable) {
                    Object var24_28 = null;
                    if (rpcConnection == null) throw throwable;
                    rpcConnection.disconnect(dispatcher);
                    throw throwable;
                }
            }
            rpcConnection.disconnect(dispatcher);
            return tempFileInputStream;
        }
        Object var24_27 = null;
        if (rpcConnection == null) return inputStream;
        rpcConnection.disconnect(dispatcher);
        return inputStream;
    }

    private ExternalEnv setupCmd(RpcPacketDispatcher dispatcher, RpcConnection rpcConnection, ProtocolCommand protocolSpecs, String cmdName, String[] cmdArgs, Map<String, Object> inMap, boolean ignoreCallbacks, int cmdCallBackKey, boolean isStream) throws ConnectionException, AccessException, RequestException {
        if (rpcConnection == null) {
            throw new NullPointerError("Null RPC connection in execMapCmd call");
        }
        if (dispatcher == null) {
            throw new NullPointerError("Null RPC dispatcher in execMapCmd call");
        }
        if (protocolSpecs == null) {
            throw new NullPointerError("Null RPC protocol specs in execMapCmd call");
        }
        if (!CmdSpec.isValidP4JCmdSpec(cmdName)) {
            throw new RequestException("command name '" + cmdName + "' unimplemented or unrecognized by p4java");
        }
        ExternalEnv env = new ExternalEnv(this.getUsageOptions().getProgramName(), this.getUsageOptions().getProgramVersion(), this.getClientNameForEnv(), this.getUsageOptions().getWorkingDirectory(), this.getHostForEnv(), this.getUsageOptions().getTextLanguage(), this.getOsTypeForEnv(), this.getUserForEnv(), this.charsetName != null, this.charset);
        if (!ignoreCallbacks && this.commandCallback != null) {
            StringBuilder cmd = new StringBuilder(cmdName);
            for (String argStr : cmdArgs) {
                if (argStr == null) continue;
                cmd.append(" ");
                cmd.append(argStr);
            }
            this.commandCallback.issuingServerCommand(cmdCallBackKey, cmd.toString());
        }
        RpcPacket protPacket = null;
        protocolSpecs.setClientApiLevel(this.clientApiLevel);
        protocolSpecs.setClientCmpFile(false);
        protocolSpecs.setServerApiLevel(this.serverApiLevel);
        protocolSpecs.setSendBufSize(rpcConnection.getSystemSendBufferSize());
        protocolSpecs.setRecvBufSize(rpcConnection.getSystemRecvBufferSize());
        protocolSpecs.setUseTags(this.useTags(cmdName, cmdArgs, isStream));
        protPacket = RpcPacket.constructRpcPacket(RpcFunctionSpec.PROTOCOL_PROTOCOL, protocolSpecs.asMap(), null);
        RpcFunctionSpec name = RpcFunctionSpec.decodeFromEndUserCmd(cmdName);
        RpcPacket cmdPacket = RpcPacket.constructRpcPacket(name, cmdArgs, env);
        if (protPacket == null) {
            rpcConnection.putRpcPacket(cmdPacket);
        } else {
            rpcConnection.putRpcPackets(new RpcPacket[]{protPacket, cmdPacket});
        }
        return env;
    }

    private boolean useTags(String cmdName, String[] cmdArgs, boolean isStreamCmd) {
        if (cmdName != null && isStreamCmd) {
            if (cmdName.equalsIgnoreCase("describe")) {
                return false;
            }
            if (cmdName.equalsIgnoreCase("diff2")) {
                return false;
            }
        }
        return true;
    }
}

