/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.generic.core;

import com.perforce.p4java.Log;
import com.perforce.p4java.core.IUserGroup;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.core.ServerResource;
import com.perforce.p4java.server.IServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroup
extends ServerResource
implements IUserGroup {
    public static final String UNSET_STR = "unset";
    public static final String UNLIMITED_STR = "unlimited";
    private String name = null;
    private int maxResults = 0;
    private int maxScanRows = 0;
    private int maxLockTime = 0;
    private int timeout = 0;
    private boolean subGroup = false;
    private List<String> subgroups = null;
    private List<String> owners = null;
    private List<String> users = null;

    public UserGroup() {
        super(true, true);
    }

    public UserGroup(Map<String, Object> map) {
        super(true, true);
        if (map != null) {
            try {
                this.name = (String)map.get("Group");
                this.maxLockTime = this.parseGroupIntValue((String)map.get("MaxLockTime"));
                this.maxResults = this.parseGroupIntValue((String)map.get("MaxResults"));
                this.maxScanRows = this.parseGroupIntValue((String)map.get("MaxScanRows"));
                this.timeout = this.parseGroupIntValue((String)map.get("Timeout"));
                String key = "Users";
                int i = 0;
                while (map.containsKey(key + i)) {
                    if (this.users == null) {
                        this.users = new ArrayList<String>();
                    }
                    this.users.add((String)map.get(key + i));
                    ++i;
                }
                key = "Owners";
                i = 0;
                while (map.containsKey(key + i)) {
                    if (this.owners == null) {
                        this.owners = new ArrayList<String>();
                    }
                    this.owners.add((String)map.get(key + i));
                    ++i;
                }
                key = "Subgroups";
                i = 0;
                while (map.containsKey(key + i)) {
                    if (this.subgroups == null) {
                        this.subgroups = new ArrayList<String>();
                    }
                    this.subgroups.add((String)map.get(key + i));
                    ++i;
                }
            }
            catch (Throwable thr) {
                Log.warn("Unexpected exception in UserGroup constructor: " + thr.getMessage());
                Log.exception(thr);
            }
        }
    }

    @Override
    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public int getMaxScanRows() {
        return this.maxScanRows;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getOwners() {
        return this.owners;
    }

    @Override
    public List<String> getSubgroups() {
        return this.subgroups;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public boolean isSubGroup() {
        return this.subGroup;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public void setMaxScanRows(int maxScanRows) {
        this.maxScanRows = maxScanRows;
    }

    @Override
    public void setMaxLockTime(int maxLockTime) {
        this.maxLockTime = maxLockTime;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setSubgroups(List<String> subgroups) {
        this.subgroups = subgroups;
    }

    @Override
    public void setOwners(List<String> owners) {
        this.owners = owners;
    }

    @Override
    public void setUsers(List<String> users) {
        this.users = users;
    }

    @Override
    public void setSubGroup(boolean subGroup) {
        this.subGroup = subGroup;
    }

    public int parseGroupIntValue(String str) {
        if (str != null) {
            if (str.equalsIgnoreCase(UNSET_STR)) {
                return 0;
            }
            if (str.equalsIgnoreCase(UNLIMITED_STR)) {
                return -1;
            }
            return new Integer(str);
        }
        return 0;
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IUserGroup refreshedUserGroup;
        IServer refreshServer = this.server;
        String refreshName = this.getName();
        if (refreshServer != null && refreshName != null && (refreshedUserGroup = refreshServer.getUserGroup(refreshName)) != null) {
            this.maxLockTime = refreshedUserGroup.getMaxLockTime();
            this.name = refreshedUserGroup.getName();
            this.maxResults = refreshedUserGroup.getMaxResults();
            this.maxScanRows = refreshedUserGroup.getMaxScanRows();
            this.owners = refreshedUserGroup.getOwners();
            this.subGroup = refreshedUserGroup.isSubGroup();
            this.timeout = refreshedUserGroup.getTimeout();
            this.subgroups = refreshedUserGroup.getSubgroups();
            this.users = refreshedUserGroup.getUsers();
        }
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        this.server.updateUserGroup(this, false);
    }
}

