/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.server;

import java.util.HashMap;
import java.util.Map;

public class P4JServerCharsets {
    private static final String[] knownCharsets = new String[]{"none", "utf8", "iso8859-1", "shiftjis", "eucjp", "winansi", "cp949", "macosroman", "iso8859-15", "iso8859-5", "koi8-r", "cp1251", "utf16le", "utf16be", "utf16"};
    private static final Map<String, String> p4ToJavaCharsets = new HashMap<String, String>();

    public static String[] getKnownCharsets() {
        return knownCharsets;
    }

    public static String getJavaCharsetName(String p4CharsetName) {
        String javaCharsetName = null;
        if (p4CharsetName != null) {
            javaCharsetName = p4ToJavaCharsets.get(p4CharsetName);
        }
        return javaCharsetName;
    }

    public static boolean isSupported(String p4CharsetName) {
        boolean supported = false;
        if (p4CharsetName != null) {
            supported = p4ToJavaCharsets.containsKey(p4CharsetName);
        }
        return supported;
    }

    static {
        p4ToJavaCharsets.put(knownCharsets[0], "none");
        p4ToJavaCharsets.put(knownCharsets[1], "UTF-8");
        p4ToJavaCharsets.put(knownCharsets[2], "ISO-8859-1");
        p4ToJavaCharsets.put(knownCharsets[3], "Shift_JIS");
        p4ToJavaCharsets.put(knownCharsets[4], "EUC-JP");
        p4ToJavaCharsets.put(knownCharsets[5], "windows-1252");
        p4ToJavaCharsets.put(knownCharsets[6], "x-IBM949");
        p4ToJavaCharsets.put(knownCharsets[7], "x-MacRoman");
        p4ToJavaCharsets.put(knownCharsets[8], "ISO-8859-15");
        p4ToJavaCharsets.put(knownCharsets[9], "ISO-8859-5");
        p4ToJavaCharsets.put(knownCharsets[10], "KOI8-R");
        p4ToJavaCharsets.put(knownCharsets[11], "windows-1251");
        p4ToJavaCharsets.put(knownCharsets[12], "UTF-16LE");
        p4ToJavaCharsets.put(knownCharsets[13], "UTF-16BE");
        p4ToJavaCharsets.put(knownCharsets[14], "UTF-16");
    }
}

