/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.packet;

import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.exception.P4JProtocolError;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacket;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class P4JRpcPacketPreamble {
    public static final int RPC_PREAMBLE_CHKSUM_SIZE = 1;
    public static final int RPC_PREAMBLE_SIZE = 5;
    private byte[] preLengthBytes = null;
    private byte[] preChksumBytes = null;

    public static P4JRpcPacketPreamble constructPreamble(ByteBuffer payload) {
        return new P4JRpcPacketPreamble(payload.position());
    }

    public static P4JRpcPacketPreamble constructPreamble(int payloadLength) {
        return new P4JRpcPacketPreamble(payloadLength);
    }

    public static P4JRpcPacketPreamble retrievePreamble(ByteBuffer payload) {
        if (payload == null) {
            throw new P4JNullPointerError("Null payload buffer passed to P4JRpcPacketPreamble.retrievePreamble()");
        }
        byte[] bytes = new byte[5];
        try {
            payload.get(bytes);
        }
        catch (BufferUnderflowException bue) {
            throw new P4JProtocolError(bue.getLocalizedMessage(), bue);
        }
        return new P4JRpcPacketPreamble(bytes);
    }

    public static P4JRpcPacketPreamble retrievePreamble(byte[] bytes) {
        return new P4JRpcPacketPreamble(bytes);
    }

    private P4JRpcPacketPreamble(ByteBuffer payload) {
        if (payload == null) {
            throw new P4JNullPointerError("Null payload buffer passed to P4JRpcPacketPreamble constructor");
        }
        this.preChksumBytes = new byte[1];
        this.preLengthBytes = P4JRpcPacket.encodeInt4(payload.position());
        this.preChksumBytes[0] = (byte)(this.preLengthBytes[0] ^ this.preLengthBytes[1] ^ this.preLengthBytes[2] ^ this.preLengthBytes[3]);
    }

    private P4JRpcPacketPreamble(int length) {
        this.preChksumBytes = new byte[1];
        this.preLengthBytes = P4JRpcPacket.encodeInt4(length);
        this.preChksumBytes[0] = (byte)(this.preLengthBytes[0] ^ this.preLengthBytes[1] ^ this.preLengthBytes[2] ^ this.preLengthBytes[3]);
    }

    private P4JRpcPacketPreamble(byte[] bytes) {
        if (bytes == null) {
            throw new P4JNullPointerError("Null payload bytes passed to P4JRpcPacketPreamble constructor");
        }
        if (bytes.length != 5) {
            throw new P4JError("Incorrect byte array size passed to P4JRpcPacketPreamble constructor: " + bytes.length);
        }
        this.preChksumBytes = new byte[1];
        this.preChksumBytes[0] = bytes[0];
        this.preLengthBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.preLengthBytes[i] = bytes[i + 1];
        }
    }

    public int getPayloadSize() {
        return P4JRpcPacket.decodeInt4(this.preLengthBytes);
    }

    public boolean isValidChecksum() {
        return this.preChksumBytes[0] == (this.preLengthBytes[0] ^ this.preLengthBytes[1] ^ this.preLengthBytes[2] ^ this.preLengthBytes[3]);
    }

    public ByteBuffer marshal() {
        return ByteBuffer.allocate(5).put(this.preChksumBytes).put(this.preLengthBytes);
    }

    public byte[] marshalAsBytes() {
        byte[] retVal = new byte[5];
        retVal[0] = this.preChksumBytes[0];
        for (int i = 0; i < 4; ++i) {
            retVal[i + 1] = this.preLengthBytes[i];
        }
        return retVal;
    }
}

