/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.func;

import com.perforce.p4java.P4JCharset;
import com.perforce.p4java.P4JLog;
import com.perforce.p4java.exception.P4JError;
import com.perforce.p4java.exception.P4JNullPointerError;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunction;
import com.perforce.p4java.impl.mapbased.rpc.func.P4JRpcFunctionType;
import com.perforce.p4java.impl.mapbased.rpc.packet.P4JRpcPacketField;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum P4JRpcFunctionSpec {
    NONE,
    PROTOCOL_PROTOCOL,
    PROTOCOL_FLUSH1,
    PROTOCOL_FLUSH2,
    PROTOCOL_RELEASE,
    PROTOCOL_RELEASE2,
    PROTOCOL_CRYPTO,
    PROTOCOL_COMPRESS1,
    PROTOCOL_COMPRESS2,
    USER_DEPOTS,
    USER_INFO,
    USER_FILES,
    USER_CLIENTS,
    USER_JOBS,
    USER_CHANGES,
    USER_LOGIN,
    USER_LOGOUT,
    USER_CLIENT,
    USER_FSTAT,
    USER_SYNC,
    USER_CHANGE,
    USER_DESCRIBE,
    USER_OPENED,
    USER_EDIT,
    USER_ADD,
    USER_DELETE,
    USER_REVERT,
    USER_SUBMIT,
    USER_FILELOG,
    USER_PRINT,
    USER_WHERE,
    USER_HAVE,
    USER_REOPEN,
    USER_DIRS,
    USER_INTEG,
    USER_RESOLVE,
    USER_RESOLVED,
    USER_FIXES,
    USER_JOBSPEC,
    USER_FIX,
    USER_JOB,
    USER_LOCK,
    USER_UNLOCK,
    USER_DIFF,
    USER_COUNTERS,
    USER_USERS,
    USER_MOVE,
    USER_LABELS,
    USER_LABEL,
    USER_LABELSYNC,
    USER_TAG,
    USER_MONITOR,
    USER_GROUP,
    USER_GROUPS,
    USER_BRANCH,
    USER_BRANCHES,
    USER_COUNTER,
    USER_INTEGRATED,
    CLIENT_MESSAGE,
    CLIENT_FSTATINFO,
    CLIENT_PROMPT,
    CLIENT_SETPASSWORD,
    CLIENT_CRYPTO,
    CLIENT_ACK,
    CLIENT_CHMODFILE,
    CLIENT_OPENFILE,
    CLIENT_OPENDIFF,
    CLIENT_WRITEFILE,
    CLIENT_CLOSEFILE,
    CLIENT_CHECKFILE,
    CLIENT_INPUTDATA,
    CLIENT_SENDFILE,
    CLIENT_DELETEFILE,
    CLIENT_OUTPUTBINARY,
    CLIENT_OUTPUTTEXT,
    CLIENT_MOVEFILE,
    CLIENT_OPENMERGE3,
    CLIENT_WRITEMERGE,
    CLIENT_CLOSEMERGE,
    CLIENT_SSO,
    CLIENT_DM_PROMPT,
    CLIENT_DM_OPENFILE,
    CLIENT_DM_MOVEFILE,
    SERVER_DM_LOGIN,
    SERVER_DM_SUBMITCHANGE,
    SERVER_LBR_OPEN,
    SERVER_DM_LBR_OPEN,
    SERVER_LBR_WRITEFILE,
    SERVER_DM_SUBMITFILE,
    SERVER_DM_COMMITSUBMIT,
    SERVER_RELEASEFILE,
    SERVER_CMPFILE,
    SERVER_DM_RESOLVEDFILE,
    SERVER_DM_RESOLVEDFAILED;


    public static P4JRpcFunctionSpec decode(String str) {
        if (str == null) {
            throw new P4JNullPointerError("Null string passed to P4JRpcFunction.decode()");
        }
        return P4JRpcFunction.getMetadata(str).getName();
    }

    public static P4JRpcFunctionSpec decodeFromEndUserCmd(String str) {
        if (str == null) {
            throw new P4JNullPointerError("Null string passed to P4JRpcFunction.decodeFromEndUserCmd()");
        }
        return P4JRpcFunctionSpec.decode(P4JRpcFunctionType.USER.getEncodingPrefix() + str);
    }

    public String getEncoding() {
        return P4JRpcFunction.getMetadata(this).getEncoding();
    }

    public P4JRpcFunctionType getType() {
        return P4JRpcFunction.getMetadata(this).getType();
    }

    public void marshal(ByteBuffer buf) {
        if (buf == null) {
            throw new P4JNullPointerError("Null byte buffer passed to P4JRpcFunctionName.marshal()");
        }
        try {
            P4JRpcPacketField.marshal(buf, "func", this.getEncoding().getBytes(P4JCharset.DEFAULT.name()));
        }
        catch (UnsupportedEncodingException uee) {
            P4JLog.exception(uee);
            throw new P4JError(uee);
        }
    }
}

